﻿---
title: Attempted Bypass of Okta MFA
description: Detects attempts to bypass Okta multi-factor authentication (MFA). An adversary may attempt to bypass the Okta MFA policies configured for an organization...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/credential_access_attempted_bypass_of_okta_mfa
products:
  - Elastic Security
---

# Attempted Bypass of Okta MFA
Detects attempts to bypass Okta multi-factor authentication (MFA). An adversary may attempt to bypass the Okta MFA
policies configured for an organization in order to obtain unauthorized access to an application.
**Rule type**: query
**Rule indices**:
- filebeat-*
- logs-okta*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: ``
**Maximum alerts per execution**: 100
**References**:
- [[https://developer.okta.com/docs/reference/api/system-log/](https://developer.okta.com/docs/reference/api/system-log/)](https://developer.okta.com/docs/reference/api/system-log/)
- [[https://developer.okta.com/docs/reference/api/event-types/](https://developer.okta.com/docs/reference/api/event-types/)](https://developer.okta.com/docs/reference/api/event-types/)
- [[https://www.elastic.co/security-labs/testing-okta-visibility-and-detection-dorothy](https://www.elastic.co/security-labs/testing-okta-visibility-and-detection-dorothy)](https://www.elastic.co/security-labs/testing-okta-visibility-and-detection-dorothy)
- [[https://www.elastic.co/security-labs/monitoring-okta-threats-with-elastic-security](https://www.elastic.co/security-labs/monitoring-okta-threats-with-elastic-security)](https://www.elastic.co/security-labs/monitoring-okta-threats-with-elastic-security)
- [[https://www.elastic.co/security-labs/okta-and-lapsus-what-you-need-to-know](https://www.elastic.co/security-labs/okta-and-lapsus-what-you-need-to-know)](https://www.elastic.co/security-labs/okta-and-lapsus-what-you-need-to-know)
- [[https://www.elastic.co/security-labs/starter-guide-to-understanding-okta](https://www.elastic.co/security-labs/starter-guide-to-understanding-okta)](https://www.elastic.co/security-labs/starter-guide-to-understanding-okta)

**Tags**:
- Data Source: Okta
- Use Case: Identity and Access Audit
- Tactic: Credential Access
- Resources: Investigation Guide

**Version**: 414
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating Attempted Bypass of Okta MFA

Multi-factor authentication (MFA) is a crucial security measure in preventing unauthorized access. Okta MFA, like other MFA solutions, requires the user to provide multiple means of identification at login. An adversary might attempt to bypass Okta MFA to gain unauthorized access to an application.
This rule detects attempts to bypass Okta MFA. It might indicate a serious attempt to compromise a user account within the organization's network.

#### Possible investigation steps

- Identify the actor related to the alert by reviewing `okta.actor.id`, `okta.actor.type`, `okta.actor.alternate_id`, or `okta.actor.display_name` fields in the alert.
- Review the `okta.client.user_agent.raw_user_agent` field to understand the device and software used by the actor.
- Examine the `okta.outcome.reason` field for additional context around the bypass attempt.
- Check the `okta.outcome.result` field to confirm the MFA bypass attempt.
- Check if there are multiple unsuccessful MFA attempts from the same actor or IP address (`okta.client.ip`).
- Check for successful logins immediately following the MFA bypass attempt.
- Verify whether the actor's activity aligns with typical behavior or if any unusual activity took place around the time of the bypass attempt.


### False positive analysis

- Check if there were issues with the MFA system at the time of the bypass attempt. This could indicate a system error rather than a genuine bypass attempt.
- Check the geographical location (`okta.request.ip_chain.geographical_context`) and time of the login attempt. If these match the actor's normal behavior, it might be a false positive.
- Verify the actor's MFA settings to ensure they are correctly configured.


### Response and remediation

- If unauthorized access is confirmed, initiate the incident response process.
- Immediately lock the affected actor account and require a password change.
- Consider resetting MFA tokens for the actor and require re-enrollment.
- Check if the compromised account was used to access or alter any sensitive data or systems.
- If a specific MFA bypass technique was used, ensure your systems are patched or configured to prevent such techniques.
- Assess the criticality of affected services and servers.
- Work with your IT team to minimize the impact on users and maintain business continuity.
- If multiple accounts are affected, consider a broader reset or audit of MFA tokens.
- Implement security best practices [outlined](https://www.okta.com/blog/2019/10/9-admin-best-practices-to-keep-your-org-secure/) by Okta.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Setup

The Okta Fleet integration, Filebeat module, or similarly structured data is required to be compatible with this rule.

## Rule Query

```kuery
event.dataset:okta.system and event.action:user.mfa.attempt_bypass
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: Multi-Factor Authentication Interception
- Id: T1111
- Reference URL: [[https://attack.mitre.org/techniques/T1111/](https://attack.mitre.org/techniques/T1111/)](https://attack.mitre.org/techniques/T1111/)