﻿---
title: M365 Exchange Mailbox High-Risk Permission Delegated
description: Identifies the assignment of rights to access content from another mailbox. An adversary may use the compromised account to send messages to other accounts...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/persistence_exchange_suspicious_mailbox_permission_delegation
products:
  - Elastic Security
---

# M365 Exchange Mailbox High-Risk Permission Delegated
Identifies the assignment of rights to access content from another mailbox. An adversary may use the compromised account
to send messages to other accounts in the network of the target organization while creating inbox rules, so messages can
evade spam/phishing detection mechanisms.
**Rule type**: new_terms
**Rule indices**:
- filebeat-*
- logs-o365.audit-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: ``
**Maximum alerts per execution**: 100
**References**:
- [[https://learn.microsoft.com/en-us/microsoft-365/admin/add-users/give-mailbox-permissions-to-another-user?view=o365-worldwide](https://learn.microsoft.com/en-us/microsoft-365/admin/add-users/give-mailbox-permissions-to-another-user?view=o365-worldwide)](https://learn.microsoft.com/en-us/microsoft-365/admin/add-users/give-mailbox-permissions-to-another-user?view=o365-worldwide)

**Tags**:
- Domain: Cloud
- Domain: SaaS
- Data Source: Microsoft 365
- Data Source: Microsoft Exchange
- Data Source: Microsoft 365 Audit Logs
- Use Case: Configuration Audit
- Tactic: Persistence
- Resources: Investigation Guide

**Version**: 212
**Rule authors**:
- Elastic
- Austin Songer

**Rule license**: Elastic License v2

## Investigation guide


## Triage and Analysis


### Investigating M365 Exchange Mailbox High-Risk Permission Delegated

This rule detects the delegation of mailbox permissions in Microsoft 365 Exchange. This behavior may indicate that an adversary is attempting to gain access to another user's mailbox or send messages on behalf of that user.

### Possible Investigation Steps

- `user.id` and `o365.audit.Parameters.Identity`: Determine which account was delegated access and which account performed the delegation. Review both for unusual activity.
- `event.action`: Indicates the type of permission granted. Review which delegation action was taken.
- `o365.audit.Parameters.AccessRights` or `GrantSendOnBehalfTo`: Confirm the exact permission granted.
- `@timestamp` and `event.ingested`: Review the timing of the delegation and whether it aligns with user activity or known business events.
- `source.ip` and `source.geo`: Validate that the source IP and location are expected for the admin or account performing the action.
- `user_agent.original`: If present, review to identify any automation, script, or unexpected interface used to assign the permissions.


#### FullAccess (`Add-MailboxPermission`)

- `o365.audit.Parameters.Identity`: The mailbox being accessed.
- `o365.audit.Parameters.User`: The user granted FullAccess.
- Review for subsequent mailbox logins or message rules created by the grantee.


#### SendAs (`Add-RecipientPermission`)

- `o365.audit.Parameters.Identity`: The account the grantee is allowed to impersonate.
- `o365.audit.Parameters.Trustee`: The user who was granted the ability to send as the identity.
- Search for recent messages sent "as" the identity and validate whether the activity was legitimate.


#### SendOnBehalf (`Set-Mailbox`)

- `o365.audit.Parameters.GrantSendOnBehalfTo`: The user allowed to send on behalf of the mailbox owner.
- Check for outbound emails or meeting requests with "on behalf of" headers.


### False Positive Analysis

- Delegation to Assistants: Executive or admin assistants often receive FullAccess or SendOnBehalf permissions.
- Shared Mailboxes: Teams or departments may share access to mailboxes for operational efficiency.
- Automated Admin Actions: System or service accounts may perform these actions as part of onboarding or automation.
- Project-Based Access: Temporary access granted for short-term collaboration.
- Maintain an allowlist of known delegation relationships.


### Response and Remediation

If the delegation is determined to be unauthorized or suspicious:
- Revoke the delegated permissions immediately to prevent further access.
- Reset credentials for the impacted accounts if compromise is suspected.
- Review mailbox rules and sent items to detect abuse.
- Alert impacted users and advise on suspicious activity to watch for.
- Audit audit logs around the delegation for additional attacker actions (e.g., MFA disablement, mailbox rule creation, login from foreign IPs).
- Review conditional access, role-based access control, and app permissions to reduce the attack surface.
- Harden delegation policies by requiring approvals, limiting delegation to specific groups, or implementing Just-in-Time (JIT) access for mailboxes.


## Rule Query

```kuery
event.dataset: "o365.audit" and
event.provider: "Exchange" and
event.outcome: "success" and
not o365.audit.UserType : (3 or 4) and
(
    (event.action: "Add-MailboxPermission" and o365.audit.Parameters.AccessRights: "FullAccess") or
    (event.action: "Add-RecipientPermission" and o365.audit.Parameters.AccessRights: "SendAs") or
    (event.action: "Set-Mailbox" and o365.audit.Parameters.GrantSendOnBehalfTo: *)
) and
not user.id:(
    "NT AUTHORITY\SYSTEM (Microsoft.Exchange.ServiceHost)" or
    "NT AUTHORITY\SYSTEM (Microsoft.Exchange.AdminApi.NetCore)" or
    "NT AUTHORITY\SYSTEM (w3wp)"
    )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Account Manipulation
- Id: T1098
- Reference URL: [[https://attack.mitre.org/techniques/T1098/](https://attack.mitre.org/techniques/T1098/)](https://attack.mitre.org/techniques/T1098/)
- Sub Technique:
  - Name: Additional Email Delegate Permissions
- Id: T1098.002
- Reference URL: [[https://attack.mitre.org/techniques/T1098/002/](https://attack.mitre.org/techniques/T1098/002/)](https://attack.mitre.org/techniques/T1098/002/)