﻿---
title: M365 SharePoint Malware File Detected
description: Identifies the occurence of files uploaded to SharePoint being detected as Malware by the file scanning engine. Attackers can use File Sharing and Organization...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/lateral_movement_sharepoint_malware_uploaded
products:
  - Elastic Security
---

# M365 SharePoint Malware File Detected
Identifies the occurence of files uploaded to SharePoint being detected as Malware by the file scanning engine.
Attackers can use File Sharing and Organization Repositories to spread laterally within the company and amplify their
access. Users can inadvertently share these files without knowing their maliciousness, giving adversaries opportunities
to gain initial access to other endpoints in the environment.
**Rule type**: query
**Rule indices**:
- logs-o365.audit-*
- filebeat-*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://docs.microsoft.com/en-us/microsoft-365/security/office-365-security/virus-detection-in-spo?view=o365-worldwide](https://docs.microsoft.com/en-us/microsoft-365/security/office-365-security/virus-detection-in-spo?view=o365-worldwide)](https://docs.microsoft.com/en-us/microsoft-365/security/office-365-security/virus-detection-in-spo?view=o365-worldwide)

**Tags**:
- Domain: Cloud
- Data Source: Microsoft 365
- Tactic: Lateral Movement
- Resources: Investigation Guide

**Version**: 211
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating M365 SharePoint Malware File Detected

SharePoint, a collaborative platform, facilitates file sharing and storage within organizations. Adversaries exploit this by uploading malware, leveraging the platform's sharing capabilities to propagate threats laterally. The detection rule identifies when SharePoint's file scanning engine flags an upload as malicious, focusing on specific audit events to alert security teams of potential lateral movement threats.

### Possible investigation steps

- Review the specific event details in the alert, focusing on the event.dataset, event.provider, event.code, and event.action fields to confirm the alert is related to a SharePoint file upload flagged as malware.
- Identify the user account associated with the file upload by examining the audit logs and determine if the account has a history of suspicious activity or if it has been compromised.
- Analyze the file metadata, including the file name, type, and size, to gather more context about the nature of the uploaded file and assess its potential impact.
- Check the file's sharing permissions and access history to identify other users or systems that may have interacted with the file, assessing the risk of lateral movement.
- Investigate the source of the file upload, such as the originating IP address or device, to determine if it aligns with known malicious activity or if it is an anomaly for the user.
- Coordinate with the IT team to isolate affected systems or accounts if necessary, and initiate a response plan to mitigate any potential spread of the malware within the organization.


### False positive analysis

- Legitimate software updates or patches uploaded to SharePoint may be flagged as malware. To handle this, create exceptions for known update files by verifying their source and hash.
- Internal security tools or scripts used for testing purposes might trigger false positives. Maintain a list of these tools and exclude them from alerts after confirming their legitimacy.
- Files with encrypted content, such as password-protected documents, can be mistakenly identified as malicious. Implement a process to review and whitelist these files if they are from trusted sources.
- Large batch uploads from trusted departments, like IT or HR, may occasionally be flagged. Establish a review protocol for these uploads and whitelist them if they are verified as safe.
- Files with macros or executable content used in legitimate business processes might be detected. Work with relevant departments to identify and exclude these files from alerts after thorough validation.


### Response and remediation

- Immediately isolate the affected SharePoint site or library to prevent further access and sharing of the malicious file. This can be done by restricting permissions or temporarily disabling access to the site.
- Notify the security operations team and relevant stakeholders about the detected malware to ensure awareness and initiate a coordinated response.
- Quarantine the identified malicious file to prevent it from being accessed or executed by users. Use SharePoint's built-in capabilities or integrated security tools to move the file to a secure location.
- Conduct a thorough scan of the affected SharePoint site and connected systems to identify any additional malicious files or indicators of compromise. Use advanced threat detection tools to ensure comprehensive coverage.
- Review and revoke any unauthorized access or sharing permissions that may have been granted to the malicious file, ensuring that only legitimate users have access to sensitive data.
- Escalate the incident to the incident response team if there are signs of lateral movement or if the malware has spread to other parts of the network, following the organization's escalation protocols.
- Implement enhanced monitoring and logging for SharePoint and related services to detect any future attempts to upload or share malicious files, leveraging the specific query fields used in the detection rule.


## Setup

The Office 365 Logs Fleet integration, Filebeat module, or similarly structured data is required to be compatible with this rule.

## Rule Query

```kuery
event.dataset:o365.audit and event.provider:SharePoint and event.code:SharePointFileOperation and event.action:FileMalwareDetected
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Lateral Movement
- Id: TA0008
- Reference URL: [[https://attack.mitre.org/tactics/TA0008/](https://attack.mitre.org/tactics/TA0008/)](https://attack.mitre.org/tactics/TA0008/)
- Technique:
  - Name: Taint Shared Content
- Id: T1080
- Reference URL: [[https://attack.mitre.org/techniques/T1080/](https://attack.mitre.org/techniques/T1080/)](https://attack.mitre.org/techniques/T1080/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Resource Development
- Id: TA0042
- Reference URL: [[https://attack.mitre.org/tactics/TA0042/](https://attack.mitre.org/tactics/TA0042/)](https://attack.mitre.org/tactics/TA0042/)
- Technique:
  - Name: Stage Capabilities
- Id: T1608
- Reference URL: [[https://attack.mitre.org/techniques/T1608/](https://attack.mitre.org/techniques/T1608/)](https://attack.mitre.org/techniques/T1608/)
- Sub Technique:
  - Name: Upload Malware
- Id: T1608.001
- Reference URL: [[https://attack.mitre.org/techniques/T1608/001/](https://attack.mitre.org/techniques/T1608/001/)](https://attack.mitre.org/techniques/T1608/001/)