﻿---
title: M365 OneDrive Malware File Upload
description: Identifies the occurence of files uploaded to OneDrive being detected as Malware by the file scanning engine. Attackers can use File Sharing and Organization...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/lateral_movement_onedrive_malware_uploaded
products:
  - Elastic Security
---

# M365 OneDrive Malware File Upload
Identifies the occurence of files uploaded to OneDrive being detected as Malware by the file scanning engine. Attackers
can use File Sharing and Organization Repositories to spread laterally within the company and amplify their access.
Users can inadvertently share these files without knowing their maliciousness, giving adversaries opportunity to gain
initial access to other endpoints in the environment.
**Rule type**: query
**Rule indices**:
- logs-o365.audit-*
- filebeat-*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://docs.microsoft.com/en-us/microsoft-365/security/office-365-security/virus-detection-in-spo?view=o365-worldwide](https://docs.microsoft.com/en-us/microsoft-365/security/office-365-security/virus-detection-in-spo?view=o365-worldwide)](https://docs.microsoft.com/en-us/microsoft-365/security/office-365-security/virus-detection-in-spo?view=o365-worldwide)

**Tags**:
- Domain: Cloud
- Data Source: Microsoft 365
- Tactic: Lateral Movement
- Resources: Investigation Guide

**Version**: 211
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating M365 OneDrive Malware File Upload

OneDrive, a cloud storage service, facilitates file sharing and collaboration within organizations. However, adversaries can exploit this by uploading malware, which can spread across shared environments, leading to lateral movement within a network. The detection rule identifies such threats by monitoring OneDrive activities for malware detection events, focusing on file operations flagged by Microsoft's security engine. This proactive approach helps in identifying and mitigating potential breaches.

### Possible investigation steps

- Review the alert details to confirm the event dataset is 'o365.audit' and the event provider is 'OneDrive' to ensure the alert is relevant to OneDrive activities.
- Examine the specific file operation flagged by the event code 'SharePointFileOperation' and action 'FileMalwareDetected' to identify the file in question and understand the nature of the detected malware.
- Identify the user account associated with the file upload to determine if the account has been compromised or if the user inadvertently uploaded the malicious file.
- Check the sharing settings of the affected file to assess the extent of exposure and identify any other users or systems that may have accessed the file.
- Investigate the file's origin and history within the organization to trace how it was introduced into the environment and whether it has been shared or accessed by other users.
- Review any additional security alerts or logs related to the user account or file to identify potential patterns of malicious activity or further compromise.
- Coordinate with IT and security teams to isolate the affected file and user account, and initiate remediation steps to prevent further spread of the malware.


### False positive analysis

- Legitimate software updates or patches may be flagged as malware if they are not yet recognized by the security engine. Users should verify the source and integrity of the file and consider adding it to an exception list if confirmed safe.
- Files containing scripts or macros used for automation within the organization might trigger false positives. Review the file's purpose and origin, and whitelist it if it is a known and trusted internal tool.
- Shared files from trusted partners or vendors could be mistakenly identified as threats. Establish a process to verify these files with the sender and use exceptions for recurring, verified files.
- Archived or compressed files that contain known safe content might be flagged due to their format. Decompress and scan the contents separately to confirm their safety before adding exceptions.
- Files with unusual or encrypted content used for legitimate business purposes may be misclassified. Ensure these files are documented and approved by IT security before excluding them from alerts.


### Response and remediation

- Immediately isolate the affected OneDrive account to prevent further file sharing and potential spread of malware within the organization.
- Notify the user associated with the account about the detected malware and instruct them to cease any file sharing activities until further notice.
- Conduct a thorough scan of the affected files using an updated antivirus or endpoint detection and response (EDR) solution to confirm the presence of malware and identify any additional infected files.
- Remove or quarantine the identified malicious files from OneDrive and any other locations they may have been shared to prevent further access or execution.
- Review and revoke any shared links or permissions associated with the infected files to ensure no unauthorized access is possible.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine if any lateral movement or additional compromise has occurred.
- Implement enhanced monitoring and alerting for similar OneDrive activities to quickly detect and respond to any future malware uploads or related threats.


## Setup

The Office 365 Logs Fleet integration, Filebeat module, or similarly structured data is required to be compatible with this rule.

## Rule Query

```kuery
event.dataset:o365.audit and event.provider:OneDrive and event.code:SharePointFileOperation and event.action:FileMalwareDetected
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Lateral Movement
- Id: TA0008
- Reference URL: [[https://attack.mitre.org/tactics/TA0008/](https://attack.mitre.org/tactics/TA0008/)](https://attack.mitre.org/tactics/TA0008/)
- Technique:
  - Name: Taint Shared Content
- Id: T1080
- Reference URL: [[https://attack.mitre.org/techniques/T1080/](https://attack.mitre.org/techniques/T1080/)](https://attack.mitre.org/techniques/T1080/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Resource Development
- Id: TA0042
- Reference URL: [[https://attack.mitre.org/tactics/TA0042/](https://attack.mitre.org/tactics/TA0042/)](https://attack.mitre.org/tactics/TA0042/)
- Technique:
  - Name: Stage Capabilities
- Id: T1608
- Reference URL: [[https://attack.mitre.org/techniques/T1608/](https://attack.mitre.org/techniques/T1608/)](https://attack.mitre.org/techniques/T1608/)
- Sub Technique:
  - Name: Upload Malware
- Id: T1608.001
- Reference URL: [[https://attack.mitre.org/techniques/T1608/001/](https://attack.mitre.org/techniques/T1608/001/)](https://attack.mitre.org/techniques/T1608/001/)