﻿---
title: M365 Security Compliance Email Reported by User as Malware or Phish
description: Detects the occurrence of emails reported as Phishing or Malware by Users. Security Awareness training is essential to stay ahead of scammers and threat...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/initial_access_security_compliance_user_reported_phish_malware
products:
  - Elastic Security
---

# M365 Security Compliance Email Reported by User as Malware or Phish
Detects the occurrence of emails reported as Phishing or Malware by Users. Security Awareness training is essential to
stay ahead of scammers and threat actors, as security products can be bypassed, and the user can still receive a
malicious message. Educating users to report suspicious messages can help identify gaps in security controls and prevent
malware infections and Business Email Compromise attacks.
**Rule type**: query
**Rule indices**:
- logs-o365.audit-*
- filebeat-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://support.microsoft.com/en-us/office/use-the-report-message-add-in-b5caa9f1-cdf3-4443-af8c-ff724ea719d2?ui=en-us&rs=en-us&ad=us](https://support.microsoft.com/en-us/office/use-the-report-message-add-in-b5caa9f1-cdf3-4443-af8c-ff724ea719d2?ui=en-us&rs=en-us&ad=us)](https://support.microsoft.com/en-us/office/use-the-report-message-add-in-b5caa9f1-cdf3-4443-af8c-ff724ea719d2?ui=en-us&rs=en-us&ad=us)

**Tags**:
- Domain: Cloud
- Data Source: Microsoft 365
- Tactic: Initial Access
- Resources: Investigation Guide

**Version**: 211
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating M365 Security Compliance Email Reported by User as Malware or Phish

Microsoft 365's email services are integral to business communication, but they can be exploited by adversaries through phishing or malware-laden emails. Attackers may bypass security measures, reaching users who might unwittingly engage with malicious content. The detection rule leverages user reports of suspicious emails, correlating them with security events to identify potential threats, thus enhancing the organization's ability to respond to phishing attempts and malware distribution.

### Possible investigation steps

- Review the details of the alert triggered by the rule "Email reported by user as malware or phish" in the SecurityComplianceCenter to understand the context and specifics of the reported email.
- Examine the event dataset from o365.audit to gather additional information about the email, such as sender, recipient, subject line, and any attachments or links included.
- Correlate the reported email with other security events or alerts to identify any patterns or related incidents that might indicate a broader phishing campaign or malware distribution attempt.
- Check the user's report against known phishing or malware indicators, such as suspicious domains or IP addresses, using threat intelligence sources to assess the credibility of the threat.
- Investigate the user's activity following the receipt of the email to determine if any actions were taken that could have compromised the system, such as clicking on links or downloading attachments.
- Assess the effectiveness of current security controls and awareness training by analyzing how the email bypassed existing defenses and was reported by the user.


### False positive analysis

- User-reported emails from trusted internal senders can trigger false positives. Encourage users to verify the sender's identity before reporting and consider adding these senders to an allowlist if they are consistently flagged.
- Automated system notifications or newsletters may be mistakenly reported as phishing. Educate users on recognizing legitimate automated communications and exclude these sources from triggering alerts.
- Emails containing marketing or promotional content from known vendors might be reported as suspicious. Train users to differentiate between legitimate marketing emails and phishing attempts, and create exceptions for verified vendors.
- Frequent reports of emails from specific domains that are known to be safe can lead to unnecessary alerts. Implement domain-based exceptions for these trusted domains to reduce false positives.
- Encourage users to provide detailed reasons for reporting an email as suspicious, which can help in refining detection rules and reducing false positives over time.


### Response and remediation

- Isolate the affected email account to prevent further interaction with potentially malicious content and to stop any ongoing unauthorized access.
- Quarantine the reported email and any similar emails identified in the system to prevent other users from accessing them.
- Conduct a thorough scan of the affected user's device and network for any signs of malware or unauthorized access, using endpoint detection and response tools.
- Reset the credentials of the affected user account and any other accounts that may have been compromised to prevent further unauthorized access.
- Notify the security team and relevant stakeholders about the incident, providing details of the threat and actions taken, to ensure coordinated response efforts.
- Review and update email filtering and security policies to address any identified gaps that allowed the malicious email to bypass existing controls.
- Monitor for any further suspicious activity related to the incident, using enhanced logging and alerting mechanisms to detect similar threats in the future.


## Setup

The Office 365 Logs Fleet integration, Filebeat module, or similarly structured data is required to be compatible with this rule.

## Rule Query

```kuery
event.dataset:o365.audit and event.provider:SecurityComplianceCenter and event.action:AlertTriggered and rule.name:"Email reported by user as malware or phish"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Initial Access
- Id: TA0001
- Reference URL: [[https://attack.mitre.org/tactics/TA0001/](https://attack.mitre.org/tactics/TA0001/)](https://attack.mitre.org/tactics/TA0001/)
- Technique:
  - Name: Phishing
- Id: T1566
- Reference URL: [[https://attack.mitre.org/techniques/T1566/](https://attack.mitre.org/techniques/T1566/)](https://attack.mitre.org/techniques/T1566/)
- Sub Technique:
  - Name: Spearphishing Attachment
- Id: T1566.001
- Reference URL: [[https://attack.mitre.org/techniques/T1566/001/](https://attack.mitre.org/techniques/T1566/001/)](https://attack.mitre.org/techniques/T1566/001/)
- Sub Technique:
  - Name: Spearphishing Link
- Id: T1566.002
- Reference URL: [[https://attack.mitre.org/techniques/T1566/002/](https://attack.mitre.org/techniques/T1566/002/)](https://attack.mitre.org/techniques/T1566/002/)