﻿---
title: M365 Identity Login from Impossible Travel Location
description: Detects successful Microsoft 365 portal logins from impossible travel locations. Impossible travel locations are defined as two different countries within...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/initial_access_entra_id_portal_login_impossible_travel
products:
  - Elastic Security
---

# M365 Identity Login from Impossible Travel Location
Detects successful Microsoft 365 portal logins from impossible travel locations. Impossible travel locations are defined
as two different countries within a short time frame. This behavior may indicate an adversary attempting to access a
Microsoft 365 account from a compromised account or a malicious actor attempting to access a Microsoft 365 account from
a different location.
**Rule type**: threshold
**Rule indices**:
- logs-o365.audit-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-15m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.huntress.com/blog/time-travelers-busted-how-to-detect-impossible-travel-](https://www.huntress.com/blog/time-travelers-busted-how-to-detect-impossible-travel-)](https://www.huntress.com/blog/time-travelers-busted-how-to-detect-impossible-travel-)

**Tags**:
- Domain: Cloud
- Domain: Identity
- Data Source: Microsoft 365
- Data Source: Microsoft 365 Audit Logs
- Use Case: Threat Detection
- Use Case: Identity and Access Audit
- Tactic: Initial Access
- Resources: Investigation Guide

**Version**: 8
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating M365 Identity Login from Impossible Travel Location

Microsoft 365's cloud-based services enable global access, but this can be exploited by adversaries logging in from disparate locations within short intervals, indicating potential account compromise. The detection rule identifies such anomalies by analyzing login events for rapid geographic shifts, flagging suspicious activity that may suggest unauthorized access attempts.

### Possible investigation steps

- Review the user associated with these sign-ins to determine if the login attempt was legitimate or if further investigation is needed.
- Analyze the geographic locations of the logins to identify any patterns or anomalies that may indicate malicious activity.
- Review the ISP information for the login attempts to identify any unusual or suspicious providers.
- Review the authorization request type to understand the context of the login attempts and whether they align with the user's typical behavior.
- Analyze the client application used for the login attempts to determine if it is consistent with the user's normal usage patterns (Teams, Office, etc.)
- Analyze the user-agent associated with the login attempts to identify any unusual or suspicious patterns. These could also indicate mobile and endpoint logins causing false-positives.


### False positive analysis

- Users traveling or using VPNs may trigger this alert. Verify with the user if they were traveling or using a VPN at the time of the login attempt.
- Mobile access may also result in false positives, as users may log in from various locations while on the go.


### Response and remediation

- Investigate the login attempt further by checking for any additional context or related events that may provide insight into the user's behavior.
- If the login attempt is deemed suspicious, consider implementing additional security measures, such as requiring multi-factor authentication (MFA) for logins from unusual locations.
- Educate users about the risks of accessing corporate resources from unfamiliar locations and the importance of using secure connections (e.g., VPNs) when doing so.
- Monitor for any subsequent login attempts from the same location or IP address to identify potential patterns of malicious activity.
- Consider adding exceptions to this rule for the user or source application ID if the login attempts are determined to be legitimate and not a security concern.


## Rule Query

```kuery
event.dataset:o365.audit and
    event.provider:AzureActiveDirectory and
    event.action:UserLoggedIn and
    event.outcome:success and
    o365.audit.Target.Type:(0 or 10 or 2 or 3 or 5 or 6) and
    o365.audit.UserId:(* and not "Not Available") and
    source.geo.region_iso_code:* and
    not o365.audit.ApplicationId:(
        29d9ed98-a469-4536-ade2-f981bc1d605e or
        38aa3b87-a06d-4817-b275-7a316988d93b or
        a809996b-059e-42e2-9866-db24b99a9782
    ) and not o365.audit.ExtendedProperties.RequestType:(
        "Cmsi:Cmsi" or
        "Consent:Set" or
        "Login:reprocess" or
        "Login:resume" or
        "MessagePrompt:MessagePrompt" or
        "SAS:EndAuth"
    )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Initial Access
- Id: TA0001
- Reference URL: [[https://attack.mitre.org/tactics/TA0001/](https://attack.mitre.org/tactics/TA0001/)](https://attack.mitre.org/tactics/TA0001/)
- Technique:
  - Name: Valid Accounts
- Id: T1078
- Reference URL: [[https://attack.mitre.org/techniques/T1078/](https://attack.mitre.org/techniques/T1078/)](https://attack.mitre.org/techniques/T1078/)
- Sub Technique:
  - Name: Cloud Accounts
- Id: T1078.004
- Reference URL: [[https://attack.mitre.org/techniques/T1078/004/](https://attack.mitre.org/techniques/T1078/004/)](https://attack.mitre.org/techniques/T1078/004/)