﻿---
title: M365 Exchange Mail Flow Transport Rule Modified
description: Identifies when a transport rule has been disabled or deleted in Microsoft 365. Mail flow rules (also known as transport rules) are used to identify and...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/exfiltration_exchange_transport_rule_modification
products:
  - Elastic Security
---

# M365 Exchange Mail Flow Transport Rule Modified
Identifies when a transport rule has been disabled or deleted in Microsoft 365. Mail flow rules (also known as transport
rules) are used to identify and take action on messages that flow through your organization. An adversary or insider
threat may modify a transport rule to exfiltrate data or evade defenses.
**Rule type**: query
**Rule indices**:
- logs-o365.audit-*
- filebeat-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://docs.microsoft.com/en-us/powershell/module/exchange/remove-transportrule?view=exchange-ps](https://docs.microsoft.com/en-us/powershell/module/exchange/remove-transportrule?view=exchange-ps)](https://docs.microsoft.com/en-us/powershell/module/exchange/remove-transportrule?view=exchange-ps)
- [[https://docs.microsoft.com/en-us/powershell/module/exchange/disable-transportrule?view=exchange-ps](https://docs.microsoft.com/en-us/powershell/module/exchange/disable-transportrule?view=exchange-ps)](https://docs.microsoft.com/en-us/powershell/module/exchange/disable-transportrule?view=exchange-ps)
- [[https://docs.microsoft.com/en-us/exchange/security-and-compliance/mail-flow-rules/mail-flow-rules](https://docs.microsoft.com/en-us/exchange/security-and-compliance/mail-flow-rules/mail-flow-rules)](https://docs.microsoft.com/en-us/exchange/security-and-compliance/mail-flow-rules/mail-flow-rules)

**Tags**:
- Domain: Cloud
- Data Source: Microsoft 365
- Use Case: Configuration Audit
- Tactic: Exfiltration
- Resources: Investigation Guide

**Version**: 211
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating M365 Exchange Mail Flow Transport Rule Modified

Microsoft 365 Exchange transport rules manage email flow by setting conditions and actions for messages. Adversaries may exploit these rules to disable or delete them, facilitating data exfiltration or bypassing security measures. The detection rule monitors audit logs for successful execution of commands that alter these rules, signaling potential misuse and enabling timely investigation.

### Possible investigation steps

- Review the audit logs for the specific event.dataset:o365.audit entries with event.provider:Exchange to confirm the occurrence of the "Remove-TransportRule" or "Disable-TransportRule" actions.
- Identify the user account associated with the event by examining the user information in the audit logs to determine if the action was performed by an authorized individual or a potential adversary.
- Check the event.category:web context to understand if the action was performed through a web interface, which might indicate a compromised account or unauthorized access.
- Investigate the event.outcome:success to ensure that the rule modification was indeed successful and not an attempted action.
- Correlate the timing of the rule modification with other security events or alerts to identify any concurrent suspicious activities that might suggest a broader attack or data exfiltration attempt.
- Assess the impact of the rule modification by reviewing the affected transport rules to determine if they were critical for security or compliance, and evaluate the potential risk to the organization.


### False positive analysis

- Routine administrative changes to transport rules by IT staff can trigger alerts. To manage this, maintain a list of authorized personnel and their expected activities, and create exceptions for these users in the monitoring system.
- Scheduled maintenance or updates to transport rules may result in false positives. Document these activities and adjust the monitoring system to temporarily exclude these events during known maintenance windows.
- Automated scripts or third-party tools that manage transport rules might cause alerts. Identify these tools and their typical behavior, then configure the monitoring system to recognize and exclude these benign actions.
- Changes made as part of compliance audits or security assessments can be mistaken for malicious activity. Coordinate with audit teams to log these activities separately and adjust the monitoring system to account for these legitimate changes.


### Response and remediation

- Immediately disable any compromised accounts identified in the audit logs to prevent further unauthorized modifications to transport rules.
- Revert any unauthorized changes to transport rules by restoring them to their previous configurations using backup data or logs.
- Conduct a thorough review of all transport rules to ensure no additional unauthorized modifications have been made, and confirm that all rules align with organizational security policies.
- Implement additional monitoring on the affected accounts and transport rules to detect any further suspicious activities or attempts to modify rules.
- Escalate the incident to the security operations team for a deeper investigation into potential data exfiltration activities and to assess the scope of the breach.
- Coordinate with legal and compliance teams to determine if any regulatory reporting is required due to potential data exfiltration.
- Enhance security measures by enabling multi-factor authentication (MFA) for all administrative accounts and reviewing access permissions to ensure the principle of least privilege is enforced.


## Setup

The Office 365 Logs Fleet integration, Filebeat module, or similarly structured data is required to be compatible with this rule.

## Rule Query

```kuery
event.dataset:o365.audit and event.provider:Exchange and event.category:web and event.action:("Remove-TransportRule" or "Disable-TransportRule") and event.outcome:success
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Exfiltration
- Id: TA0010
- Reference URL: [[https://attack.mitre.org/tactics/TA0010/](https://attack.mitre.org/tactics/TA0010/)](https://attack.mitre.org/tactics/TA0010/)
- Technique:
  - Name: Transfer Data to Cloud Account
- Id: T1537
- Reference URL: [[https://attack.mitre.org/techniques/T1537/](https://attack.mitre.org/techniques/T1537/)](https://attack.mitre.org/techniques/T1537/)