﻿---
title: M365 Teams External Access Enabled
description: Identifies when external access is enabled in Microsoft Teams. External access lets Teams and Skype for Business users communicate with other users that...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/defense_evasion_teams_external_access_enabled
products:
  - Elastic Security
---

# M365 Teams External Access Enabled
Identifies when external access is enabled in Microsoft Teams. External access lets Teams and Skype for Business users
communicate with other users that are outside their organization. An adversary may enable external access or add an
allowed domain to exfiltrate data or maintain persistence in an environment.
**Rule type**: query
**Rule indices**:
- logs-o365.audit-*
- filebeat-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://docs.microsoft.com/en-us/microsoftteams/manage-external-access](https://docs.microsoft.com/en-us/microsoftteams/manage-external-access)](https://docs.microsoft.com/en-us/microsoftteams/manage-external-access)

**Tags**:
- Domain: Cloud
- Data Source: Microsoft 365
- Use Case: Configuration Audit
- Tactic: Defense Evasion
- Resources: Investigation Guide

**Version**: 211
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating M365 Teams External Access Enabled

Microsoft Teams' external access feature allows users to communicate with individuals outside their organization, facilitating collaboration. However, adversaries can exploit this by enabling external access or adding trusted domains to exfiltrate data or maintain persistence. The detection rule monitors audit logs for changes in federation settings, specifically when external access is successfully enabled, indicating potential misuse.

### Possible investigation steps

- Review the audit logs for the specific event.action "Set-CsTenantFederationConfiguration" to identify when and by whom the external access was enabled.
- Examine the o365.audit.Parameters.AllowFederatedUsers field to confirm that it is set to True, indicating that external access was indeed enabled.
- Investigate the user account associated with the event to determine if the action was authorized and if the account has a history of suspicious activity.
- Check the event.provider field to see if the change was made through SkypeForBusiness or MicrosoftTeams, which may provide additional context on the method used.
- Assess the event.outcome field to ensure the action was successful and not a failed attempt, which could indicate a potential security threat.
- Look into any recent changes in the list of allowed domains to identify if any unauthorized or suspicious domains have been added.


### False positive analysis

- Routine administrative changes to federation settings can trigger alerts. Regularly review and document these changes to differentiate between legitimate and suspicious activities.
- Organizations with frequent collaboration with external partners may see increased alerts. Consider creating exceptions for known trusted domains to reduce noise.
- Scheduled updates or policy changes by IT teams might enable external access temporarily. Coordinate with IT to log these activities and exclude them from triggering alerts.
- Automated scripts or tools used for configuration management can inadvertently enable external access. Ensure these tools are properly documented and monitored to prevent false positives.
- Changes made during mergers or acquisitions can appear suspicious. Maintain a record of such events and adjust monitoring rules accordingly to account for expected changes.


### Response and remediation

- Immediately disable external access in Microsoft Teams to prevent further unauthorized communication with external domains.
- Review and remove any unauthorized or suspicious domains added to the allowed list in the Teams federation settings.
- Conduct a thorough audit of recent changes in the Teams configuration to identify any other unauthorized modifications or suspicious activities.
- Reset credentials and enforce multi-factor authentication for accounts involved in the configuration change to prevent further unauthorized access.
- Notify the security team and relevant stakeholders about the incident for awareness and further investigation.
- Escalate the incident to the incident response team if there is evidence of data exfiltration or if the scope of the breach is unclear.
- Implement enhanced monitoring and alerting for changes in Teams federation settings to detect similar threats in the future.


## Setup

The Office 365 Logs Fleet integration, Filebeat module, or similarly structured data is required to be compatible with this rule.

## Rule Query

```kuery
event.dataset:o365.audit and event.provider:(SkypeForBusiness or MicrosoftTeams) and
event.category:web and event.action:"Set-CsTenantFederationConfiguration" and
o365.audit.Parameters.AllowFederatedUsers:True and event.outcome:success
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Impair Defenses
- Id: T1562
- Reference URL: [[https://attack.mitre.org/techniques/T1562/](https://attack.mitre.org/techniques/T1562/)](https://attack.mitre.org/techniques/T1562/)