﻿---
title: M365 Teams Custom Application Interaction Enabled
description: Identifies when custom applications are allowed in Microsoft Teams. If an organization requires applications other than those available in the Teams app...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/defense_evasion_teams_custom_app_interaction_allowed
products:
  - Elastic Security
---

# M365 Teams Custom Application Interaction Enabled
Identifies when custom applications are allowed in Microsoft Teams. If an organization requires applications other than
those available in the Teams app store, custom applications can be developed as packages and uploaded. An adversary may
abuse this behavior to establish persistence in an environment.
**Rule type**: query
**Rule indices**:
- logs-o365.audit-*
- filebeat-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://docs.microsoft.com/en-us/microsoftteams/platform/concepts/deploy-and-publish/apps-upload](https://docs.microsoft.com/en-us/microsoftteams/platform/concepts/deploy-and-publish/apps-upload)](https://docs.microsoft.com/en-us/microsoftteams/platform/concepts/deploy-and-publish/apps-upload)

**Tags**:
- Domain: Cloud
- Data Source: Microsoft 365
- Use Case: Configuration Audit
- Tactic: Defense Evasion
- Resources: Investigation Guide

**Version**: 212
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating M365 Teams Custom Application Interaction Enabled

Microsoft Teams allows organizations to enhance functionality by integrating custom applications, which can be developed and uploaded beyond the standard app store offerings. While beneficial for tailored solutions, this capability can be exploited by adversaries to maintain unauthorized access. The detection rule monitors changes in tenant settings that permit custom app interactions, flagging successful modifications as potential persistence threats.

### Possible investigation steps

- Review the audit logs for the specific event.action: TeamsTenantSettingChanged to identify when the change was made and by whom.
- Verify the identity of the user or account associated with the event to determine if the change was authorized or if the account may have been compromised.
- Check the o365.audit.Name field for "Allow sideloading and interaction of custom apps" to confirm that the alert corresponds to enabling custom app interactions.
- Investigate the o365.audit.NewValue field to ensure it is set to True, indicating that the setting was indeed changed to allow custom apps.
- Assess the event.outcome field to confirm the change was successful and not a failed attempt, which could indicate a different type of issue.
- Examine any recent custom applications uploaded to Microsoft Teams to ensure they are legitimate and not potentially malicious.
- Cross-reference with other security alerts or logs to identify any unusual activity around the time of the setting change that might suggest malicious intent.


### False positive analysis

- Routine administrative changes to Microsoft Teams settings can trigger this rule. If a known and authorized administrator frequently updates tenant settings to allow custom apps, consider creating an exception for their user account to reduce noise.
- Organizations that regularly develop and deploy custom applications for internal use may see frequent alerts. In such cases, establish a process to document and approve these changes, and use this documentation to create exceptions for specific application deployment activities.
- Scheduled updates or maintenance activities that involve enabling custom app interactions might be misidentified as threats. Coordinate with IT teams to schedule these activities and temporarily adjust monitoring rules to prevent false positives during these periods.
- If a third-party service provider is authorized to manage Teams settings, their actions might trigger alerts. Verify their activities and, if consistent and legitimate, add their actions to an exception list to prevent unnecessary alerts.
- Changes made during a known testing or development phase can be mistaken for unauthorized access. Clearly define and communicate these phases to the security team, and consider temporary rule adjustments to accommodate expected changes.


### Response and remediation

- Immediately disable the custom application interaction setting in Microsoft Teams to prevent further unauthorized access or persistence by adversaries.
- Conduct a thorough review of all custom applications currently uploaded to Microsoft Teams to identify any unauthorized or suspicious applications. Remove any that are not recognized or approved by the organization.
- Analyze the audit logs for any recent changes to the Teams settings and identify the user account responsible for enabling custom application interactions. Investigate the account for signs of compromise or misuse.
- Reset the credentials and enforce multi-factor authentication for the account(s) involved in the unauthorized change to prevent further unauthorized access.
- Notify the security team and relevant stakeholders about the incident and the actions taken. Escalate to higher management if the breach is suspected to have wider implications.
- Implement additional monitoring and alerting for changes to Microsoft Teams settings to quickly detect and respond to similar threats in the future.
- Review and update the organization's security policies and procedures regarding the use of custom applications in Microsoft Teams to ensure they align with best practices and mitigate the risk of similar incidents.


## Setup

The Office 365 Logs Fleet integration, Filebeat module, or similarly structured data is required to be compatible with this rule.

## Rule Query

```kuery
event.dataset:o365.audit and event.provider:MicrosoftTeams and
event.category:web and event.action:TeamsTenantSettingChanged and
o365.audit.Name:"Allow sideloading and interaction of custom apps" and
o365.audit.NewValue:True and event.outcome:success
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Impair Defenses
- Id: T1562
- Reference URL: [[https://attack.mitre.org/techniques/T1562/](https://attack.mitre.org/techniques/T1562/)](https://attack.mitre.org/techniques/T1562/)