﻿---
title: M365 Exchange Inbox Phishing Evasion Rule Created
description: Identifies when a user creates a new inbox rule in Microsoft 365 that deletes or moves emails containing suspicious keywords. Adversaries who have compromised...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/defense_evasion_exchange_new_inbox_rule_delete_or_move
products:
  - Elastic Security
---

# M365 Exchange Inbox Phishing Evasion Rule Created
Identifies when a user creates a new inbox rule in Microsoft 365 that deletes or moves emails containing suspicious
keywords. Adversaries who have compromised accounts often create inbox rules to hide alerts, security notifications, or
other sensitive messages by automatically deleting them or moving them to obscure folders. Common destinations include
Deleted Items, Junk Email, RSS Feeds, and RSS Subscriptions. This is a New Terms rule that triggers only when the user
principal name and associated source IP address have not been observed performing this activity in the past 14 days.
**Rule type**: new_terms
**Rule indices**:
- filebeat-*
- logs-o365.audit-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://learn.microsoft.com/en-us/defender-office-365/detect-and-remediate-outlook-rules-forms-attack](https://learn.microsoft.com/en-us/defender-office-365/detect-and-remediate-outlook-rules-forms-attack)](https://learn.microsoft.com/en-us/defender-office-365/detect-and-remediate-outlook-rules-forms-attack)
- [[https://learn.microsoft.com/en-us/defender-xdr/alert-grading-playbook-inbox-manipulation-rules](https://learn.microsoft.com/en-us/defender-xdr/alert-grading-playbook-inbox-manipulation-rules)](https://learn.microsoft.com/en-us/defender-xdr/alert-grading-playbook-inbox-manipulation-rules)
- [[https://blog.barracuda.com/2023/09/20/threat-spotlight-attackers-inbox-rules-evade-detection](https://blog.barracuda.com/2023/09/20/threat-spotlight-attackers-inbox-rules-evade-detection)](https://blog.barracuda.com/2023/09/20/threat-spotlight-attackers-inbox-rules-evade-detection)

**Tags**:
- Domain: Cloud
- Domain: SaaS
- Domain: Email
- Data Source: Microsoft 365
- Data Source: Microsoft 365 Audit Logs
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Resources: Investigation Guide

**Version**: 3
**Rule authors**:
- Elastic
- Jamie Lee
- Marco Pedrinazzi

**Rule license**: Elastic License v2

## Investigation guide


## Triage and Analysis


### Investigating M365 Exchange Inbox Phishing Evasion Rule Created

This detection identifies the creation of potentially malicious inbox rules in Microsoft 365. These rules automatically delete or move emails with specific keywords such as "invoice", "payment", "security", or "phish". Adversaries often use these rules post-compromise to conceal warning emails, alerts from security tools, or responses from help desk teams, thereby evading detection and maintaining access.
This is a new terms rule that alerts only when the combination of `user.id` and `source.ip` has not performed this activity in the last 14 days.

### Possible investigation steps

- Review the `user.id` and `user.email` fields to identify the user account that created the inbox rule.
- Confirm the rule creation action in `event.action` is `New-InboxRule` and that the `event.outcome` is `success`.
- Investigate the `o365.audit.Parameters.SubjectContainsWords` field for sensitive or suspicious keywords such as:
  - `invoice`, `payment`, `reset`, `phish`, `login`, `fraud`, `alert`, etc.
- Check if the rule performs any of the following:
  - `MoveToFolder`: suspicious folders like `RSS Feeds`, `Junk Email`, or `Deleted Items`.
- `DeleteMessage`: if present, suggests the rule is meant to hide communications.
- Review the `source.ip` and `source.geo.*` fields to validate whether the IP address and location match expected user behavior.
- Examine whether the rule was created via a suspicious interface like Exchange Admin or through external automation.
- Check for recent sign-in anomalies, credential changes, or unusual mailbox activity for the user (e.g., email forwarding, MFA prompts).


### False positive analysis

- Some rules may be created by users for legitimate purposes (e.g., moving newsletters).
- Outlook plugins or automated email management tools could create rules that resemble this behavior.
- Newly onboarded employees might configure rules for personal filtering without malicious intent.


### Response and remediation

- If the rule is determined to be malicious:
  - Remove the inbox rule immediately.
- Review the user’s mailbox for signs of data theft or additional manipulation (e.g., auto-forwarding, altered reply-to addresses).
- Investigate surrounding activity such as MFA changes, token refreshes, or admin role assignments.
- Revoke tokens and initiate a password reset for the compromised user.
- If broader compromise is suspected:
  - Review audit logs for other inbox rule creations across the tenant.
- Check whether other users from the same source IP performed similar activity.
- Educate the user on safe email handling and rule creation best practices.
- Strengthen detection:
  - Enable Microsoft Defender for Office 365 Safe Rules.
- Use mailbox auditing and DLP policies to monitor hidden inbox activity.


## Rule Query

```kuery
event.dataset: "o365.audit" and
    event.action: ("New-InboxRule" or "Set-InboxRule") and event.outcome: "success" and
    (
     o365.audit.Parameters.BodyContainsWords: "\u0000" or 
     o365.audit.Parameters.WithinSizeRangeMinimum <= 1023 or 
     o365.audit.Parameters.SubjectContainsWords: (
        *phish* or
        *hack* or
        *alert* or
        *malware* or
        *security* or
        *invoice* or
        *payment* or
        *wire* or
        *transfer* or
        *fraud* or
        *reset* or
        *unusual* or
        *protection* or
        *login* or
        *suspicious*
      )
    ) and (
    o365.audit.Parameters.DeleteMessage: True or
    o365.audit.Parameters.MoveToFolder: (
        *Deleted* or
        *Junk* or
        *RSS* or 
        *Calendar*
    )
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Hide Artifacts
- Id: T1564
- Reference URL: [[https://attack.mitre.org/techniques/T1564/](https://attack.mitre.org/techniques/T1564/)](https://attack.mitre.org/techniques/T1564/)
- Sub Technique:
  - Name: Email Hiding Rules
- Id: T1564.008
- Reference URL: [[https://attack.mitre.org/techniques/T1564/008/](https://attack.mitre.org/techniques/T1564/008/)](https://attack.mitre.org/techniques/T1564/008/)