﻿---
title: M365 Exchange Malware Filter Rule Modified
description: Identifies when a malware filter rule has been deleted or disabled in Microsoft 365. An adversary or insider threat may want to modify a malware filter...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/defense_evasion_exchange_malware_filter_rule_mod
products:
  - Elastic Security
---

# M365 Exchange Malware Filter Rule Modified
Identifies when a malware filter rule has been deleted or disabled in Microsoft 365. An adversary or insider threat may
want to modify a malware filter rule to evade detection.
**Rule type**: query
**Rule indices**:
- logs-o365.audit-*
- filebeat-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://docs.microsoft.com/en-us/powershell/module/exchange/remove-malwarefilterrule?view=exchange-ps](https://docs.microsoft.com/en-us/powershell/module/exchange/remove-malwarefilterrule?view=exchange-ps)](https://docs.microsoft.com/en-us/powershell/module/exchange/remove-malwarefilterrule?view=exchange-ps)
- [[https://docs.microsoft.com/en-us/powershell/module/exchange/disable-malwarefilterrule?view=exchange-ps](https://docs.microsoft.com/en-us/powershell/module/exchange/disable-malwarefilterrule?view=exchange-ps)](https://docs.microsoft.com/en-us/powershell/module/exchange/disable-malwarefilterrule?view=exchange-ps)

**Tags**:
- Domain: Cloud
- Data Source: Microsoft 365
- Use Case: Configuration Audit
- Tactic: Defense Evasion
- Resources: Investigation Guide

**Version**: 211
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating M365 Exchange Malware Filter Rule Modified

Microsoft 365 Exchange uses malware filter rules to protect email systems by identifying and blocking malicious content. Adversaries may attempt to disable or remove these rules to bypass security measures and facilitate attacks. The detection rule monitors audit logs for successful actions that alter these rules, signaling potential defense evasion tactics. This helps security analysts quickly identify and respond to unauthorized modifications.

### Possible investigation steps

- Review the audit logs for the specific event.dataset:o365.audit entries with event.provider:Exchange to confirm the occurrence of the rule modification.
- Identify the user account associated with the event.action:("Remove-MalwareFilterRule" or "Disable-MalwareFilterRule") and verify if the action was authorized or expected.
- Check the event.category:web logs for any related activities around the same timeframe to identify potential patterns or additional suspicious actions.
- Investigate the event.outcome:success to ensure that the modification was indeed successful and assess the impact on the organization's security posture.
- Correlate the identified actions with any recent security incidents or alerts to determine if this modification is part of a larger attack or threat campaign.
- Review the user's recent activity and access logs to identify any other unusual or unauthorized actions that may indicate compromised credentials or insider threat behavior.


### False positive analysis

- Routine administrative changes to malware filter rules by authorized IT personnel can trigger alerts. To manage this, maintain a list of authorized users and their expected activities, and create exceptions for these users in the monitoring system.
- Scheduled maintenance or updates to Microsoft 365 configurations might involve temporary disabling of certain rules. Document these activities and adjust the monitoring system to recognize these as non-threatening.
- Automated scripts or third-party tools used for system management may perform actions that resemble rule modifications. Ensure these tools are properly documented and their actions are whitelisted if verified as safe.
- Changes made during incident response or troubleshooting can appear as rule modifications. Coordinate with the incident response team to log these activities and exclude them from triggering alerts.


### Response and remediation

- Immediately isolate the affected user accounts and systems to prevent further unauthorized modifications to the malware filter rules.
- Re-enable or recreate the disabled or removed malware filter rules to restore the intended security posture of the Microsoft 365 environment.
- Conduct a thorough review of recent email traffic and logs to identify any potential malicious content that may have bypassed the filters during the period of rule modification.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine if additional systems or accounts have been compromised.
- Implement enhanced monitoring and alerting for any future attempts to modify malware filter rules, ensuring rapid detection and response.
- Review and update access controls and permissions for administrative actions within Microsoft 365 to limit the ability to modify security configurations to only essential personnel.
- Document the incident, including actions taken and lessons learned, to improve future response efforts and update incident response plans accordingly.


## Setup

The Office 365 Logs Fleet integration, Filebeat module, or similarly structured data is required to be compatible with this rule.

## Rule Query

```kuery
event.dataset:o365.audit and event.provider:Exchange and event.category:web and event.action:("Remove-MalwareFilterRule" or "Disable-MalwareFilterRule") and event.outcome:success
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Impair Defenses
- Id: T1562
- Reference URL: [[https://attack.mitre.org/techniques/T1562/](https://attack.mitre.org/techniques/T1562/)](https://attack.mitre.org/techniques/T1562/)