﻿---
title: M365 Exchange Malware Filter Policy Deleted
description: Identifies when a malware filter policy has been deleted in Microsoft 365. A malware filter policy is used to alert administrators that an internal user...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/defense_evasion_exchange_malware_filter_policy_deletion
products:
  - Elastic Security
---

# M365 Exchange Malware Filter Policy Deleted
Identifies when a malware filter policy has been deleted in Microsoft 365. A malware filter policy is used to alert
administrators that an internal user sent a message that contained malware. This may indicate an account or machine
compromise that would need to be investigated. Deletion of a malware filter policy may be done to evade detection.
**Rule type**: query
**Rule indices**:
- logs-o365.audit-*
- filebeat-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://docs.microsoft.com/en-us/powershell/module/exchange/remove-malwarefilterpolicy?view=exchange-ps](https://docs.microsoft.com/en-us/powershell/module/exchange/remove-malwarefilterpolicy?view=exchange-ps)](https://docs.microsoft.com/en-us/powershell/module/exchange/remove-malwarefilterpolicy?view=exchange-ps)

**Tags**:
- Domain: Cloud
- Data Source: Microsoft 365
- Use Case: Configuration Audit
- Tactic: Defense Evasion
- Resources: Investigation Guide

**Version**: 211
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating M365 Exchange Malware Filter Policy Deleted

Microsoft 365 Exchange uses malware filter policies to detect and alert administrators about malware in emails, crucial for maintaining security. Adversaries may delete these policies to bypass detection, facilitating undetected malware distribution. The detection rule monitors audit logs for successful deletions of these policies, signaling potential defense evasion attempts.

### Possible investigation steps

- Review the audit logs for the specific event.action "Remove-MalwareFilterPolicy" to identify the user account responsible for the deletion.
- Investigate the event.outcome to confirm the success of the policy deletion and gather additional context from related logs.
- Check the event.provider "Exchange" and event.category "web" to ensure the activity is consistent with expected administrative actions.
- Assess the recent activity of the identified user account for any unusual behavior or signs of compromise, such as unexpected login locations or times.
- Examine other security alerts or incidents involving the same user account or related systems to identify potential patterns or coordinated attacks.
- Verify if there are any recent changes in permissions or roles for the user account that could explain the ability to delete the malware filter policy.
- Coordinate with IT and security teams to determine if the deletion was authorized or if immediate remediation actions are necessary to restore security controls.


### False positive analysis

- Administrative maintenance activities may trigger the rule if administrators are legitimately updating or removing outdated malware filter policies. To manage this, maintain a log of scheduled maintenance activities and cross-reference with alerts to verify legitimacy.
- Automated scripts or third-party tools used for policy management might inadvertently delete policies, leading to false positives. Ensure these tools are configured correctly and consider excluding their actions from the rule if they are verified as non-threatening.
- Changes in organizational policy or security strategy might necessitate the removal of certain malware filter policies. Document these changes and create exceptions in the detection rule for these specific actions to prevent unnecessary alerts.
- User error during policy management could result in accidental deletions. Implement additional verification steps or approval processes for policy deletions to reduce the likelihood of such errors triggering false positives.


### Response and remediation

- Immediately isolate the affected account or system to prevent further unauthorized actions or malware distribution.
- Recreate the deleted malware filter policy to restore the email security posture and prevent further evasion attempts.
- Conduct a thorough review of recent audit logs to identify any other suspicious activities or policy changes that may indicate a broader compromise.
- Reset passwords and enforce multi-factor authentication for the affected account to secure access and prevent further unauthorized actions.
- Notify the security team and relevant stakeholders about the incident for awareness and potential escalation if further investigation reveals a larger threat.
- Implement additional monitoring on the affected account and related systems to detect any further suspicious activities or attempts to bypass security measures.
- Review and update security policies and configurations to ensure they are robust against similar evasion tactics in the future.


## Setup

The Office 365 Logs Fleet integration, Filebeat module, or similarly structured data is required to be compatible with this rule.

## Rule Query

```kuery
event.dataset:o365.audit and event.provider:Exchange and event.category:web and event.action:"Remove-MalwareFilterPolicy" and event.outcome:success
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Impair Defenses
- Id: T1562
- Reference URL: [[https://attack.mitre.org/techniques/T1562/](https://attack.mitre.org/techniques/T1562/)](https://attack.mitre.org/techniques/T1562/)