﻿---
title: M365 Exchange DKIM Signing Configuration Disabled
description: Identifies when a DomainKeys Identified Mail (DKIM) signing configuration is disabled in Microsoft 365. With DKIM in Microsoft 365, messages that are...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/defense_evasion_exchange_dkim_signing_config_disabled
products:
  - Elastic Security
---

# M365 Exchange DKIM Signing Configuration Disabled
Identifies when a DomainKeys Identified Mail (DKIM) signing configuration is disabled in Microsoft 365. With DKIM in
Microsoft 365, messages that are sent from Exchange Online will be cryptographically signed. This will allow the
receiving email system to validate that the messages were generated by a server that the organization authorized and
were not spoofed.
**Rule type**: query
**Rule indices**:
- logs-o365.audit-*
- filebeat-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://docs.microsoft.com/en-us/powershell/module/exchange/set-dkimsigningconfig?view=exchange-ps](https://docs.microsoft.com/en-us/powershell/module/exchange/set-dkimsigningconfig?view=exchange-ps)](https://docs.microsoft.com/en-us/powershell/module/exchange/set-dkimsigningconfig?view=exchange-ps)

**Tags**:
- Domain: Cloud
- Data Source: Microsoft 365
- Tactic: Defense Evasion
- Resources: Investigation Guide

**Version**: 211
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating M365 Exchange DKIM Signing Configuration Disabled

DomainKeys Identified Mail (DKIM) is a security protocol that ensures email authenticity by allowing recipients to verify that messages are sent from authorized servers. Disabling DKIM can expose organizations to email spoofing, where attackers impersonate legitimate domains to conduct phishing attacks. The detection rule identifies when DKIM is disabled in Microsoft 365, signaling potential unauthorized changes that could facilitate persistent threats.

### Possible investigation steps

- Review the audit logs in Microsoft 365 to identify the user or service account associated with the event.action "Set-DkimSigningConfig" where o365.audit.Parameters.Enabled is False. This will help determine who or what initiated the change.
- Check the event.timestamp to establish when the DKIM signing configuration was disabled and correlate this with any other suspicious activities or changes in the environment around the same time.
- Investigate the event.outcome field to confirm that the action was successful and not a failed attempt, which could indicate a misconfiguration or unauthorized access attempt.
- Examine the event.provider and event.category fields to ensure that the event is specifically related to Exchange and web actions, confirming the context of the alert.
- Assess the risk score and severity level to prioritize the investigation and determine if immediate action is required to mitigate potential threats.
- Look into any recent changes in administrative roles or permissions that could have allowed unauthorized users to disable DKIM signing, focusing on persistence tactics as indicated by the MITRE ATT&CK framework reference.


### False positive analysis

- Routine administrative changes: Sometimes, DKIM signing configurations may be disabled temporarily during routine maintenance or updates by authorized IT personnel. To manage this, establish a process to document and approve such changes, and create exceptions in the monitoring system for these documented events.
- Testing and troubleshooting: IT teams may disable DKIM as part of testing or troubleshooting email configurations. Ensure that these activities are logged and approved, and consider setting up alerts that differentiate between test environments and production environments to reduce noise.
- Configuration migrations: During migrations to new email systems or configurations, DKIM may be disabled as part of the transition process. Implement a change management protocol that includes notifying the security team of planned migrations, allowing them to temporarily adjust monitoring rules.
- Third-party integrations: Some third-party email services may require DKIM to be disabled temporarily for integration purposes. Maintain a list of approved third-party services and create exceptions for these specific cases, ensuring that the security team is aware of and has approved the integration.


### Response and remediation

- Immediately re-enable DKIM signing for the affected domain in Microsoft 365 to restore email authenticity and prevent potential spoofing attacks.
- Conduct a review of recent administrative activities in Microsoft 365 to identify any unauthorized changes or suspicious behavior that may have led to the DKIM configuration being disabled.
- Notify the security team and relevant stakeholders about the incident, providing details of the unauthorized change and potential risks associated with it.
- Implement additional monitoring on the affected domain and related accounts to detect any further unauthorized changes or suspicious activities.
- Review and update access controls and permissions for administrative accounts in Microsoft 365 to ensure that only authorized personnel can modify DKIM settings.
- Escalate the incident to the organization's incident response team for further investigation and to determine if any additional security measures are necessary.
- Consider implementing additional email security measures, such as SPF and DMARC, to complement DKIM and enhance overall email security posture.


## Setup

The Office 365 Logs Fleet integration, Filebeat module, or similarly structured data is required to be compatible with this rule.

## Rule Query

```kuery
event.dataset:o365.audit and event.provider:Exchange and event.category:web and event.action:"Set-DkimSigningConfig" and o365.audit.Parameters.Enabled:False and event.outcome:success
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Impair Defenses
- Id: T1562
- Reference URL: [[https://attack.mitre.org/techniques/T1562/](https://attack.mitre.org/techniques/T1562/)](https://attack.mitre.org/techniques/T1562/)
- Sub Technique:
  - Name: Disable or Modify Tools
- Id: T1562.001
- Reference URL: [[https://attack.mitre.org/techniques/T1562/001/](https://attack.mitre.org/techniques/T1562/001/)](https://attack.mitre.org/techniques/T1562/001/)