﻿---
title: M365 Exchange Anti-Phish Rule Modification
description: Identifies the modification of an anti-phishing rule in Microsoft 365. By default, Microsoft 365 includes built-in features that help protect users from...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/defense_evasion_exchange_anti_phish_rule_modification
products:
  - Elastic Security
---

# M365 Exchange Anti-Phish Rule Modification
Identifies the modification of an anti-phishing rule in Microsoft 365. By default, Microsoft 365 includes built-in
features that help protect users from phishing attacks. Anti-phishing rules increase this protection by refining
settings to better detect and prevent attacks.
**Rule type**: query
**Rule indices**:
- logs-o365.audit-*
- filebeat-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://docs.microsoft.com/en-us/powershell/module/exchange/remove-antiphishrule?view=exchange-ps](https://docs.microsoft.com/en-us/powershell/module/exchange/remove-antiphishrule?view=exchange-ps)](https://docs.microsoft.com/en-us/powershell/module/exchange/remove-antiphishrule?view=exchange-ps)
- [[https://docs.microsoft.com/en-us/powershell/module/exchange/disable-antiphishrule?view=exchange-ps](https://docs.microsoft.com/en-us/powershell/module/exchange/disable-antiphishrule?view=exchange-ps)](https://docs.microsoft.com/en-us/powershell/module/exchange/disable-antiphishrule?view=exchange-ps)

**Tags**:
- Domain: Cloud
- Data Source: Microsoft 365
- Use Case: Configuration Audit
- Tactic: Defense Evasion
- Resources: Investigation Guide

**Version**: 211
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating M365 Exchange Anti-Phish Rule Modification

Microsoft 365's anti-phishing rules are crucial for safeguarding users against phishing attacks by enhancing detection and prevention settings. Adversaries may attempt to modify or disable these rules to facilitate phishing campaigns, gaining unauthorized access. The detection rule monitors for successful modifications or disabling of anti-phishing rules, signaling potential malicious activity by tracking specific actions within the Exchange environment.

### Possible investigation steps

- Review the event logs for entries with event.dataset set to o365.audit and event.provider set to Exchange to confirm the context of the alert.
- Check the event.action field for "Remove-AntiPhishRule" or "Disable-AntiPhishRule" to identify the specific action taken on the anti-phishing rule.
- Verify the event.outcome field to ensure the action was successful, indicating a potential security concern.
- Identify the user or account associated with the modification by examining the relevant user fields in the event log.
- Investigate the user's recent activity and access patterns to determine if there are any other suspicious actions or anomalies.
- Assess the impact of the rule modification by reviewing any subsequent phishing attempts or security incidents that may have occurred.
- Consider reverting the changes to the anti-phishing rule and implementing additional security measures if unauthorized access is confirmed.


### False positive analysis

- Administrative changes: Legitimate administrative tasks may involve modifying or disabling anti-phishing rules for testing or configuration purposes. To manage this, create exceptions for known administrative accounts or scheduled maintenance windows.
- Security audits: Regular security audits might require temporary adjustments to anti-phishing rules. Document these activities and exclude them from alerts by correlating with audit logs.
- Third-party integrations: Some third-party security tools may interact with Microsoft 365 settings, triggering rule modifications. Identify these tools and exclude their actions from triggering alerts by using their specific identifiers.
- Policy updates: Organizational policy changes might necessitate updates to anti-phishing rules. Ensure these changes are documented and exclude them from alerts by associating them with approved change management processes.


### Response and remediation

- Immediately isolate the affected user accounts to prevent further unauthorized access and potential spread of phishing attacks.
- Revert any unauthorized changes to the anti-phishing rules by restoring them to their previous configurations using backup or documented settings.
- Conduct a thorough review of recent email logs and user activity to identify any potential phishing emails that may have bypassed the modified rules and take steps to quarantine or delete them.
- Notify the security team and relevant stakeholders about the incident, providing details of the rule modification and any identified phishing attempts.
- Escalate the incident to the incident response team for further investigation and to determine if additional systems or data have been compromised.
- Implement enhanced monitoring and alerting for any further attempts to modify anti-phishing rules, ensuring that similar activities are detected promptly.
- Review and update access controls and permissions for administrative actions within Microsoft 365 to ensure that only authorized personnel can modify security settings.


## Setup

The Office 365 Logs Fleet integration, Filebeat module, or similarly structured data is required to be compatible with this rule.

## Rule Query

```kuery
event.dataset:o365.audit and event.provider:Exchange and event.category:web and event.action:("Remove-AntiPhishRule" or "Disable-AntiPhishRule") and event.outcome:success
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Impair Defenses
- Id: T1562
- Reference URL: [[https://attack.mitre.org/techniques/T1562/](https://attack.mitre.org/techniques/T1562/)](https://attack.mitre.org/techniques/T1562/)
- Sub Technique:
  - Name: Disable or Modify Tools
- Id: T1562.001
- Reference URL: [[https://attack.mitre.org/techniques/T1562/001/](https://attack.mitre.org/techniques/T1562/001/)](https://attack.mitre.org/techniques/T1562/001/)