﻿---
title: Kubernetes Service Account Modified RBAC Objects
description: Detects write operations performed by Kubernetes service accounts against RBAC resources (Roles, ClusterRoles, RoleBindings, ClusterRoleBindings). Service...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/kubernetes/privilege_escalation_service_account_rbac_write_operation
products:
  - Elastic Security
---

# Kubernetes Service Account Modified RBAC Objects
Detects write operations performed by Kubernetes service accounts against RBAC resources (Roles,
ClusterRoles, RoleBindings, ClusterRoleBindings). Service accounts typically do not manage RBAC
directly; this activity may indicate token abuse, misconfigured permissions, or unauthorized
privilege escalation.
**Rule type**: query
**Rule indices**:
- logs-kubernetes.audit_logs-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: ``
**Maximum alerts per execution**: 100
**References**:
- [[https://heilancoos.github.io/research/2025/12/16/kubernetes.html#overly-permissive-role-based-access-control](https://heilancoos.github.io/research/2025/12/16/kubernetes.html#overly-permissive-role-based-access-control)](https://heilancoos.github.io/research/2025/12/16/kubernetes.html#overly-permissive-role-based-access-control)

**Tags**:
- Data Source: Kubernetes
- Domain: Kubernetes
- Use Case: Threat Detection
- Tactic: Privilege Escalation
- Tactic: Persistence
- Resources: Investigation Guide

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Kubernetes Service Account Modified RBAC Objects

This rule detects Kubernetes service accounts performing allowed write actions on RBAC resources such as Roles and RoleBindings, which is atypical because service accounts rarely administer permissions. It matters because stolen or over-privileged service account tokens can silently alter authorization to gain or retain elevated access across the cluster. An attacker commonly uses a compromised workload’s token to create or patch a binding that grants cluster-admin privileges to their service account for persistent control.

### Possible investigation steps

- Retrieve the full audit event and diff the before/after RBAC object to identify newly granted subjects, verbs, resources, and cluster-admin or wildcard permissions.
- Trace the acting service account to its owning workload (Deployment/Pod) and node, then review recent image changes, restarts, exec sessions, and container logs around the event time for compromise indicators.
- Determine whether the change is attributable to an expected controller or GitOps/CI automation by correlating with change tickets, pipeline runs, and repository commits for RBAC manifests.
- Validate whether the service account token may be abused by checking for unusual API access patterns, source IPs/user agents, and cross-namespace activity compared to its baseline behavior.
- Contain if suspicious by reverting the RBAC change, rotating the service account token (and any mounted secrets), and tightening the service account’s Role/ClusterRole to least privilege.


### False positive analysis

- A platform automation running in-cluster (e.g., a controller or CI job using a service account) legitimately applies RBAC manifests during routine deployment, upgrades, or namespace onboarding, resulting in create/patch/update of Roles or RoleBindings.
- A Kubernetes operator or housekeeping workflow running under a service account intentionally adjusts RBAC as part of maintenance (e.g., rotating access, reconciling drift, or cleaning up obsolete bindings) and triggers allowed delete or update actions on RBAC resources.


### Response and remediation

- Immediately remove or quarantine the offending service account by deleting its RoleBindings/ClusterRoleBindings and restarting or scaling down the owning workload to stop further RBAC writes.
- Revert the unauthorized RBAC object changes by restoring the last known-good Roles/Bindings from GitOps/manifests (or `kubectl rollout undo` where applicable) and verify no new subjects gained wildcard or cluster-admin-equivalent access.
- Rotate credentials by recreating the service account or triggering token re-issuance, deleting any mounted legacy token secrets, and redeploying workloads to ensure old tokens cannot be reused.
- Hunt and eradicate persistence by searching for additional recently modified RBAC objects and newly created service accounts in the same namespaces, then remove unauthorized accounts/bindings and scan the implicated container images for backdoors.
- Escalate to incident response and cluster administrators immediately if any change grants `cluster-admin`, introduces `*` verbs/resources, or binds a service account to privileged ClusterRoles across namespaces.
- Harden going forward by enforcing least-privilege RBAC, enabling admission controls to restrict RBAC modifications to approved identities/namespaces, and using short-lived projected service account tokens with workload identity constraints.


## Rule Query

```kuery
event.dataset:"kubernetes.audit_logs" and kubernetes.audit.annotations.authorization_k8s_io/decision:"allow" and
kubernetes.audit.user.username:(
  system\:serviceaccount\:* and not (
    "system:serviceaccount:kube-system:clusterrole-aggregation-controller" or
    "system:serviceaccount:kube-system:generic-garbage-collector"
  )
) and
kubernetes.audit.objectRef.resource:("clusterrolebindings" or "clusterroles" or "rolebindings" or "roles") and
kubernetes.audit.verb:("create" or "delete" or "patch" or "update")
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Account Manipulation
- Id: T1098
- Reference URL: [[https://attack.mitre.org/techniques/T1098/](https://attack.mitre.org/techniques/T1098/)](https://attack.mitre.org/techniques/T1098/)
- Sub Technique:
  - Name: Additional Container Cluster Roles
- Id: T1098.006
- Reference URL: [[https://attack.mitre.org/techniques/T1098/006/](https://attack.mitre.org/techniques/T1098/006/)](https://attack.mitre.org/techniques/T1098/006/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Account Manipulation
- Id: T1098
- Reference URL: [[https://attack.mitre.org/techniques/T1098/](https://attack.mitre.org/techniques/T1098/)](https://attack.mitre.org/techniques/T1098/)
- Sub Technique:
  - Name: Additional Container Cluster Roles
- Id: T1098.006
- Reference URL: [[https://attack.mitre.org/techniques/T1098/006/](https://attack.mitre.org/techniques/T1098/006/)](https://attack.mitre.org/techniques/T1098/006/)