﻿---
title: Kubernetes Privileged Pod Created
description: This rule detects when a user creates a pod/container running in privileged mode. A highly privileged container has access to the node's resources and...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/kubernetes/privilege_escalation_privileged_pod_created
products:
  - Elastic Security
---

# Kubernetes Privileged Pod Created
This rule detects when a user creates a pod/container running in privileged mode. A highly privileged container has
access to the node's resources and breaks the isolation between containers. If compromised, an attacker can use the
privileged container to gain access to the underlying host. Gaining access to the host may provide the adversary with
the opportunity to achieve follow-on objectives, such as establishing persistence, moving laterally within the
environment, or setting up a command and control channel on the host.
**Rule type**: query
**Rule indices**:
- logs-kubernetes.audit_logs-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: ``
**Maximum alerts per execution**: 100
**References**:
- [[https://media.defense.gov/2021/Aug/03/2002820425/-1/-1/1/CTR_KUBERNETES%20HARDENING%20GUIDANCE.PDF](https://media.defense.gov/2021/Aug/03/2002820425/-1/-1/1/CTR_KUBERNETES%20HARDENING%20GUIDANCE.PDF)](https://media.defense.gov/2021/Aug/03/2002820425/-1/-1/1/CTR_KUBERNETES%20HARDENING%20GUIDANCE.PDF)
- [[https://kubernetes.io/docs/tasks/configure-pod-container/security-context/](https://kubernetes.io/docs/tasks/configure-pod-container/security-context/)](https://kubernetes.io/docs/tasks/configure-pod-container/security-context/)

**Tags**:
- Data Source: Kubernetes
- Domain: Kubernetes
- Use Case: Threat Detection
- Tactic: Execution
- Tactic: Privilege Escalation
- Resources: Investigation Guide

**Version**: 209
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Kubernetes Privileged Pod Created

Kubernetes allows for the creation of privileged pods, which can access the host's resources, breaking container isolation. Adversaries may exploit this to escalate privileges, access sensitive data, or establish persistence. The detection rule identifies such events by monitoring audit logs for pod creation with privileged settings, excluding known safe images, to flag potential security threats.

### Possible investigation steps

- Review the Kubernetes audit logs to identify the user or service account responsible for creating the privileged pod by examining the `kubernetes.audit.annotations.authorization_k8s_io/decision` and `kubernetes.audit.verb:create` fields.
- Investigate the context of the privileged pod creation by checking the `kubernetes.audit.requestObject.spec.containers.image` field to determine if the image used is known or potentially malicious.
- Assess the necessity and legitimacy of the privileged pod by consulting with the relevant development or operations teams to understand if there was a valid reason for its creation.
- Examine the `kubernetes.audit.objectRef.resource:pods` field to identify the specific pod and its associated namespace, and verify if it aligns with expected deployment patterns or environments.
- Check for any subsequent suspicious activities or anomalies in the Kubernetes environment that may indicate further exploitation attempts, such as lateral movement or data exfiltration, following the creation of the privileged pod.


### False positive analysis

- Known safe images like "docker.elastic.co/beats/elastic-agent:8.4.0" are already excluded from triggering alerts. Ensure that any additional internal or third-party images that are verified as safe are added to the exclusion list to prevent unnecessary alerts.
- Development and testing environments often use privileged pods for legitimate purposes. Consider creating separate rules or exceptions for these environments to avoid false positives while maintaining security in production.
- Automated deployment tools or scripts might create privileged pods as part of their normal operation. Review these tools and, if they are deemed safe, add their specific actions or images to the exclusion list.
- Regularly review and update the exclusion list to reflect changes in your environment, such as new safe images or changes in deployment practices, to maintain an accurate detection rule.


### Response and remediation

- Immediately isolate the affected node to prevent further exploitation and lateral movement within the cluster. This can be done by cordoning and draining the node to stop new pods from being scheduled and to safely evict existing pods.
- Terminate the privileged pod to stop any ongoing malicious activity. Ensure that the termination is logged for further analysis.
- Conduct a thorough review of the audit logs to identify any unauthorized access or actions taken by the privileged pod. Focus on any attempts to access sensitive data or escalate privileges.
- Reset credentials and access tokens that may have been exposed or compromised due to the privileged pod's access to the host's resources.
- Patch and update the Kubernetes environment and any affected nodes to address vulnerabilities that may have been exploited to create the privileged pod.
- Implement network segmentation and firewall rules to limit the communication capabilities of pods, especially those with elevated privileges, to reduce the risk of lateral movement.
- Escalate the incident to the security operations team for a comprehensive investigation and to assess the need for further security measures or incident response actions.


## Setup

The Kubernetes Fleet integration with Audit Logs enabled or similarly structured data is required to be compatible with this rule.

## Rule Query

```kuery
event.dataset : "kubernetes.audit_logs" and kubernetes.audit.annotations.authorization_k8s_io/decision:"allow" and
kubernetes.audit.objectRef.resource:pods and kubernetes.audit.verb:create and kubernetes.audit.requestObject.spec.containers.securityContext.privileged:true and
not kubernetes.audit.requestObject.spec.containers.image: (
  *amazonaws.com/betsie/pipeline/pipeline-core* or mirror.gcr.io/aquasec/trivy* or rancher/mirrored-longhornio-longhorn-instance-manager* or quay.io/calico* or
  rancher/system-agent* or openebs/m-exporter* or openebs/cstor-istgt* or ghcr.io/kubereboot/kured* or registry.k8s.io/sig-storage/csi-node-driver-registrar* or
  registry.k8s.io/csi-secrets-store* or registry.gitlab.com/gitlab-org/gitlab-runner/gitlab-runner-helper* or sonarsource/sonar-scanner-cli* or
  rancher/mirrored-longhornio-longhorn-engine* or jenkins/inbound-agent* or mcr.microsoft.com/oss/v2/kubernetes-csi* or registry.k8s.io/dns/k8s-dns-node-cache* or
  *amazonaws.com/eks/kube-proxy* or *amazonaws.com/eks/aws-efs-csi-driver* or *amazonaws.com/eks/livenessprobe* or *amazonaws.com/amazon-k8s-cni* or
  *amazonaws.com/amazon/aws-network-policy-agent* or mcr.microsoft.com/oss/kubernetes-csi* or openebs/node-disk-manager* or openebs/node-disk-exporter* or
  mcr.microsoft.com/oss/kubernetes/kube-proxy* or public.ecr.aws/eks-distro/kubernetes-csi/livenessprobe* or public.ecr.aws/eks-distro/kubernetes-csi/external-provisioner* or
  amazon/aws-efs-csi-driver* or registry.k8s.io/kube-proxy* or registry.crowdstrike.com/falcon-sensor* or *octopus-deploy/tentacle* or */sysdig/*
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Escape to Host
- Id: T1611
- Reference URL: [[https://attack.mitre.org/techniques/T1611/](https://attack.mitre.org/techniques/T1611/)](https://attack.mitre.org/techniques/T1611/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Deploy Container
- Id: T1610
- Reference URL: [[https://attack.mitre.org/techniques/T1610/](https://attack.mitre.org/techniques/T1610/)](https://attack.mitre.org/techniques/T1610/)