﻿---
title: Kubernetes Pod Created With HostPID
description: This rule detects an attempt to create or modify a pod attached to the host PID namespace. HostPID allows a pod to access all the processes running on...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/kubernetes/privilege_escalation_pod_created_with_hostpid
products:
  - Elastic Security
---

# Kubernetes Pod Created With HostPID
This rule detects an attempt to create or modify a pod attached to the host PID namespace. HostPID allows a pod to
access all the processes running on the host and could allow an attacker to take malicious action. When paired with
ptrace this can be used to escalate privileges outside of the container. When paired with a privileged container, the
pod can see all of the processes on the host. An attacker can enter the init system (PID 1) on the host. From there,
they could execute a shell and continue to escalate privileges to root.
**Rule type**: query
**Rule indices**:
- logs-kubernetes.audit_logs-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: ``
**Maximum alerts per execution**: 100
**References**:
- [[https://research.nccgroup.com/2021/11/10/detection-engineering-for-kubernetes-clusters/#part3-kubernetes-detections](https://research.nccgroup.com/2021/11/10/detection-engineering-for-kubernetes-clusters/#part3-kubernetes-detections)](https://research.nccgroup.com/2021/11/10/detection-engineering-for-kubernetes-clusters/#part3-kubernetes-detections)
- [[https://kubernetes.io/docs/concepts/security/pod-security-policy/#host-namespaces](https://kubernetes.io/docs/concepts/security/pod-security-policy/#host-namespaces)](https://kubernetes.io/docs/concepts/security/pod-security-policy/#host-namespaces)
- [[https://bishopfox.com/blog/kubernetes-pod-privilege-escalation](https://bishopfox.com/blog/kubernetes-pod-privilege-escalation)](https://bishopfox.com/blog/kubernetes-pod-privilege-escalation)

**Tags**:
- Data Source: Kubernetes
- Domain: Kubernetes
- Use Case: Threat Detection
- Tactic: Execution
- Tactic: Privilege Escalation
- Resources: Investigation Guide

**Version**: 209
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Kubernetes Pod Created With HostPID

Kubernetes allows pods to share the host's process ID (PID) namespace, enabling visibility into host processes. While useful for debugging, this can be exploited by attackers to escalate privileges, especially when combined with privileged containers. The detection rule identifies attempts to create or modify pods with HostPID enabled, excluding known safe images, to flag potential privilege escalation activities.

### Possible investigation steps

- Review the Kubernetes audit logs to identify the user or service account responsible for the pod creation or modification attempt. Look for the `kubernetes.audit.user.username` field to determine who initiated the action.
- Examine the `kubernetes.audit.requestObject.spec.containers.image` field to identify the container images used in the pod. Verify if any unknown or suspicious images are being deployed.
- Check the `kubernetes.audit.annotations.authorization_k8s_io/decision` field to confirm that the action was allowed and investigate the context or reason for this decision.
- Investigate the `kubernetes.audit.objectRef.resource` and `kubernetes.audit.verb` fields to understand the specific action taken (create, update, or patch) and the resource involved.
- Assess the necessity and legitimacy of using HostPID in the pod's configuration by consulting with the relevant development or operations teams. Determine if there is a valid use case or if it was potentially misconfigured or maliciously set.
- Review any recent changes in the Kubernetes environment or related configurations that might have led to this alert, focusing on changes around the time the alert was triggered.


### False positive analysis

- Known safe images like "docker.elastic.co/beats/elastic-agent:8.4.0" are already excluded, but other internal tools or monitoring agents that require HostPID for legitimate reasons might trigger false positives. Review and identify such images and add them to the exclusion list.
- Development or testing environments often use HostPID for debugging purposes. Consider creating a separate rule or exception for these environments to prevent unnecessary alerts.
- Some system maintenance tasks might require temporary use of HostPID. Document these tasks and schedule them during known maintenance windows, then adjust the rule to exclude these specific time frames.
- Regularly review audit logs to identify patterns of benign HostPID usage. Use this information to refine the rule and reduce false positives by updating the exclusion criteria.
- Collaborate with development and operations teams to understand legitimate use cases for HostPID in your environment, and adjust the rule to accommodate these scenarios without compromising security.


### Response and remediation

- Immediately isolate the affected pod to prevent further interaction with the host processes. This can be done by cordoning the node or deleting the pod if necessary.
- Review and revoke any unnecessary permissions or roles that may have allowed the creation of pods with HostPID enabled. Ensure that only trusted users and service accounts have the ability to create such pods.
- Conduct a thorough investigation of the container images used in the pod to ensure they are from trusted sources and have not been tampered with. Remove any untrusted or suspicious images from the registry.
- Check for any unauthorized access or changes to the host system's processes and files. If any malicious activity is detected, take steps to restore affected systems from backups and patch any vulnerabilities.
- Implement network segmentation to limit the communication between pods and the host system, reducing the risk of lateral movement by an attacker.
- Enhance monitoring and logging to capture detailed audit logs of Kubernetes API activities, focusing on changes to pod specifications and the use of HostPID. This will aid in detecting similar threats in the future.
- Escalate the incident to the security operations team for further analysis and to determine if additional security measures or incident response actions are required.


## Setup

The Kubernetes Fleet integration with Audit Logs enabled or similarly structured data is required to be compatible with this rule.

## Rule Query

```kuery
event.dataset : "kubernetes.audit_logs" and kubernetes.audit.annotations.authorization_k8s_io/decision:"allow" and
kubernetes.audit.objectRef.resource:"pods" and kubernetes.audit.verb:("create" or "update" or "patch") and
kubernetes.audit.requestObject.spec.hostPID:true and
not kubernetes.audit.requestObject.spec.containers.image: (
  ghcr.io/aquasecurity/node-collector* or rancher/system-agent* or ghcr.io/kubereboot/kured* or 
  *elastic/elastic-agent* or registry.k8s.io/sig-storage/csi-node-driver-registrar* or quay.io/prometheus/node-exporter* or
  docker.elastic.co/beats/elastic-agent* or quay.io/cephcsi/cephcsi* or registry.crowdstrike.com/falcon-sensor* or */sysdig/* or
  rancher/mirrored-longhornio-longhorn-manager* or gcr.io/datadoghq/agent* or mcr.microsoft.com/oss/*/kubernetes-csi*
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Escape to Host
- Id: T1611
- Reference URL: [[https://attack.mitre.org/techniques/T1611/](https://attack.mitre.org/techniques/T1611/)](https://attack.mitre.org/techniques/T1611/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Deploy Container
- Id: T1610
- Reference URL: [[https://attack.mitre.org/techniques/T1610/](https://attack.mitre.org/techniques/T1610/)](https://attack.mitre.org/techniques/T1610/)