﻿---
title: Kubernetes Container Created with Excessive Linux Capabilities
description: This rule detects a container deployed with one or more dangerously permissive Linux capabilities. An attacker with the ability to deploy a container...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/kubernetes/privilege_escalation_container_created_with_excessive_linux_capabilities
products:
  - Elastic Security
---

# Kubernetes Container Created with Excessive Linux Capabilities
This rule detects a container deployed with one or more dangerously permissive Linux capabilities. An attacker with the
ability to deploy a container with added capabilities could use this for further execution, lateral movement, or
privilege escalation within a cluster. The capabilities detected in this rule have been used in container escapes to the
host machine.
**Rule type**: query
**Rule indices**:
- logs-kubernetes.audit_logs-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: ``
**Maximum alerts per execution**: 100
**References**:
- [[https://kubernetes.io/docs/tasks/configure-pod-container/security-context/#set-capabilities-for-a-container](https://kubernetes.io/docs/tasks/configure-pod-container/security-context/#set-capabilities-for-a-container)](https://kubernetes.io/docs/tasks/configure-pod-container/security-context/#set-capabilities-for-a-container)
- [[https://0xn3va.gitbook.io/cheat-sheets/container/escaping/excessive-capabilities](https://0xn3va.gitbook.io/cheat-sheets/container/escaping/excessive-capabilities)](https://0xn3va.gitbook.io/cheat-sheets/container/escaping/excessive-capabilities)
- [[https://man7.org/linux/man-pages/man7/capabilities.7.html](https://man7.org/linux/man-pages/man7/capabilities.7.html)](https://man7.org/linux/man-pages/man7/capabilities.7.html)
- [[https://docs.docker.com/engine/reference/run/#runtime-privilege-and-linux-capabilities](https://docs.docker.com/engine/reference/run/#runtime-privilege-and-linux-capabilities)](https://docs.docker.com/engine/reference/run/#runtime-privilege-and-linux-capabilities)

**Tags**:
- Data Source: Kubernetes
- Domain: Kubernetes
- Use Case: Threat Detection
- Tactic: Execution
- Tactic: Privilege Escalation
- Resources: Investigation Guide

**Version**: 10
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating Kubernetes Container Created with Excessive Linux Capabilities

Linux capabilities were designed to divide root privileges into smaller units. Each capability grants a thread just enough power to perform specific privileged tasks. In Kubernetes, containers are given a set of default capabilities that can be dropped or added to at the time of creation. Added capabilities entitle containers in a pod with additional privileges that can be used to change
core processes, change network settings of a cluster, or directly access the underlying host. The following have been used in container escape techniques:
BPF - Allow creating BPF maps, loading BPF Type Format (BTF) data, retrieve JITed code of BPF programs, and more.
DAC_READ_SEARCH - Bypass file read permission checks and directory read and execute permission checks.
NET_ADMIN - Perform various network-related operations.
SYS_ADMIN - Perform a range of system administration operations.
SYS_BOOT - Use reboot(2) and kexec_load(2), reboot and load a new kernel for later execution.
SYS_MODULE - Load and unload kernel modules.
SYS_PTRACE - Trace arbitrary processes using ptrace(2).
SYS_RAWIO - Perform I/O port operations (iopl(2) and ioperm(2)).
SYSLOG - Perform privileged syslog(2) operations.

### False positive analysis

- While these capabilities are not included by default in containers, some legitimate images may need to add them. This rule leaves space for the exception of trusted container images. To add an exception, add the trusted container image name to the query field, kubernetes.audit.requestObject.spec.containers.image.


## Setup

The Kubernetes Fleet integration with Audit Logs enabled or similarly structured data is required to be compatible with this rule.

## Rule Query

```kuery
event.dataset: kubernetes.audit_logs and kubernetes.audit.annotations.authorization_k8s_io/decision:"allow" and
kubernetes.audit.verb: create and kubernetes.audit.objectRef.resource: pods and
kubernetes.audit.requestObject.spec.containers.securityContext.capabilities.add: ("BPF" or "DAC_READ_SEARCH"  or "NET_ADMIN" or "SYS_ADMIN" or "SYS_BOOT" or "SYS_MODULE" or "SYS_PTRACE" or "SYS_RAWIO"  or "SYSLOG") and
not (
  kubernetes.audit.requestObject.spec.containers.image : (docker.elastic.co/beats/elastic-agent* or rancher/klipper-lb* or "") or
  kubernetes.audit.objectRef.namespace:"kube-system" or
  (kubernetes.audit.objectRef.namespace:datadog and kubernetes.audit.requestObject.spec.containers.image:*datadog-agent*) or
  (kubernetes.audit.objectRef.namespace:kubearmor and kubernetes.audit.requestObject.spec.containers.image:(*kubearmor\:kubearmor* or kubearmor/kubearmor-snitch*)) or
  (kubernetes.audit.objectRef.namespace:defender and kubernetes.audit.requestObject.spec.containers.image:*fp-prisma\:defender-defender*) or
  (kubernetes.audit.objectRef.namespace:metallb-system and kubernetes.audit.requestObject.spec.containers.image:(quay.io/frrouting* or quay.io/metallb/speaker*)) or
  (kubernetes.audit.objectRef.namespace:longhorn-system and kubernetes.audit.requestObject.spec.containers.image:rancher/mirrored-longhornio*)
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Escape to Host
- Id: T1611
- Reference URL: [[https://attack.mitre.org/techniques/T1611/](https://attack.mitre.org/techniques/T1611/)](https://attack.mitre.org/techniques/T1611/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Deploy Container
- Id: T1610
- Reference URL: [[https://attack.mitre.org/techniques/T1610/](https://attack.mitre.org/techniques/T1610/)](https://attack.mitre.org/techniques/T1610/)