﻿---
title: Kubernetes Creation of a RoleBinding Referencing a ServiceAccount
description: This rule detects the creation of RoleBindings or ClusterRoleBindings that reference a ServiceAccount, which may indicate privilege delegation or potential...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/kubernetes/persistence_service_account_bound_to_clusterrole
products:
  - Elastic Security
---

# Kubernetes Creation of a RoleBinding Referencing a ServiceAccount
This rule detects the creation of RoleBindings or ClusterRoleBindings that reference a ServiceAccount,
which may indicate privilege delegation or potential RBAC misconfiguration leading to elevated access.
**Rule type**: query
**Rule indices**:
- logs-kubernetes.audit_logs-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: ``
**Maximum alerts per execution**: 100
**References**:
- [[https://heilancoos.github.io/research/2025/12/16/kubernetes.html#overly-permissive-role-based-access-control](https://heilancoos.github.io/research/2025/12/16/kubernetes.html#overly-permissive-role-based-access-control)](https://heilancoos.github.io/research/2025/12/16/kubernetes.html#overly-permissive-role-based-access-control)

**Tags**:
- Data Source: Kubernetes
- Domain: Kubernetes
- Use Case: Threat Detection
- Tactic: Persistence
- Tactic: Privilege Escalation
- Resources: Investigation Guide

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Kubernetes Creation of a RoleBinding Referencing a ServiceAccount

This rule detects creation of a RoleBinding or ClusterRoleBinding that grants permissions to a ServiceAccount, a common way to delegate access inside the cluster and a frequent precursor to stealthy privilege escalation or persistence. Attackers who gain the ability to create bindings often attach an over-privileged role (or cluster-wide role) to an existing ServiceAccount used by a workload, then use that workload’s token to operate with elevated rights without creating new user identities.

### Possible investigation steps

- Identify the principal that created the binding (user/service account), along with the source IP, user-agent, and authentication method, to determine whether it originated from an expected controller, CI/CD system, or a suspicious client.
- Review the new RoleBinding/ClusterRoleBinding’s `roleRef` and subjects to determine what permissions were granted, and assess blast radius by inspecting the referenced Role/ClusterRole rules for high-impact verbs/resources (e.g., secrets, pods/exec, nodes, RBAC).
- Determine where the referenced ServiceAccount is used by enumerating pods/deployments in the namespace that run under it, checking whether service account tokens are mounted, and whether this SA is associated with privileged workloads or externally reachable services.
- Correlate nearby audit activity for additional RBAC or identity changes (new roles, bindings, service accounts, token requests) and for follow-on actions performed using the ServiceAccount that indicate attempted privilege escalation or persistence.
- Validate the change against approved deployment/change records and, if unauthorized or overly permissive, remove/roll back the binding and rotate or invalidate the ServiceAccount credentials while tightening RBAC to least privilege.


### False positive analysis

- A cluster administrator or GitOps-driven deployment legitimately creates or updates RoleBindings/ClusterRoleBindings to grant a workload ServiceAccount the minimal permissions required for a new release, namespace onboarding, or routine RBAC refactoring.
- Kubernetes controllers or automation running under authorized identities (e.g., internal operators, admission policies, or namespace provisioning jobs) create bindings for default or system ServiceAccounts as part of standard cluster bootstrap, reconciliation, or multi-tenant namespace setup.


### Response and remediation

- Immediately fetch and snapshot the created RoleBinding/ClusterRoleBinding manifest, its referenced Role/ClusterRole, and recent Kubernetes audit events around the creator and the ServiceAccount to preserve evidence and establish scope.
- Contain potential misuse by deleting or scaling down workloads that use the referenced ServiceAccount and temporarily revoking the new binding (or applying an emergency deny policy via admission controls) until the change is validated.
- Eradicate unauthorized privilege delegation by removing the binding, replacing it with a least-privilege Role/RoleBinding scoped to the required namespace/resources, and rotating credentials by recreating the ServiceAccount or forcing token/key rotation for any dependent workloads.
- Recover safely by redeploying affected applications with the corrected RBAC, validating that required operations succeed without cluster-admin-equivalent rights, and monitoring for repeated binding creation or follow-on access to secrets, pod exec, or node-level resources.
- Escalate to platform security/incident response immediately if the binding references a high-privilege ClusterRole (e.g., cluster-admin), targets a broadly used ServiceAccount, or is followed by suspicious actions such as secret reads, new token requests, or pod exec sessions from the same identity.
- Harden by enforcing RBAC guardrails with admission policies that restrict who can create RoleBindings/ClusterRoleBindings and which roles may be referenced, disabling auto-mounting of service account tokens where not needed, and adopting GitOps-only RBAC changes with mandatory review.


## Rule Query

```kuery
event.dataset: "kubernetes.audit_logs" and kubernetes.audit.requestObject.spec.serviceAccountName:* and
kubernetes.audit.verb:"create" and kubernetes.audit.objectRef.resource:("rolebindings" or "clusterrolebindings") and
kubernetes.audit.annotations.authorization_k8s_io/decision:"allow"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Account Manipulation
- Id: T1098
- Reference URL: [[https://attack.mitre.org/techniques/T1098/](https://attack.mitre.org/techniques/T1098/)](https://attack.mitre.org/techniques/T1098/)
- Sub Technique:
  - Name: Additional Container Cluster Roles
- Id: T1098.006
- Reference URL: [[https://attack.mitre.org/techniques/T1098/006/](https://attack.mitre.org/techniques/T1098/006/)](https://attack.mitre.org/techniques/T1098/006/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Account Manipulation
- Id: T1098
- Reference URL: [[https://attack.mitre.org/techniques/T1098/](https://attack.mitre.org/techniques/T1098/)](https://attack.mitre.org/techniques/T1098/)
- Sub Technique:
  - Name: Additional Container Cluster Roles
- Id: T1098.006
- Reference URL: [[https://attack.mitre.org/techniques/T1098/006/](https://attack.mitre.org/techniques/T1098/006/)](https://attack.mitre.org/techniques/T1098/006/)