﻿---
title: Kubernetes Creation or Modification of Sensitive Role
description: Detects the creation or modification of Kubernetes Roles or ClusterRoles that grant high-risk permissions, such as wildcard access or RBAC escalation...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/kubernetes/persistence_sensitive_role_creation_or_modification
products:
  - Elastic Security
---

# Kubernetes Creation or Modification of Sensitive Role
Detects the creation or modification of Kubernetes Roles or ClusterRoles that grant high-risk permissions,
such as wildcard access or RBAC escalation verbs (e.g., bind, escalate, impersonate), which may enable
privilege escalation or unauthorized access within the cluster.
**Rule type**: esql
**Rule indices**:
**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: ``
**Maximum alerts per execution**: 100
**References**:
- [[https://heilancoos.github.io/research/2025/12/16/kubernetes.html#overly-permissive-role-based-access-control](https://heilancoos.github.io/research/2025/12/16/kubernetes.html#overly-permissive-role-based-access-control)](https://heilancoos.github.io/research/2025/12/16/kubernetes.html#overly-permissive-role-based-access-control)

**Tags**:
- Data Source: Kubernetes
- Domain: Kubernetes
- Use Case: Threat Detection
- Tactic: Persistence
- Tactic: Privilege Escalation
- Resources: Investigation Guide

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Kubernetes Creation or Modification of Sensitive Role

This rule detects allowed create, update, or patch actions on Roles and ClusterRoles that introduce high-risk RBAC permissions, including wildcard access and escalation verbs like bind, escalate, or impersonate. These changes matter because they can silently expand privileges and enable persistence or lateral movement across the cluster. Attackers commonly add a new ClusterRole with `*` verbs/resources and then use it to bind themselves or a service account to cluster-admin–equivalent access.

### Possible investigation steps

- Identify the responsible identity and origin by reviewing the audit event’s user/service account, userAgent, and source IPs, then confirm whether the action came from approved automation (e.g., GitOps/CI) or an interactive session.
- Retrieve and diff the Role/ClusterRole manifest before vs after the change to pinpoint newly added wildcards, escalation verbs (bind/escalate/impersonate), or permissions over RBAC resources that enable privilege escalation.
- Enumerate RoleBindings/ClusterRoleBindings that reference the modified role and determine which users/groups/service accounts gained effective permissions, prioritizing bindings created/changed near the same time.
- Validate authorization intent by correlating the change with a change ticket/PR and the expected namespace/cluster scope, and flag any out-of-band edits (kubectl apply/edit) that bypass the normal workflow.
- If suspicious, contain by reverting the role and removing or disabling newly privileged bindings/subjects, then hunt for follow-on activity from the same identity (e.g., creation of new service accounts, secrets access, or additional RBAC changes) within the incident window.


### False positive analysis

- Cluster administrators or platform automation legitimately create or update Roles/ClusterRoles to include wildcard verbs/resources or escalation-related verbs (bind/escalate/impersonate) during initial cluster bootstrapping, feature enablement, or maintenance, especially when enabling broad operational access for system components.
- Routine RBAC refactoring such as consolidating multiple granular roles into a single reusable role, migrating permissions across namespaces, or adjusting access for incident response can temporarily add permissions over RBAC resources (roles/rolebindings/clusterroles/clusterrolebindings) and trigger the rule even when the change is approved and tracked.


### Response and remediation

- Immediately locate and quarantine the changed Role/ClusterRole by reverting it to the last known-good manifest (from Git/GitOps) or deleting it if unauthorized, and remove any new RoleBinding/ClusterRoleBinding subjects that reference it.
- Contain the actor by disabling or rotating credentials for the responsible user/service account (and its tokens), and if the change came from a workload, isolate the namespace/workload (scale down, deny egress) until provenance is confirmed.
- Eradicate persistence by searching for and removing additional RBAC changes made in the same window (new roles, bindings, service accounts) and by revoking any newly granted access to secrets or cluster-scoped resources discovered during review.
- Recover by redeploying RBAC from a controlled pipeline, validating effective permissions for impacted subjects, and monitoring for re-creation of the same role name or re-binding attempts after rollback.
- Escalate to platform security/incident response immediately if the role grants wildcard permissions, includes `impersonate`/`escalate`/`bind`, is cluster-scoped, or is bound to non-admin subjects or external identities without an approved change record.
- Harden by enforcing RBAC guardrails (OPA Gatekeeper/Kyverno policies blocking wildcard/escalation verbs except for approved groups), restricting who can create/update RBAC objects, and requiring all RBAC changes to flow through code review and signed GitOps automation.


## Rule Query

```esql
FROM logs-kubernetes.audit_logs-* metadata _id, _index, _version
| WHERE
  kubernetes.audit.objectRef.resource in ("roles", "clusterroles") and
  kubernetes.audit.verb in ("create", "update", "patch") and
  `kubernetes.audit.annotations.authorization_k8s_io/decision` == "allow" and
  kubernetes.audit.level == "RequestResponse" and kubernetes.audit.stage == "ResponseComplete" and
  KQL("""kubernetes.audit.requestObject.rules.verbs:("*" or "escalate" or "bind" or "impersonate") or kubernetes.audit.requestObject.rules.resources:("clusterroles" or "clusterrolebindings" or "roles" or "rolebindings")""")
| KEEP
  @timestamp,
  data_stream.namespace,
  `kubernetes.audit.annotations.authorization_k8s_io/decision`,
  kubernetes.audit.level,
  kubernetes.audit.objectRef.name,
  kubernetes.audit.objectRef.resource,
  kubernetes.audit.requestURI,
  kubernetes.audit.responseStatus.code,
  kubernetes.audit.sourceIPs,
  kubernetes.audit.stage,
  kubernetes.audit.user.groups,
  kubernetes.audit.user.username,
  kubernetes.audit.userAgent,
  kubernetes.audit.verb,
  _id,
  _index,
  _version
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Account Manipulation
- Id: T1098
- Reference URL: [[https://attack.mitre.org/techniques/T1098/](https://attack.mitre.org/techniques/T1098/)](https://attack.mitre.org/techniques/T1098/)
- Sub Technique:
  - Name: Additional Container Cluster Roles
- Id: T1098.006
- Reference URL: [[https://attack.mitre.org/techniques/T1098/006/](https://attack.mitre.org/techniques/T1098/006/)](https://attack.mitre.org/techniques/T1098/006/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Account Manipulation
- Id: T1098
- Reference URL: [[https://attack.mitre.org/techniques/T1098/](https://attack.mitre.org/techniques/T1098/)](https://attack.mitre.org/techniques/T1098/)
- Sub Technique:
  - Name: Additional Container Cluster Roles
- Id: T1098.006
- Reference URL: [[https://attack.mitre.org/techniques/T1098/006/](https://attack.mitre.org/techniques/T1098/006/)](https://attack.mitre.org/techniques/T1098/006/)