﻿---
title: Kubernetes Exposed Service Created With Type NodePort
description: This rule detects an attempt to create or modify a service as type NodePort. The NodePort service allows a user to externally expose a set of labeled...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/kubernetes/persistence_exposed_service_created_with_type_nodeport
products:
  - Elastic Security
---

# Kubernetes Exposed Service Created With Type NodePort
This rule detects an attempt to create or modify a service as type NodePort. The NodePort service allows a user to
externally expose a set of labeled pods to the internet. This creates an open port on every worker node in the cluster
that has a pod for that service. When external traffic is received on that open port, it directs it to the specific pod
through the service representing it. A malicious user can configure a service as type Nodeport in order to intercept
traffic from other pods or nodes, bypassing firewalls and other network security measures configured for load balancers
within a cluster. This creates a direct method of communication between the cluster and the outside world, which could
be used for more malicious behavior and certainly widens the attack surface of your cluster.
**Rule type**: query
**Rule indices**:
- logs-kubernetes.audit_logs-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: ``
**Maximum alerts per execution**: 100
**References**:
- [[https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services-service-types](https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services-service-types)](https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services-service-types)
- [[https://kubernetes.io/docs/concepts/services-networking/service/#type-nodeport](https://kubernetes.io/docs/concepts/services-networking/service/#type-nodeport)](https://kubernetes.io/docs/concepts/services-networking/service/#type-nodeport)
- [[https://www.tigera.io/blog/new-vulnerability-exposes-kubernetes-to-man-in-the-middle-attacks-heres-how-to-mitigate/](https://www.tigera.io/blog/new-vulnerability-exposes-kubernetes-to-man-in-the-middle-attacks-heres-how-to-mitigate/)](https://www.tigera.io/blog/new-vulnerability-exposes-kubernetes-to-man-in-the-middle-attacks-heres-how-to-mitigate/)

**Tags**:
- Data Source: Kubernetes
- Tactic: Execution
- Tactic: Persistence
- Resources: Investigation Guide

**Version**: 207
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Kubernetes Exposed Service Created With Type NodePort

Kubernetes NodePort services enable external access to cluster pods by opening a port on each worker node. This can be exploited by attackers to bypass network security, intercept traffic, or establish unauthorized communication channels. The detection rule identifies suspicious NodePort service creation or modification by monitoring Kubernetes audit logs for specific actions and authorization decisions, helping to mitigate potential security risks.

### Possible investigation steps

- Review the Kubernetes audit logs to identify the specific service that was created or modified with the type NodePort. Focus on entries where kubernetes.audit.objectRef.resource is "services" and kubernetes.audit.verb is "create", "update", or "patch".
- Check the kubernetes.audit.annotations.authorization_k8s_io/decision field to confirm that the action was allowed, ensuring that the service creation or modification was authorized.
- Identify the user or service account responsible for the action by examining the relevant fields in the audit logs, such as the user identity or service account name.
- Investigate the context of the NodePort service by reviewing the associated pods and their labels to understand what applications or services are being exposed externally.
- Assess the network security implications by determining if the NodePort service could potentially bypass existing firewalls or security controls, and evaluate the risk of unauthorized access or data interception.
- Verify if the NodePort service is necessary for legitimate business purposes or if it was created without proper justification, indicating potential malicious intent.


### False positive analysis

- Routine service updates or deployments may trigger the rule if NodePort services are part of standard operations. To manage this, create exceptions for specific namespaces or service accounts that are known to perform these actions regularly.
- Development or testing environments often use NodePort services for ease of access. Exclude these environments from the rule by filtering based on labels or annotations that identify non-production clusters.
- Automated deployment tools or scripts that configure services as NodePort for legitimate reasons can cause false positives. Identify these tools and add their service accounts to an exception list to prevent unnecessary alerts.
- Internal services that require external access for legitimate business needs might be flagged. Document these services and apply exceptions based on their specific labels or annotations to avoid false alarms.
- Temporary configurations during incident response or troubleshooting might involve NodePort services. Ensure that these activities are logged and approved, and consider temporary exceptions during the incident resolution period.


### Response and remediation

- Immediately isolate the affected NodePort service by removing or disabling it to prevent further unauthorized access or traffic interception.
- Review and revoke any unauthorized access or permissions granted to users or service accounts that created or modified the NodePort service.
- Conduct a thorough audit of network traffic logs to identify any suspicious or unauthorized external connections made through the NodePort service.
- Implement network segmentation and firewall rules to restrict external access to critical services and ensure that only necessary ports are exposed.
- Escalate the incident to the security operations team for further investigation and to assess potential impacts on the cluster's security posture.
- Apply security patches and updates to Kubernetes components and worker nodes to mitigate any known vulnerabilities that could be exploited.
- Enhance monitoring and alerting mechanisms to detect future unauthorized NodePort service creations or modifications promptly.


## Setup

The Kubernetes Fleet integration with Audit Logs enabled or similarly structured data is required to be compatible with this rule.

## Rule Query

```kuery
event.dataset : "kubernetes.audit_logs"
  and kubernetes.audit.annotations.authorization_k8s_io/decision:"allow"
  and kubernetes.audit.objectRef.resource:"services"
  and kubernetes.audit.verb:("create" or "update" or "patch")
  and kubernetes.audit.requestObject.spec.type:"NodePort"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: External Remote Services
- Id: T1133
- Reference URL: [[https://attack.mitre.org/techniques/T1133/](https://attack.mitre.org/techniques/T1133/)](https://attack.mitre.org/techniques/T1133/)