﻿---
title: Kubernetes User Exec into Pod
description: This rule detects a user attempt to establish a shell session into a pod using the 'exec' command. Using the 'exec' command in a pod allows a user to...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/kubernetes/execution_user_exec_to_pod
products:
  - Elastic Security
---

# Kubernetes User Exec into Pod
This rule detects a user attempt to establish a shell session into a pod using the 'exec' command. Using the 'exec'
command in a pod allows a user to establish a temporary shell session and execute any process/commands in the pod. An
adversary may call bash to gain a persistent interactive shell which will allow access to any data the pod has
permissions to, including secrets.
**Rule type**: eql
**Rule indices**:
- logs-kubernetes.audit_logs-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: ``
**Maximum alerts per execution**: 100
**References**:
- [[https://kubernetes.io/docs/tasks/debug/debug-application/debug-running-pod/](https://kubernetes.io/docs/tasks/debug/debug-application/debug-running-pod/)](https://kubernetes.io/docs/tasks/debug/debug-application/debug-running-pod/)
- [[https://kubernetes.io/docs/tasks/debug/debug-application/get-shell-running-container/](https://kubernetes.io/docs/tasks/debug/debug-application/get-shell-running-container/)](https://kubernetes.io/docs/tasks/debug/debug-application/get-shell-running-container/)

**Tags**:
- Data Source: Kubernetes
- Domain: Kubernetes
- Use Case: Threat Detection
- Tactic: Execution
- Resources: Investigation Guide

**Version**: 210
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Kubernetes User Exec into Pod

Kubernetes allows users to execute commands within a pod using the 'exec' command, facilitating temporary shell sessions for legitimate management tasks. However, adversaries can exploit this to gain unauthorized access, potentially exposing sensitive data. The detection rule identifies such misuse by monitoring audit logs for specific patterns, such as allowed 'exec' actions on pods, indicating possible malicious activity.

### Possible investigation steps

- Review the Kubernetes audit logs to identify the user who executed the 'exec' command by examining the event.dataset field for "kubernetes.audit_logs".
- Check the kubernetes.audit.annotations.authorization_k8s_io/decision field to confirm that the action was allowed and determine if the user had legitimate access.
- Investigate the kubernetes.audit.objectRef.resource and kubernetes.audit.objectRef.subresource fields to verify that the action involved a pod and the 'exec' subresource.
- Analyze the context of the pod involved, including its purpose and the data it has access to, to assess the potential impact of the unauthorized access.
- Correlate the event with other logs or alerts to identify any suspicious patterns or repeated unauthorized access attempts by the same user or IP address.
- Review the user's activity history to determine if there are other instances of unusual or unauthorized access attempts within the Kubernetes environment.


### False positive analysis

- Routine administrative tasks by DevOps teams can trigger the rule when they use 'exec' for legitimate management purposes. To handle this, create exceptions for specific user accounts or roles that are known to perform these tasks regularly.
- Automated scripts or tools that use 'exec' for monitoring or maintenance can also cause false positives. Identify these scripts and whitelist their associated service accounts or IP addresses.
- Scheduled jobs or cron tasks that require 'exec' to perform updates or checks within pods may be flagged. Exclude these by setting up time-based exceptions for known maintenance windows.
- Development environments where frequent testing and debugging occur using 'exec' can lead to alerts. Implement environment-specific exclusions to reduce noise from non-production clusters.


### Response and remediation

- Immediately isolate the affected pod to prevent further unauthorized access or data exposure. This can be done by applying network policies or temporarily scaling down the pod.
- Review the audit logs to identify the user or service account responsible for the 'exec' command and assess whether the access was legitimate or unauthorized.
- Revoke or adjust permissions for the identified user or service account to prevent further unauthorized 'exec' actions. Ensure that only necessary permissions are granted following the principle of least privilege.
- Conduct a thorough investigation of the pod's environment to identify any potential data exposure or tampering. Check for unauthorized changes to configurations, secrets, or data within the pod.
- If unauthorized access is confirmed, rotate any exposed secrets or credentials that the pod had access to, and update any affected systems or services.
- Escalate the incident to the security operations team for further analysis and to determine if additional systems or pods have been compromised.
- Enhance monitoring and alerting for similar 'exec' actions in the future by ensuring that audit logs are continuously reviewed and that alerts are configured to notify the security team of any suspicious activity.


## Setup

The Kubernetes Fleet integration with Audit Logs enabled or similarly structured data is required to be compatible with this rule.

## Rule Query

```eql
any where event.dataset == "kubernetes.audit_logs" and kubernetes.audit.verb in ("get", "create") and
kubernetes.audit.objectRef.subresource == "exec" and kubernetes.audit.stage in ("ResponseComplete", "ResponseStarted") and
kubernetes.audit.level == "Request" and `kubernetes.audit.annotations.authorization_k8s_io/decision` == "allow" and
not (
  (kubernetes.audit.objectRef.namespace == "trident" and kubernetes.audit.objectRef.name like "trident-controller-*") or
  (kubernetes.audit.objectRef.namespace == "vuls" and kubernetes.audit.requestURI like "/api/v1/namespaces/vuls/pods/vuls-*/exec?command=sh&command=-c&command=*+%2Fvuls%2Fresults*") or
  (kubernetes.audit.objectRef.namespace == "git-runners" and kubernetes.audit.requestURI like (
     "/api/v1/namespaces/git-runners/pods/runner-*/exec?command=sh&command=-c&command=if+%5B+-x+%2Fusr%2Flocal%2Fbin%2Fbash+%5D%3B+then%0A%09exec+%2Fusr%2Flocal%2Fbin%2Fbash+%0Aelif+%5B+-x+%2Fusr%2Fbin%2Fbash+%5D%3B+then%0A%09exec+%2Fusr%2Fbin%2Fbash+%0Aelif+%5B+-x+%2Fbin%2Fbash+%5D%3B+then%0A%09exec+%2Fbin%2Fbash+%0Aelif+%5B+-x+%2Fusr%2Flocal%2Fbin%2Fsh+%5D%3B+then%0A%09exec+%2Fusr%2Flocal%2Fbin%2Fsh+%0Aelif+%5B+-x+%2Fusr%2Fbin%2Fsh+%5D%3B+then%0A%09exec+%2Fusr%2Fbin%2Fsh+%0Aelif+%5B+-x+%2Fbin%2Fsh+%5D%3B+then%0A%09exec+%2Fbin%2Fsh+%0Aelif+%5B+-x+%2Fbusybox%2Fsh+%5D%3B+then%0A%09exec+%2Fbusybox%2Fsh+%0Aelse%0A%09echo+shell+not+found%0A%09exit+1%0Afi%0A%0A&container=*&container=*&stderr=true&stdin=true&stdout=true",
     "/api/v1/namespaces/git-runners/pods/runner-*/exec?command=gitlab-runner-helper&command=read-logs&command=--path&command=%2Flogs-*%2Foutput.log&command=--offset&command=0&command=--wait-file-timeout&command=1m0s&container=*&container=*&stderr=true&stdout=true"
  )) or
  (kubernetes.audit.objectRef.namespace == "elasticsearch-cluster" and kubernetes.audit.requestURI like (
    "/api/v1/namespaces/elasticsearch-cluster/pods/*/exec?command=df&command=-h&container=elasticsearch&stdin=true&stdout=true&tty=true",
    "/api/v1/namespaces/elasticsearch-cluster/pods/*/exec?command=df&command=-h&container=elasticsearch&stderr=true&stdout=true",
    "/api/v1/namespaces/elasticsearch-cluster/pods/*/exec?command=df&command=-h&container=kibana&stderr=true&stdout=true"
  )) or
  (kubernetes.audit.objectRef.namespace == "kube-system" and kubernetes.audit.requestURI like (
    "/api/v1/namespaces/kube-system/pods/*/exec?command=%2Fproxy-agent&command=--help&container=konnectivity-agent&stderr=true&stdout=true",
    "api/v1/namespaces/kube-system/pods/*/exec?command=cilium&command=endpoint&command=list&command=-o&command=json&container=cilium-agent&stderr=true&stdout=true",
    "/api/v1/namespaces/kube-system/pods/*/exec?command=cilium&command=status&command=-o&command=json&container=cilium-agent&stderr=true&stdout=true",
    "/api/v1/namespaces/kube-system/pods/*/exec?command=sh&command=-c&command=clear%3B+%28bash+%7C%7C+ash+%7C%7C+sh%29&container=*&stdin=true&stdout=true&tty=true"
  ))
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Container Administration Command
- Id: T1609
- Reference URL: [[https://attack.mitre.org/techniques/T1609/](https://attack.mitre.org/techniques/T1609/)](https://attack.mitre.org/techniques/T1609/)