﻿---
title: Kubernetes Anonymous User Create/Update/Patch Pods Request
description: This rule detects attempts to create, update, or patch pods by an anonymous user. An anonymous user is a user that is not authenticated or authorized...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/kubernetes/execution_anonymous_create_update_patch_pod_request
products:
  - Elastic Security
---

# Kubernetes Anonymous User Create/Update/Patch Pods Request
This rule detects attempts to create, update, or patch pods by an anonymous user. An anonymous user is a user that
is not authenticated or authorized to access the Kubernetes API server. Creating, updating, or patching pods is a common
activity for attackers to gain access to the cluster and execute commands.
**Rule type**: eql
**Rule indices**:
- logs-kubernetes.audit_logs-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: ``
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Data Source: Kubernetes
- Domain: Kubernetes
- Use Case: Threat Detection
- Tactic: Execution
- Resources: Investigation Guide

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```eql
any where event.dataset == "kubernetes.audit_logs" and (
    kubernetes.audit.user.username in ("system:anonymous", "system:unauthenticated") or
    kubernetes.audit.user.username == null or
    kubernetes.audit.user.username == ""
  ) and kubernetes.audit.level in ("RequestResponse", "ResponseComplete", "Request") and kubernetes.audit.verb in ("create", "update", "patch") and
kubernetes.audit.objectRef.resource == "pods"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)