﻿---
title: Google Workspace Role Modified
description: Detects when a custom admin role or its permissions are modified. An adversary may modify a custom admin role in order to elevate the permissions of other...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/google_workspace/persistence_google_workspace_role_modified
products:
  - Elastic Security
---

# Google Workspace Role Modified
Detects when a custom admin role or its permissions are modified. An adversary may modify a custom admin role in order
to elevate the permissions of other user accounts and persist in their target’s environment.
**Rule type**: query
**Rule indices**:
- filebeat-*
- logs-google_workspace*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 10m
**Searches indices from**: `now-130m`
**Maximum alerts per execution**: 100
**References**:
- [[https://support.google.com/a/answer/2406043?hl=en](https://support.google.com/a/answer/2406043?hl=en)](https://support.google.com/a/answer/2406043?hl=en)
- [[https://www.elastic.co/security-labs/google-workspace-attack-surface-part-one](https://www.elastic.co/security-labs/google-workspace-attack-surface-part-one)](https://www.elastic.co/security-labs/google-workspace-attack-surface-part-one)
- [[https://www.elastic.co/security-labs/google-workspace-attack-surface-part-two](https://www.elastic.co/security-labs/google-workspace-attack-surface-part-two)](https://www.elastic.co/security-labs/google-workspace-attack-surface-part-two)

**Tags**:
- Domain: Cloud
- Data Source: Google Workspace
- Use Case: Identity and Access Audit
- Resources: Investigation Guide
- Tactic: Persistence

**Version**: 208
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating Google Workspace Role Modified

Google Workspace roles allow administrators to assign specific permissions to users or groups where the principle of least privilege (PoLP) is recommended. Admin roles in Google Workspace grant users access to the Google Admin console, where more domain-wide settings are accessible. Google Workspace contains prebuilt admin roles for performing business functions related to users, groups, and services. Custom administrator roles can be created where prebuilt roles are not preferred. Each Google Workspace service has a set of custodial privileges that can be added to custom roles.
Roles assigned to users will grant them additional permissions and privileges within the Google Workspace domain. Threat actors might modify existing roles with new privileges to advance their intrusion efforts and laterally move throughout the organization. Users with unexpected privileges might also cause operational dysfunction if unfamiliar settings are adjusted without warning.
This rule identifies when a Google Workspace role is modified.

#### Possible investigation steps

- Identify the associated user accounts by reviewing `user.name` or `user.email` fields in the alert.
- Identify the role modified by reviewing the `google_workspace.admin.role.name` field in the alert.
- Identify the privilege that was added or removed by reviewing the `google_workspace.admin.privilege.name` field in the alert.
- After identifying the involved user, verify administrative privileges are scoped properly.
- To identify other users with this role, search for `event.action: ASSIGN_ROLE`
  - Add `google_workspace.admin.role.name` with the role added as an additional filter.
- Adjust the relative time accordingly to identify all users that were assigned this role.
- Identify if the user account was recently created by searching for `event.action: CREATE_USER`.
- If a privilege was added, monitor users assigned this role for the next 24 hours and look for attempts to use the new privilege.
  - The `event.provider` field will help filter for specific services in Google Workspace such as Drive or Admin.
- The `event.action` field will help trace actions that are being taken by users.


### False positive analysis

- After identifying the user account that modified the role, verify the action was intentional.
- Verify that the user is expected to have administrative privileges in Google Workspace to modify roles.
- Review organizational units or groups the role might have been added to and ensure the new privileges align properly.
- Use the `user.name` to filter for `event.action` where `ADD_PRIVILEGE` or `UPDATE_ROLE` has been seen before to check if these actions are new or historical.


### Response and remediation

- Initiate the incident response process based on the outcome of the triage.
- Disable or limit the account during the investigation and response.
- Identify the possible impact of the incident and prioritize accordingly; the following actions can help you gain context:
  - Identify the account role in the cloud environment.
- Assess the criticality of affected services and servers.
- Work with your IT team to identify and minimize the impact on users.
- Identify if the attacker is moving laterally and compromising other accounts, servers, or services.
- Identify any regulatory or legal ramifications related to this activity.
- Investigate credential exposure on systems compromised or used by the attacker to ensure all compromised accounts are identified. Reset passwords or delete API keys as needed to revoke the attacker's access to the environment. Work with your IT teams to minimize the impact on business operations during these actions.
- Review the permissions assigned to the implicated user to ensure that the least privilege principle is being followed.
- Implement security best practices [outlined](https://support.google.com/a/answer/7587183) by Google.
- Determine the initial vector abused by the attacker and take action to prevent reinfection via the same vector.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Setup

The Google Workspace Fleet integration, Filebeat module, or similarly structured data is required to be compatible with this rule.

### Important Information Regarding Google Workspace Event Lag Times

- As per Google's documentation, Google Workspace administrators may observe lag times ranging from minutes up to 3 days between the time of an event's occurrence and the event being visible in the Google Workspace admin/audit logs.
- This rule is configured to run every 10 minutes with a lookback time of 130 minutes.
- To reduce the risk of false negatives, consider reducing the interval that the Google Workspace (formerly G Suite) Filebeat module polls Google's reporting API for new events.
- By default, `var.interval` is set to 2 hours (2h). Consider changing this interval to a lower value, such as 10 minutes (10m).
- See the following references for further information:
  - [https://support.google.com/a/answer/7061566](https://support.google.com/a/answer/7061566)
- [https://www.elastic.co/guide/en/beats/filebeat/current/filebeat-module-google_workspace.html](https://www.elastic.co/guide/en/beats/filebeat/current/filebeat-module-google_workspace.html)


## Rule Query

```kuery
event.dataset:google_workspace.admin and event.provider:admin and event.category:iam and event.action:(ADD_PRIVILEGE or UPDATE_ROLE)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Account Manipulation
- Id: T1098
- Reference URL: [[https://attack.mitre.org/techniques/T1098/](https://attack.mitre.org/techniques/T1098/)](https://attack.mitre.org/techniques/T1098/)