﻿---
title: Google Workspace API Access Granted via Domain-Wide Delegation
description: Detects when a domain-wide delegation of authority is granted to a service account. Domain-wide delegation can be configured to grant third-party and...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/google_workspace/persistence_google_workspace_api_access_granted_via_dwd
products:
  - Elastic Security
---

# Google Workspace API Access Granted via Domain-Wide Delegation
Detects when a domain-wide delegation of authority is granted to a service account. Domain-wide delegation can be
configured to grant third-party and internal applications to access the data of Google Workspace users. An adversary may
configure domain-wide delegation to maintain access to their target’s data.
**Rule type**: query
**Rule indices**:
- filebeat-*
- logs-google_workspace*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://developers.google.com/admin-sdk/directory/v1/guides/delegation](https://developers.google.com/admin-sdk/directory/v1/guides/delegation)](https://developers.google.com/admin-sdk/directory/v1/guides/delegation)
- [[https://www.elastic.co/security-labs/google-workspace-attack-surface-part-one](https://www.elastic.co/security-labs/google-workspace-attack-surface-part-one)](https://www.elastic.co/security-labs/google-workspace-attack-surface-part-one)
- [[https://www.elastic.co/security-labs/google-workspace-attack-surface-part-two](https://www.elastic.co/security-labs/google-workspace-attack-surface-part-two)](https://www.elastic.co/security-labs/google-workspace-attack-surface-part-two)

**Tags**:
- Domain: Cloud
- Data Source: Google Workspace
- Use Case: Identity and Access Audit
- Resources: Investigation Guide
- Tactic: Persistence

**Version**: 209
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating Google Workspace API Access Granted via Domain-Wide Delegation

Domain-wide delegation is a feature that allows apps to access users' data across an organization's Google Workspace environment. Only super admins can manage domain-wide delegation, and they must specify each API scope that the application can access. Google Workspace services all have APIs that can be interacted with after domain-wide delegation is established with an OAuth2 client ID of the application. Typically, GCP service accounts and applications are created where the Google Workspace APIs are enabled, thus allowing the application to access resources and services in Google Workspace.
Applications authorized to interact with Google Workspace resources and services through APIs have a wide range of capabilities depending on the scopes applied. If the principle of least privilege (PoLP) is not practiced when setting API scopes, threat actors could abuse additional privileges if the application is compromised. New applications created and given API access could indicate an attempt by a threat actor to register their malicious application with the Google Workspace domain in an attempt to establish a command and control foothold.
This rule identifies when an application is authorized API client access.

#### Possible investigation steps

- Identify the associated user accounts by reviewing `user.name` or `user.email` fields in the alert.
  - Only users with super admin privileges can authorize API client access.
- Identify the API client name by reviewing the `google_workspace.admin.api.client.name` field in the alert.
  - If GCP audit logs are ingested, pivot to reviewing the last 48 hours of activity related to the service account ID.
- Search for the `google_workspace.admin.api.client.name` value with wildcards in the `gcp.audit.resource_name` field.
- Search for API client name and aggregated results on `event.action` to determine what the service account is being used for in GWS.
- After identifying the involved user, verify super administrative privileges to access domain-wide delegation settings.


### False positive analysis

- Changes to domain-wide delegation require super admin privileges. Check with the user to ensure these changes were expected.
- Review scheduled maintenance notes related to expected API access changes.


### Response and remediation

- Initiate the incident response process based on the outcome of the triage.
- Review the scope of the authorized API client access in Google Workspace.
- Disable or limit the account during the investigation and response.
- Identify the possible impact of the incident and prioritize accordingly; the following actions can help you gain context:
  - Identify the account role in the cloud environment.
- Assess the criticality of affected services and servers.
- Work with your IT team to identify and minimize the impact on users.
- Identify if the attacker is moving laterally and compromising other accounts, servers, or services.
- Identify any regulatory or legal ramifications related to this activity.
- Investigate credential exposure on systems compromised or used by the attacker to ensure all compromised accounts are identified. Reset passwords or delete API keys as needed to revoke the attacker's access to the environment. Work with your IT teams to minimize the impact on business operations during these actions.
- Review the permissions assigned to the implicated user to ensure that the least privilege principle is being followed.
- Implement security best practices [outlined](https://support.google.com/a/answer/7587183) by Google.
- Determine the initial vector abused by the attacker and take action to prevent reinfection via the same vector.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Setup

The Google Workspace Fleet integration, Filebeat module, or similarly structured data is required to be compatible with this rule.

### Important Information Regarding Google Workspace Event Lag Times

- As per Google's documentation, Google Workspace administrators may observe lag times ranging from minutes up to 3 days between the time of an event's occurrence and the event being visible in the Google Workspace admin/audit logs.
- To reduce the risk of false negatives, consider reducing the interval that the Google Workspace (formerly G Suite) Filebeat module polls Google's reporting API for new events.
- By default, `var.interval` is set to 2 hours (2h). Consider changing this interval to a lower value, such as 10 minutes (10m).
- See the following references for further information:
  - [https://support.google.com/a/answer/7061566](https://support.google.com/a/answer/7061566)
- [https://www.elastic.co/guide/en/beats/filebeat/current/filebeat-module-google_workspace.html](https://www.elastic.co/guide/en/beats/filebeat/current/filebeat-module-google_workspace.html)


## Rule Query

```kuery
event.dataset:google_workspace.admin
  and event.provider:admin
  and event.category:iam
  and event.action:AUTHORIZE_API_CLIENT_ACCESS
  and event.outcome:success
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Account Manipulation
- Id: T1098
- Reference URL: [[https://attack.mitre.org/techniques/T1098/](https://attack.mitre.org/techniques/T1098/)](https://attack.mitre.org/techniques/T1098/)