﻿---
title: Google Workspace Admin Role Assigned to a User
description: Assigning the administrative role to a user will grant them access to the Google Admin console and grant them administrator privileges which allow them...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/google_workspace/persistence_google_workspace_admin_role_assigned_to_user
products:
  - Elastic Security
---

# Google Workspace Admin Role Assigned to a User
Assigning the administrative role to a user will grant them access to the Google Admin console and grant them
administrator privileges which allow them to access and manage various resources and applications. An adversary may
create a new administrator account for persistence or apply the admin role to an existing user to carry out further
intrusion efforts. Users with super-admin privileges can bypass single-sign on if enabled in Google Workspace.
**Rule type**: query
**Rule indices**:
- filebeat-*
- logs-google_workspace*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 10m
**Searches indices from**: `now-130m`
**Maximum alerts per execution**: 100
**References**:
- [[https://support.google.com/a/answer/172176?hl=en](https://support.google.com/a/answer/172176?hl=en)](https://support.google.com/a/answer/172176?hl=en)
- [[https://www.elastic.co/security-labs/google-workspace-attack-surface-part-one](https://www.elastic.co/security-labs/google-workspace-attack-surface-part-one)](https://www.elastic.co/security-labs/google-workspace-attack-surface-part-one)
- [[https://www.elastic.co/security-labs/google-workspace-attack-surface-part-two](https://www.elastic.co/security-labs/google-workspace-attack-surface-part-two)](https://www.elastic.co/security-labs/google-workspace-attack-surface-part-two)

**Tags**:
- Domain: Cloud
- Data Source: Google Workspace
- Use Case: Identity and Access Audit
- Tactic: Persistence
- Resources: Investigation Guide

**Version**: 209
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating Google Workspace Admin Role Assigned to a User

Google Workspace roles allow administrators to assign specific permissions to users or groups. These assignments should follow the principle of least privilege (PoLP). Admin roles in Google Workspace grant users access to the Google Admin console, where more domain-wide settings are accessible. Google Workspace contains prebuilt administrator roles for performing business functions related to users, groups, and services. Custom administrator roles can be created when prebuilt roles are not sufficient.
Administrator roles assigned to users will grant them additional permissions and privileges within the Google Workspace domain. Administrative roles also give users access to the admin console, where domain-wide settings can be adjusted. Threat actors might rely on these new privileges to advance their intrusion efforts and laterally move throughout the organization. Users with unexpected administrative privileges may also cause operational dysfunction if unfamiliar settings are adjusted without warning.
This rule identifies when a Google Workspace administrative role is assigned to a user.

#### Possible investigation steps

- Identify the associated user accounts by reviewing `user.name` or `user.email` fields in the alert.
  - The `user.target.email` field contains the user who received the admin role.
- Identify the role given to the user by reviewing the `google_workspace.admin.role.name` field in the alert.
- After identifying the involved user, verify their administrative privileges are scoped properly.
- To identify other users with this role, search the alert for `event.action: ASSIGN_ROLE`.
  - Add `google_workspace.admin.role.name` with the role added as an additional filter.
- Adjust the relative time accordingly to identify all users that were assigned this admin role.
- Identify if the user account was recently created by searching for `event.action: CREATE_USER`.
  - Add `user.email` with the target user account that recently received this new admin role.
- After identifying the involved user, create a filter with their `user.name` or `user.target.email`. Review the last 48 hours of their activity for anything that may indicate a compromise.


### False positive analysis

- After identifying user account that added the admin role, verify the action was intentional.
- Verify that the target user who was assigned the admin role should have administrative privileges in Google Workspace.
- Review organizational units or groups the target user might have been added to and ensure the admin role permissions align.


### Response and remediation

- Initiate the incident response process based on the outcome of the triage.
- Disable or limit the account during the investigation and response.
- Identify the possible impact of the incident and prioritize accordingly; the following actions can help you gain context:
  - Identify the account role in the cloud environment.
- Assess the criticality of affected services and servers.
- Work with your IT team to identify and minimize the impact on users.
- Identify if the attacker is moving laterally and compromising other accounts, servers, or services.
- Identify any regulatory or legal ramifications related to this activity.
- Investigate credential exposure on systems compromised or used by the attacker to ensure all compromised accounts are identified. Reset passwords or delete API keys as needed to revoke the attacker's access to the environment. Work with your IT teams to minimize the impact on business operations during these actions.
- Review the permissions assigned to the implicated user to ensure that the least privilege principle is being followed.
- Implement security best practices [outlined](https://support.google.com/a/answer/7587183) by Google.
- Determine the initial vector abused by the attacker and take action to prevent reinfection via the same vector.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Setup

The Google Workspace Fleet integration, Filebeat module, or similarly structured data is required to be compatible with this rule.

### Important Information Regarding Google Workspace Event Lag Times

- As per Google's documentation, Google Workspace administrators may observe lag times ranging from minutes up to 3 days between the time of an event's occurrence and the event being visible in the Google Workspace admin/audit logs.
- This rule is configured to run every 10 minutes with a lookback time of 130 minutes.
- To reduce the risk of false negatives, consider reducing the interval that the Google Workspace (formerly G Suite) Filebeat module polls Google's reporting API for new events.
- By default, `var.interval` is set to 2 hours (2h). Consider changing this interval to a lower value, such as 10 minutes (10m).
- See the following references for further information:
  - [https://support.google.com/a/answer/7061566](https://support.google.com/a/answer/7061566)
- [https://www.elastic.co/guide/en/beats/filebeat/current/filebeat-module-google_workspace.html](https://www.elastic.co/guide/en/beats/filebeat/current/filebeat-module-google_workspace.html)


## Rule Query

```kuery
event.dataset:"google_workspace.admin" and event.category:"iam" and event.action:"ASSIGN_ROLE"
  and google_workspace.event.type:"DELEGATED_ADMIN_SETTINGS" and google_workspace.admin.role.name : *_ADMIN_ROLE
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Account Manipulation
- Id: T1098
- Reference URL: [[https://attack.mitre.org/techniques/T1098/](https://attack.mitre.org/techniques/T1098/)](https://attack.mitre.org/techniques/T1098/)
- Sub Technique:
  - Name: Additional Cloud Roles
- Id: T1098.003
- Reference URL: [[https://attack.mitre.org/techniques/T1098/003/](https://attack.mitre.org/techniques/T1098/003/)](https://attack.mitre.org/techniques/T1098/003/)