﻿---
title: Forwarded Google Workspace Security Alert
description: Identifies the occurrence of a security alert from the Google Workspace alerts center. Google Workspace's security alert center provides an overview of...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/google_workspace/google_workspace_alert_center_promotion
products:
  - Elastic Security
---

# Forwarded Google Workspace Security Alert
Identifies the occurrence of a security alert from the Google Workspace alerts center. Google Workspace's security alert
center provides an overview of actionable alerts that may be affecting an organization's domain. An alert is a warning
of a potential security issue that Google has detected.
**Rule type**: query
**Rule indices**:
- filebeat-*
- logs-google_workspace*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 10m
**Searches indices from**: `now-130m`
**Maximum alerts per execution**: 100
**References**:
- [[https://workspace.google.com/products/admin/alert-center/](https://workspace.google.com/products/admin/alert-center/)](https://workspace.google.com/products/admin/alert-center/)
- [[https://www.elastic.co/security-labs/google-workspace-attack-surface-part-one](https://www.elastic.co/security-labs/google-workspace-attack-surface-part-one)](https://www.elastic.co/security-labs/google-workspace-attack-surface-part-one)
- [[https://www.elastic.co/security-labs/google-workspace-attack-surface-part-two](https://www.elastic.co/security-labs/google-workspace-attack-surface-part-two)](https://www.elastic.co/security-labs/google-workspace-attack-surface-part-two)

**Tags**:
- Domain: Cloud
- Data Source: Google Workspace
- Use Case: Log Auditing
- Use Case: Threat Detection
- Resources: Investigation Guide

**Version**: 6
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Setup


## Triage and analysis

This is a promotion rule for Google Workspace security events, which are alertable events per the vendor.
Consult vendor documentation on interpreting specific events.

## Rule Query

```kuery
event.dataset: google_workspace.alert
```