﻿---
title: Google Workspace Bitlocker Setting Disabled
description: Google Workspace administrators whom manage Windows devices and have Windows device management enabled may also enable BitLocker drive encryption to mitigate...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/google_workspace/defense_evasion_google_workspace_bitlocker_setting_disabled
products:
  - Elastic Security
---

# Google Workspace Bitlocker Setting Disabled
Google Workspace administrators whom manage Windows devices and have Windows device management enabled may also enable
BitLocker drive encryption to mitigate unauthorized data access on lost or stolen computers. Adversaries with valid
account access may disable BitLocker to access sensitive data on an endpoint added to Google Workspace device
management.
**Rule type**: query
**Rule indices**:
- filebeat-*
- logs-google_workspace*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 10m
**Searches indices from**: `now-130m`
**Maximum alerts per execution**: 100
**References**:
- [[https://support.google.com/a/answer/9176657?hl=en](https://support.google.com/a/answer/9176657?hl=en)](https://support.google.com/a/answer/9176657?hl=en)
- [[https://www.elastic.co/security-labs/google-workspace-attack-surface-part-one](https://www.elastic.co/security-labs/google-workspace-attack-surface-part-one)](https://www.elastic.co/security-labs/google-workspace-attack-surface-part-one)
- [[https://www.elastic.co/security-labs/google-workspace-attack-surface-part-two](https://www.elastic.co/security-labs/google-workspace-attack-surface-part-two)](https://www.elastic.co/security-labs/google-workspace-attack-surface-part-two)

**Tags**:
- Domain: Cloud
- Data Source: Google Workspace
- Use Case: Configuration Audit
- Tactic: Defense Evasion
- Resources: Investigation Guide

**Version**: 109
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating Google Workspace Bitlocker Setting Disabled

BitLocker Drive Encryption is a data protection feature that integrates with the Windows operating system to address the data theft or exposure threats from lost, stolen, or inappropriately decommissioned computers. BitLocker helps mitigate unauthorized data access by enhancing file and system protections, such as data encryption and rendering data inaccessible. Google Workspace can sync with Windows endpoints that are registered in inventory, where BitLocker can be enabled and disabled.
Disabling Bitlocker on an endpoint decrypts data at rest and makes it accessible, which raises the risk of exposing sensitive endpoint data.
This rule identifies a user with administrative privileges and access to the admin console, disabling BitLocker for Windows endpoints.

#### Possible investigation steps

- Identify the associated user accounts by reviewing `user.name` or `user.email` fields in the alert.
- After identifying the user, verify if the user should have administrative privileges to disable BitLocker on Windows endpoints.
- From the Google Workspace admin console, review `Reporting > Audit` and `Investigation > Device` logs, filtering on the user email identified from the alert.
  - If a Google Workspace user logged into their account using a potentially compromised account, this will create an `Device sync event` event.


### False positive analysis

- An administrator may have intentionally disabled BitLocker for routine maintenance or endpoint updates.
  - Verify with the user that they intended to disable BitLocker on Windows endpoints.


### Response and remediation

- Initiate the incident response process based on the outcome of the triage.
- Disable or limit the account during the investigation and response.
- Identify the possible impact of the incident and prioritize accordingly; the following actions can help you gain context:
  - Identify the account role in the cloud environment.
- Assess the criticality of affected services and servers.
- Work with your IT team to identify and minimize the impact on users.
- Identify if the attacker is moving laterally and compromising other accounts, servers, or services.
- Identify any regulatory or legal ramifications related to this activity.
- Investigate credential exposure on systems compromised or used by the attacker to ensure all compromised accounts are identified. Reset passwords or delete API keys as needed to revoke the attacker's access to the environment. Work with your IT teams to minimize the impact on business operations during these actions.
- Review the permissions assigned to the implicated user to ensure that the least privilege principle is being followed.
- Implement security best practices [outlined](https://support.google.com/a/answer/7587183) by Google.
- Determine the initial vector abused by the attacker and take action to prevent reinfection via the same vector.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Setup

The Google Workspace Fleet integration, Filebeat module, or similarly structured data is required to be compatible with this rule.

### Important Information Regarding Google Workspace Event Lag Times

- As per Google's documentation, Google Workspace administrators may observe lag times ranging from minutes up to 3 days between the time of an event's occurrence and the event being visible in the Google Workspace admin/audit logs.
- This rule is configured to run every 10 minutes with a lookback time of 130 minutes.
- To reduce the risk of false negatives, consider reducing the interval that the Google Workspace (formerly G Suite) Filebeat module polls Google's reporting API for new events.
- By default, `var.interval` is set to 2 hours (2h). Consider changing this interval to a lower value, such as 10 minutes (10m).
- See the following references for further information:
  - [https://support.google.com/a/answer/7061566](https://support.google.com/a/answer/7061566)
- [https://www.elastic.co/guide/en/beats/filebeat/current/filebeat-module-google_workspace.html](https://www.elastic.co/guide/en/beats/filebeat/current/filebeat-module-google_workspace.html)


## Rule Query

```kuery
event.dataset:"google_workspace.admin" and event.action:"CHANGE_APPLICATION_SETTING" and event.category:(iam or configuration)
    and google_workspace.admin.new_value:"Disabled" and google_workspace.admin.setting.name:BitLocker*
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Impair Defenses
- Id: T1562
- Reference URL: [[https://attack.mitre.org/techniques/T1562/](https://attack.mitre.org/techniques/T1562/)](https://attack.mitre.org/techniques/T1562/)
- Sub Technique:
  - Name: Disable or Modify Tools
- Id: T1562.001
- Reference URL: [[https://attack.mitre.org/techniques/T1562/001/](https://attack.mitre.org/techniques/T1562/001/)](https://attack.mitre.org/techniques/T1562/001/)