﻿---
title: GitHub Actions Workflow Modification Blocked
description: Detects when a GitHub Actions workflow attempts to create or modify workflow files in a protected branch but is blocked due to insufficient permissions...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/github/initial_access_github_actions_workflow_injection_blocked
products:
  - Elastic Security
---

# GitHub Actions Workflow Modification Blocked
Detects when a GitHub Actions workflow attempts to create or modify workflow files in a protected branch but is blocked
due to insufficient permissions. This behavior is indicative of a supply chain attack where a malicious package or
compromised CI/CD pipeline attempts to inject persistent backdoor workflows into a repository.
**Rule type**: esql
**Rule indices**:
**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 8m
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.wiz.io/blog/shai-hulud-2-0-ongoing-supply-chain-attack](https://www.wiz.io/blog/shai-hulud-2-0-ongoing-supply-chain-attack)](https://www.wiz.io/blog/shai-hulud-2-0-ongoing-supply-chain-attack)

**Tags**:
- Domain: Cloud
- Use Case: Threat Detection
- Tactic: Initial Access
- Tactic: Persistence
- Tactic: Execution
- Data Source: Github
- Resources: Investigation Guide

**Version**: 5
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating GitHub Actions Workflow Modification Blocked

This rule detects attempts to push workflow files to a GitHub repository from within a GitHub Actions workflow that are blocked by GitHub's security controls. This is a key indicator of supply chain attacks where malicious code attempts to establish persistence by injecting backdoor workflows.

### Possible investigation steps

- Review the `github.repo` field to identify which repository was targeted.
- Examine the `github.actor_id` to determine if the action was triggered by a bot (`github-actions[bot]`) or a user account (PAT-based).
- Check recent workflow runs in the repository for suspicious activity, especially in jobs that run `npm install` or other package manager commands.
- Review the repository's dependencies for recently added or updated packages that may contain malicious preinstall/postinstall hooks.
- Examine the `github.reasons.message` field for details on which workflow file was being created or modified.
- Search for other repositories in the organization that may have the same malicious dependency.
- Review GitHub audit logs for successful workflow file modifications that may have occurred before protections were enabled.


### False positive analysis

- Legitimate automation tools that manage workflow files may trigger this alert. Verify if the repository uses tools like Dependabot, Renovate, or custom automation that modifies workflows.
- CI/CD pipelines that intentionally update workflow files should use a PAT with the 'workflows' scope and be documented.


### Response and remediation

- If this is a confirmed attack attempt, immediately audit all dependencies in the affected repository.
- Remove any suspicious packages and regenerate lock files.
- Rotate any secrets that may have been exposed during the CI run.
- Review and revoke any PATs that may have been compromised.
- Enable branch protection rules requiring pull request reviews for workflow file changes.
- Consider implementing CODEOWNERS for `.github/workflows/` directory.
- Search for indicators of compromise such as unexpected workflow files (e.g., `discussion_*.yaml`, `formatter_*.yml`).


## Rule Query

```esql
from logs-github.audit-* metadata _id, _index, _version
| where
    data_stream.dataset == "github.audit" and
    event.action == "protected_branch.rejected_ref_update" and
    github.category == "protected_branch" and
    github.reasons.code == "workflow_updates" and
    match(github.reasons.message::STRING, "refusing to allow a GitHub App to create or update workflow")
| keep *
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Initial Access
- Id: TA0001
- Reference URL: [[https://attack.mitre.org/tactics/TA0001/](https://attack.mitre.org/tactics/TA0001/)](https://attack.mitre.org/tactics/TA0001/)
- Technique:
  - Name: Supply Chain Compromise
- Id: T1195
- Reference URL: [[https://attack.mitre.org/techniques/T1195/](https://attack.mitre.org/techniques/T1195/)](https://attack.mitre.org/techniques/T1195/)
- Sub Technique:
  - Name: Compromise Software Supply Chain
- Id: T1195.002
- Reference URL: [[https://attack.mitre.org/techniques/T1195/002/](https://attack.mitre.org/techniques/T1195/002/)](https://attack.mitre.org/techniques/T1195/002/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Event Triggered Execution
- Id: T1546
- Reference URL: [[https://attack.mitre.org/techniques/T1546/](https://attack.mitre.org/techniques/T1546/)](https://attack.mitre.org/techniques/T1546/)