﻿---
title: GitHub Actions Unusual Bot Push to Repository
description: Detects when the github-actions[bot] pushes code to a repository where it has not performed this behavior before in a certain time window. This may indicate...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/github/initial_access_github_actions_bot_first_push_to_repo
products:
  - Elastic Security
---

# GitHub Actions Unusual Bot Push to Repository
Detects when the github-actions[bot] pushes code to a repository where it has not performed this behavior before in a certain time window. This may
indicate a supply chain attack where malicious code running in a CI workflow attempts to modify repository contents,
such as injecting backdoor workflow files.
**Rule type**: new_terms
**Rule indices**:
- logs-github.audit-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.wiz.io/blog/shai-hulud-2-0-ongoing-supply-chain-attack](https://www.wiz.io/blog/shai-hulud-2-0-ongoing-supply-chain-attack)](https://www.wiz.io/blog/shai-hulud-2-0-ongoing-supply-chain-attack)
- [[https://www.elastic.co/blog/shai-hulud-worm-npm-supply-chain-compromise](https://www.elastic.co/blog/shai-hulud-worm-npm-supply-chain-compromise)](https://www.elastic.co/blog/shai-hulud-worm-npm-supply-chain-compromise)

**Tags**:
- Domain: Cloud
- Use Case: Threat Detection
- Tactic: Initial Access
- Tactic: Persistence
- Data Source: Github
- Resources: Investigation Guide

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating GitHub Actions Unusual Bot Push to Repository

This rule detects when the GitHub Actions bot pushes to a repository where it hasn't pushed to in a certain time interval. While this can be
legitimate automation, it may also indicate a supply chain attack where malicious code executes during CI and attempts
to modify repository contents.

### Possible investigation steps

- Review the `github.repo` field to identify the affected repository.
- Check recent workflow runs in the repository to identify which workflow triggered the push.
- Examine the repository's commit history to see what files were modified by the bot push.
- Look for newly added or modified files in `.github/workflows/` directory.
- Review the repository's dependencies for recently added or updated packages with preinstall/postinstall hooks.
- Check if the repository has legitimate automation that would explain bot pushes (Dependabot, Renovate, release automation).
- Correlate with `protected_branch.rejected_ref_update` events to see if workflow injection was blocked.
- Search for other repositories in the organization with similar suspicious activity.


### False positive analysis

- Repositories with auto-commit workflows (formatting, changelog generation, version bumps) will trigger on first run.
- Dependabot or Renovate auto-merge configurations cause legitimate bot pushes.
- GitHub Pages deployment workflows may push to gh-pages branches.
- Release automation that updates version files or generates artifacts.


### Response and remediation

- If the push is unexpected, immediately review the commit contents for malicious files.
- Check for suspicious workflow files (e.g., `discussion_*.yaml`, `formatter_*.yml`).
- Audit all dependencies in the affected repository for malicious packages.
- Rotate any secrets that may have been exposed during the workflow run.
- Enable branch protection rules to require PR reviews for all changes.
- Consider restricting GITHUB_TOKEN permissions in workflow files using `permissions:` key.


## Rule Query

```kuery
event.dataset: "github.audit" and
    event.action: "git.push" and
    user.name: "github-actions[bot]"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Initial Access
- Id: TA0001
- Reference URL: [[https://attack.mitre.org/tactics/TA0001/](https://attack.mitre.org/tactics/TA0001/)](https://attack.mitre.org/tactics/TA0001/)
- Technique:
  - Name: Supply Chain Compromise
- Id: T1195
- Reference URL: [[https://attack.mitre.org/techniques/T1195/](https://attack.mitre.org/techniques/T1195/)](https://attack.mitre.org/techniques/T1195/)
- Sub Technique:
  - Name: Compromise Software Supply Chain
- Id: T1195.002
- Reference URL: [[https://attack.mitre.org/techniques/T1195/002/](https://attack.mitre.org/techniques/T1195/002/)](https://attack.mitre.org/techniques/T1195/002/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)