﻿---
title: GitHub Repository Deleted
description: This rule detects when a GitHub repository is deleted within your organization. Repositories are a critical component used within an organization to manage...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/github/impact_github_repository_deleted
products:
  - Elastic Security
---

# GitHub Repository Deleted
This rule detects when a GitHub repository is deleted within your organization. Repositories are a critical component
used within an organization to manage work, collaborate with others and release products to the public. Any delete
action against a repository should be investigated to determine it's validity. Unauthorized deletion of organization
repositories could cause irreversible loss of intellectual property and indicate compromise within your organization.
**Rule type**: eql
**Rule indices**:
- logs-github.audit-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Cloud
- Use Case: Threat Detection
- Use Case: UEBA
- Tactic: Impact
- Data Source: Github
- Resources: Investigation Guide

**Version**: 206
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating GitHub Repository Deleted

GitHub repositories are essential for managing code and collaboration within organizations. Adversaries may exploit this by deleting repositories to disrupt operations or erase critical data, potentially indicating a security breach. The detection rule monitors GitHub audit logs for repository deletion events, enabling analysts to swiftly identify and investigate unauthorized actions, thereby mitigating potential data loss and compromise.

### Possible investigation steps

- Review the GitHub audit logs to confirm the repository deletion event by checking for entries where event.module is "github", event.dataset is "github.audit", and event.action is "repo.destroy".
- Identify the user account associated with the deletion event and verify their access permissions and recent activity to determine if the action was authorized.
- Contact the user or team responsible for the repository to confirm whether the deletion was intentional and documented.
- Check for any recent changes in user access or permissions that could indicate a compromised account or unauthorized access.
- Investigate any other suspicious activities or alerts related to the same user or repository around the time of the deletion event to identify potential patterns of malicious behavior.
- Assess the impact of the repository deletion on ongoing projects and data availability, and initiate recovery procedures if necessary.


### False positive analysis

- Routine repository clean-up activities by authorized personnel may trigger alerts. To manage this, maintain a list of users or teams responsible for such tasks and create exceptions for their actions.
- Automated scripts or tools used for repository management might delete repositories as part of their normal operation. Identify these scripts and exclude their actions from triggering alerts by using specific identifiers or tags.
- Test or temporary repositories that are frequently created and deleted during development cycles can cause false positives. Implement naming conventions for these repositories and configure the rule to ignore deletions matching these patterns.
- Scheduled repository deletions as part of a lifecycle management policy can be mistaken for unauthorized actions. Document these schedules and adjust the detection rule to accommodate these planned activities.


### Response and remediation

- Immediately revoke access for any user account associated with the unauthorized repository deletion to prevent further malicious actions.
- Restore the deleted repository from backups or snapshots, if available, to recover lost data and minimize operational disruption.
- Conduct a thorough review of recent access logs and user activities to identify any other suspicious actions or potential indicators of compromise.
- Notify the security team and relevant stakeholders about the incident to ensure coordinated response efforts and awareness.
- Implement additional access controls, such as multi-factor authentication and role-based access, to prevent unauthorized deletions in the future.
- Escalate the incident to higher management and legal teams if intellectual property theft or significant data loss is suspected.
- Enhance monitoring and alerting mechanisms to detect similar unauthorized actions promptly, leveraging the MITRE ATT&CK framework for guidance on potential threat vectors.


## Rule Query

```eql
configuration where event.module == "github" and event.dataset == "github.audit" and event.action == "repo.destroy"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Impact
- Id: TA0040
- Reference URL: [[https://attack.mitre.org/tactics/TA0040/](https://attack.mitre.org/tactics/TA0040/)](https://attack.mitre.org/tactics/TA0040/)
- Technique:
  - Name: Data Destruction
- Id: T1485
- Reference URL: [[https://attack.mitre.org/techniques/T1485/](https://attack.mitre.org/techniques/T1485/)](https://attack.mitre.org/techniques/T1485/)