﻿---
title: Github Activity on a Private Repository from an Unusual IP
description: Detects when there is activity on a private GitHub repository from an unusual IP address. Adversaries may access private repositories from unfamiliar...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/github/impact_github_repository_activity_from_unusual_ip
products:
  - Elastic Security
---

# Github Activity on a Private Repository from an Unusual IP
Detects when there is activity on a private GitHub repository from an unusual IP address. Adversaries may
access private repositories from unfamiliar IPs to exfiltrate sensitive code or data, potentially indicating
a compromise or unauthorized access.
**Rule type**: new_terms
**Rule indices**:
- logs-github.audit-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.wiz.io/blog/shai-hulud-2-0-ongoing-supply-chain-attack](https://www.wiz.io/blog/shai-hulud-2-0-ongoing-supply-chain-attack)](https://www.wiz.io/blog/shai-hulud-2-0-ongoing-supply-chain-attack)
- [[https://trigger.dev/blog/shai-hulud-postmortem](https://trigger.dev/blog/shai-hulud-postmortem)](https://trigger.dev/blog/shai-hulud-postmortem)
- [[https://posthog.com/blog/nov-24-shai-hulud-attack-post-mortem](https://posthog.com/blog/nov-24-shai-hulud-attack-post-mortem)](https://posthog.com/blog/nov-24-shai-hulud-attack-post-mortem)

**Tags**:
- Domain: Cloud
- Use Case: Threat Detection
- Tactic: Impact
- Tactic: Initial Access
- Tactic: Persistence
- Data Source: Github
- Resources: Investigation Guide

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```kuery
event.dataset:"github.audit" and event.action:("git.push" or "git.clone") and github.repository_public:false
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Impact
- Id: TA0040
- Reference URL: [[https://attack.mitre.org/tactics/TA0040/](https://attack.mitre.org/tactics/TA0040/)](https://attack.mitre.org/tactics/TA0040/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Initial Access
- Id: TA0001
- Reference URL: [[https://attack.mitre.org/tactics/TA0001/](https://attack.mitre.org/tactics/TA0001/)](https://attack.mitre.org/tactics/TA0001/)
- Technique:
  - Name: Supply Chain Compromise
- Id: T1195
- Reference URL: [[https://attack.mitre.org/techniques/T1195/](https://attack.mitre.org/techniques/T1195/)](https://attack.mitre.org/techniques/T1195/)
- Sub Technique:
  - Name: Compromise Software Supply Chain
- Id: T1195.002
- Reference URL: [[https://attack.mitre.org/techniques/T1195/002/](https://attack.mitre.org/techniques/T1195/002/)](https://attack.mitre.org/techniques/T1195/002/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)