﻿---
title: GitHub Secret Scanning Disabled
description: Detects when GitHub Secret Scanning is disabled for a repository. Adversaries may disable secret scanning to evade detection of hardcoded secrets, such...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/github/defense_evasion_secret_scanning_disabled
products:
  - Elastic Security
---

# GitHub Secret Scanning Disabled
Detects when GitHub Secret Scanning is disabled for a repository. Adversaries may disable secret scanning to
evade detection of hardcoded secrets, such as API keys or credentials, that could be used for further
compromise or data exfiltration.
**Rule type**: eql
**Rule indices**:
- logs-github.audit-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.wiz.io/blog/shai-hulud-2-0-ongoing-supply-chain-attack](https://www.wiz.io/blog/shai-hulud-2-0-ongoing-supply-chain-attack)](https://www.wiz.io/blog/shai-hulud-2-0-ongoing-supply-chain-attack)
- [[https://trigger.dev/blog/shai-hulud-postmortem](https://trigger.dev/blog/shai-hulud-postmortem)](https://trigger.dev/blog/shai-hulud-postmortem)
- [[https://posthog.com/blog/nov-24-shai-hulud-attack-post-mortem](https://posthog.com/blog/nov-24-shai-hulud-attack-post-mortem)](https://posthog.com/blog/nov-24-shai-hulud-attack-post-mortem)

**Tags**:
- Domain: Cloud
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Data Source: Github
- Resources: Investigation Guide

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating GitHub Secret Scanning Disabled

This rule triggers when secret scanning is disabled on a repository, signaling an attempt to hide exposed tokens, keys, or passwords that can enable lateral movement, persistence, and data exfiltration. An attacker who gains admin or bot access may disable scanning, push a commit embedding plaintext credentials, and modify a workflow to export them via CI jobs, then use those secrets to authenticate to external services or cloud accounts and expand control.

### Possible investigation steps

- Identify the actor (user, bot, or GitHub App), their auth method and source IP, confirm admin privileges, and validate whether the change was planned and approved.
- Immediately re-enable Secret Scanning and Push Protection on the repository and, if possible, enforce them via an organization policy, recording change control and justification.
- Review commits, pull requests, and workflow file changes near the disable timestamp to detect added plaintext credentials, secret files, or code paths that read or export secrets.
- Examine recent GitHub Actions runs, artifacts, and logs for secrets printed, unusual network egress, or jobs using elevated token scopes, and check for newly added or modified repo/org secrets.
- Correlate IdP, cloud, and third-party service logs for authentication or API activity shortly after the disable event, revoking and rotating any credentials suspected to be exposed.


### False positive analysis

- A repository admin temporarily disables Secret Scanning during a planned maintenance or configuration test to address noisy detections or performance issues, then re-enables it, generating a benign disable event.
- Organization-managed templates or automation enforce a settings baseline that disables Secret Scanning for non-code or ephemeral repos (e.g., mirrors, docs, or test sandboxes), causing the event as part of expected governance.


### Response and remediation

- Immediately re-enable Secret Scanning and Push Protection on the affected repository, lock the default branch with "Require pull request reviews" and "Restrict who can push," and temporarily pause GitHub Actions workflows that access repo or org secrets.
- Revert or rewrite commits made while scanning was disabled to remove credentials from files like .env, config.yml, and .github/workflows/*.yml, and delete build artifacts and caches that may contain sensitive values.
- Revoke and rotate exposed credentials by disabling compromised PATs, rotating cloud API keys and service tokens, and updating organization and repository secrets in Settings > Secrets and variables.
- Validate recovery by confirming Secret Scanning and Push Protection are enabled in repository settings, re-running a full secret scan across HEAD, tags, and protected branches, and restoring merges and deployments only after clean results.
- Escalate to incident response if the actor is unknown or unauthorized, if plaintext secrets appear in commits or workflow logs, or if external authentications use repo-linked credentials within 24 hours of the disable event.
- Harden by enforcing org-wide policies requiring Secret Scanning and Push Protection for all repositories, adding repository rulesets to require status checks and pull request reviews before merging, and limiting Actions token permissions with protected environments and branch protections.


## Rule Query

```eql
configuration where event.dataset == "github.audit" and event.type == "change" and event.action == "repository_secret_scanning.disable"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Impair Defenses
- Id: T1562
- Reference URL: [[https://attack.mitre.org/techniques/T1562/](https://attack.mitre.org/techniques/T1562/)](https://attack.mitre.org/techniques/T1562/)
- Sub Technique:
  - Name: Disable or Modify Tools
- Id: T1562.001
- Reference URL: [[https://attack.mitre.org/techniques/T1562/001/](https://attack.mitre.org/techniques/T1562/001/)](https://attack.mitre.org/techniques/T1562/001/)