﻿---
title: Unusual City For a GCP Event
description: A machine learning job detected GCP Audit event activity that, while not inherently suspicious or abnormal, is sourcing from a geolocation (city) that...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/gcp/ml_gcp_rare_method_by_city
products:
  - Elastic Security
---

# Unusual City For a GCP Event
A machine learning job detected GCP Audit event activity that, while not inherently suspicious or abnormal, is sourcing from
a geolocation (city) that is unusual for the event action. This can be the result of compromised credentials or keys being
used by a threat actor in a different geography than the authorized user(s).
**Rule type**: machine_learning
**Rule indices**:
**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 15m
**Searches indices from**: `now-2h`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.elastic.co/guide/en/security/current/prebuilt-ml-jobs.html](https://www.elastic.co/guide/en/security/current/prebuilt-ml-jobs.html)](https://www.elastic.co/guide/en/security/current/prebuilt-ml-jobs.html)

**Tags**:
- Domain: Cloud
- Data Source: GCP
- Data Source: GCP Audit Logs
- Data Source: Google Cloud Platform
- Rule Type: ML
- Rule Type: Machine Learning
- Resources: Investigation Guide

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires the installation of associated Machine Learning jobs, as well as data coming in from GCP.

### Anomaly Detection Setup

Once the rule is enabled, the associated Machine Learning job will start automatically. You can view the Machine Learning job linked under the "Definition" panel of the detection rule. If the job does not start due to an error, the issue must be resolved for the job to commence successfully. For more details on setting up anomaly detection jobs, refer to the [helper guide](https://www.elastic.co/guide/en/kibana/current/xpack-ml-anomalies.html).

### GCP Audit logs Integration Setup

The Google Cloud Platform (GCP) Audit logs integration allows you to collect logs and metrics from Google Cloud Platform (GCP) with Elastic Agent.

#### The following steps should be executed in order to add the Elastic Agent System "Google Cloud Platform (GCP) Audit logs" integration to your system:

- Go to the Kibana home page and click “Add integrations”.
- In the query bar, search for “Google Cloud Platform (GCP) Audit logs” and select the integration to see more details about it.
- Click “Add Google Cloud Platform (GCP) Audit logs".
- Configure the integration.
- Click “Save and Continue”.
- For more details on the integration refer to the [helper guide](https://www.elastic.co/docs/current/integrations/gcp).

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Initial Access
- Id: TA0001
- Reference URL: [[https://attack.mitre.org/tactics/TA0001/](https://attack.mitre.org/tactics/TA0001/)](https://attack.mitre.org/tactics/TA0001/)
- Technique:
  - Name: Valid Accounts
- Id: T1078
- Reference URL: [[https://attack.mitre.org/techniques/T1078/](https://attack.mitre.org/techniques/T1078/)](https://attack.mitre.org/techniques/T1078/)
- Sub Technique:
  - Name: Cloud Accounts
- Id: T1078.004
- Reference URL: [[https://attack.mitre.org/techniques/T1078/004/](https://attack.mitre.org/techniques/T1078/004/)](https://attack.mitre.org/techniques/T1078/004/)