﻿---
title: Endpoint Security (Elastic Defend)
description: Generates a detection alert each time an Elastic Defend alert is received. Enabling this rule allows you to immediately begin investigating your Endpoint...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/endpoint/elastic_endpoint_security
products:
  - Elastic Security
---

# Endpoint Security (Elastic Defend)
Generates a detection alert each time an Elastic Defend alert is received. Enabling this rule allows you to immediately
begin investigating your Endpoint alerts.
**Rule type**: query
**Rule indices**:
- logs-endpoint.alerts-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 1m
**Searches indices from**: `now-2m`
**Maximum alerts per execution**: 1000
**References**:
**Tags**:
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 108
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup


### Elastic Defend Alerts

If this rule is disabled, you will not receive alerts for Elastic Defend alerts. This rule is designed to capture all alerts generated by Elastic Defend. For more granular alerting, consider using additional prebuilt-rules that capture specific Elastic Defend alerts.
If this rule is enabled, along with the related rules listed below, you will receive duplicate alerts for the same events. To avoid this, it is recommended to disable this generic rule and enable the more specific rules that capture these alerts separately.
Related rules:
- Behavior - Detected - Elastic Defend (UUID: 0f615fe4-eaa2-11ee-ae33-f661ea17fbce)
- Behavior - Prevented - Elastic Defend (UUID: eb804972-ea34-11ee-a417-f661ea17fbce)
- Malicious File - Detected - Elastic Defend (UUID: f2c3caa6-ea34-11ee-a417-f661ea17fbce)
- Malicious File - Prevented - Elastic Defend (UUID: f87e6122-ea34-11ee-a417-f661ea17fbce)
- Memory Threat - Detected - Elastic Defend (UUID: 017de1e4-ea35-11ee-a417-f661ea17fbce)
- Memory Threat - Prevented - Elastic Defend (UUID: 06f3a26c-ea35-11ee-a417-f661ea17fbce)
- Ransomware - Detected - Elastic Defend (UUID: 0c74cd7e-ea35-11ee-a417-f661ea17fbce)
- Ransomware - Prevented - Elastic Defend (UUID: 10f3d520-ea35-11ee-a417-f661ea17fbce)


### Additional notes

For information on troubleshooting the maximum alerts warning please refer to this [guide](https://www.elastic.co/guide/en/security/current/alerts-ui-monitor.html#troubleshoot-max-alerts).

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Endpoint Security (Elastic Defend)

Elastic Defend is a robust endpoint security solution that monitors and protects systems by analyzing events and generating alerts for suspicious activities. Adversaries may exploit endpoints by executing unauthorized code or manipulating system processes. The detection rule leverages event data to identify alerts from Elastic Defend, focusing on potential threats while excluding non-relevant modules, thus enabling timely investigation of endpoint anomalies.

### Possible investigation steps

- Review the alert details to understand the specific event.kind:alert and event.module: endpoint that triggered the alert, ensuring it is not related to the excluded endgame module.
- Examine the timeline of events leading up to the alert to identify any unusual or unauthorized activities, such as unexpected process executions or system changes.
- Correlate the alert with other security events or logs from the same endpoint to gather additional context and determine if there is a pattern of suspicious behavior.
- Investigate the source and destination of any network connections associated with the alert to identify potential command and control activity or data exfiltration attempts.
- Check for any recent changes or updates to the endpoint's software or configuration that could explain the alert, ensuring they are legitimate and authorized.
- Assess the risk score and severity of the alert in conjunction with other alerts from the same endpoint to prioritize the investigation and response efforts.


### False positive analysis

- Alerts triggered by routine software updates can be false positives. Users can create exceptions for known update processes to prevent unnecessary alerts.
- System maintenance activities, such as scheduled scans or backups, may generate alerts. Exclude these activities by identifying their specific event signatures and adding them to the exception list.
- Legitimate administrative actions, like remote desktop sessions or script executions by IT staff, might be flagged. Define exceptions for these actions by correlating them with authorized user accounts or IP addresses.
- Frequent alerts from non-malicious applications that interact with system processes can be excluded by whitelisting these applications based on their hash or path.
- Network monitoring tools that simulate attack patterns for testing purposes may trigger alerts. Exclude these tools by specifying their known behaviors and IP ranges in the exception settings.


### Response and remediation

- Isolate the affected endpoint immediately to prevent further unauthorized access or lateral movement within the network.
- Analyze the alert details to identify the specific unauthorized code or process manipulation involved, and terminate any malicious processes identified.
- Remove any unauthorized code or files from the affected endpoint, ensuring that all traces of the threat are eradicated.
- Conduct a thorough review of system logs and event data to identify any additional indicators of compromise or related suspicious activities.
- Update endpoint security configurations and signatures to prevent similar threats from exploiting the same vulnerabilities in the future.
- Restore the affected endpoint from a known good backup if necessary, ensuring that the system is free from any residual threats.
- Escalate the incident to the security operations center (SOC) or relevant team for further analysis and to determine if additional systems may be affected.


## Rule Query

```kuery
event.kind:alert and event.module:(endpoint and not endgame)
```