﻿---
title: Machine Learning Detected a DNS Request Predicted to be a DGA Domain
description: A supervised machine learning model has identified a DNS question name that is predicted to be the result of a Domain Generation Algorithm (DGA), which...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/dga/command_and_control_ml_dns_request_predicted_to_be_a_dga_domain
products:
  - Elastic Security
---

# Machine Learning Detected a DNS Request Predicted to be a DGA Domain
A supervised machine learning model has identified a DNS question name that is predicted to be the result of a Domain
Generation Algorithm (DGA), which could indicate command and control network activity.
**Rule type**: query
**Rule indices**:
- logs-endpoint.events.*
- logs-network_traffic.*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-10m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.elastic.co/guide/en/security/current/prebuilt-ml-jobs.html](https://www.elastic.co/guide/en/security/current/prebuilt-ml-jobs.html)](https://www.elastic.co/guide/en/security/current/prebuilt-ml-jobs.html)
- [[https://docs.elastic.co/en/integrations/dga](https://docs.elastic.co/en/integrations/dga)](https://docs.elastic.co/en/integrations/dga)
- [[https://www.elastic.co/security-labs/detect-domain-generation-algorithm-activity-with-new-kibana-integration](https://www.elastic.co/security-labs/detect-domain-generation-algorithm-activity-with-new-kibana-integration)](https://www.elastic.co/security-labs/detect-domain-generation-algorithm-activity-with-new-kibana-integration)

**Tags**:
- Domain: Network
- Domain: Endpoint
- Data Source: Elastic Defend
- Use Case: Domain Generation Algorithm Detection
- Rule Type: ML
- Rule Type: Machine Learning
- Tactic: Command and Control
- Resources: Investigation Guide

**Version**: 8
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

The rule requires the Domain Generation Algorithm (DGA) Detection integration assets to be installed, as well as DNS events collected by integrations such as Elastic Defend, Network Packet Capture, or Packetbeat.

### DGA Detection Setup

The DGA Detection integration consists of an ML-based framework to detect DGA activity in DNS events.

#### Prerequisite Requirements:

- Fleet is required for DGA Detection.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).
- DNS events collected by the [Elastic Defend](https://docs.elastic.co/en/integrations/endpoint), [Network Packet Capture](https://docs.elastic.co/integrations/network_traffic) integration, or [Packetbeat](https://www.elastic.co/guide/en/beats/packetbeat/current/packetbeat-overview.html).
- To install Elastic Defend, refer to the [documentation](https://www.elastic.co/guide/en/security/current/install-endpoint.html).
- To add the Network Packet Capture integration to an Elastic Agent policy, refer to [this](https://www.elastic.co/guide/en/fleet/current/add-integration-to-policy.html) guide.
- To set up and run Packetbeat, follow [this](https://www.elastic.co/guide/en/beats/packetbeat/current/setting-up-and-running.html) guide.


#### The following steps should be executed to install assets associated with the DGA Detection integration:

- Go to the Kibana homepage. Under Management, click Integrations.
- In the query bar, search for Domain Generation Algorithm Detection and select the integration to see more details about it.
- Follow the instructions under the **Installation** section.
- For this rule to work, complete the instructions through **Configure the ingest pipeline**.


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Machine Learning Detected a DNS Request Predicted to be a DGA Domain

Machine learning models can identify patterns in DNS requests that suggest the use of Domain Generation Algorithms (DGAs), which adversaries use to dynamically generate domain names for command and control (C2) communication. This detection rule leverages such models to flag DNS queries likely generated by DGAs, excluding known benign domains, thus helping to identify potential C2 activity.

### Possible investigation steps

- Review the DNS query logs to identify the specific domain flagged by the machine learning model as a potential DGA domain. Focus on the field ml_is_dga.malicious_prediction:1 to confirm the prediction.
- Cross-reference the flagged domain with threat intelligence sources to determine if it is associated with known malicious activity or threat actors.
- Investigate the source IP address of the DNS request to identify the device or user responsible for the query. This can help determine if the activity is isolated or part of a larger pattern.
- Analyze network traffic logs for any additional suspicious activity originating from the same source IP, such as unusual outbound connections or data transfers.
- Check for any recent changes or anomalies in the endpoint's behavior or configuration that could indicate compromise or unauthorized software installation.
- If the domain is confirmed to be malicious, initiate containment procedures to block further communication with the domain and prevent potential data exfiltration or further compromise.


### False positive analysis

- DNS requests to content delivery networks or cloud service providers can be flagged as DGA domains due to their dynamic nature. Users should review these domains and consider adding them to an exception list if they are verified as legitimate.
- Internal applications that generate dynamic DNS requests for load balancing or failover purposes might trigger false positives. Identify these applications and exclude their domains from the rule to prevent unnecessary alerts.
- Automated testing environments often generate numerous DNS requests that can appear suspicious. Regularly update the exception list with domains used by these environments to minimize false alerts.
- Frequent updates or patches from software vendors may involve dynamic DNS requests. Verify these domains and exclude them if they are confirmed to be part of legitimate update processes.
- Consider monitoring the frequency and pattern of flagged DNS requests. If a domain is consistently flagged but verified as non-threatening, it may be a candidate for exclusion from the rule.


### Response and remediation

- Isolate the affected system from the network to prevent further potential command and control communication.
- Conduct a thorough scan of the isolated system using updated antivirus and anti-malware tools to identify and remove any malicious software.
- Review and block the identified DGA domain and any associated IP addresses at the network perimeter to prevent further access.
- Analyze network traffic logs to identify any other systems that may have communicated with the DGA domain and apply similar containment measures.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine the scope of the compromise.
- Implement enhanced monitoring for similar DGA patterns and update detection capabilities to quickly identify future occurrences.
- Review and update firewall and intrusion detection/prevention system (IDS/IPS) rules to block known DGA patterns and suspicious DNS activity.


## Rule Query

```kuery
ml_is_dga.malicious_prediction:1 and not dns.question.registered_domain:avsvmcloud.com
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Command and Control
- Id: TA0011
- Reference URL: [[https://attack.mitre.org/tactics/TA0011/](https://attack.mitre.org/tactics/TA0011/)](https://attack.mitre.org/tactics/TA0011/)
- Technique:
  - Name: Dynamic Resolution
- Id: T1568
- Reference URL: [[https://attack.mitre.org/techniques/T1568/](https://attack.mitre.org/techniques/T1568/)](https://attack.mitre.org/techniques/T1568/)
- Sub Technique:
  - Name: Domain Generation Algorithms
- Id: T1568.002
- Reference URL: [[https://attack.mitre.org/techniques/T1568/002/](https://attack.mitre.org/techniques/T1568/002/)](https://attack.mitre.org/techniques/T1568/002/)