﻿---
title: CyberArk Privileged Access Security Error
description: Identifies the occurrence of a CyberArk Privileged Access Security (PAS) error level audit event. The event.code correlates to the CyberArk Vault Audit...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cyberarkpas/privilege_escalation_cyberarkpas_error_audit_event_promotion
products:
  - Elastic Security
---

# CyberArk Privileged Access Security Error
Identifies the occurrence of a CyberArk Privileged Access Security (PAS) error level audit event. The event.code
correlates to the CyberArk Vault Audit Action Code.
**Rule type**: query
**Rule indices**:
- filebeat-*
- logs-cyberarkpas.audit*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-30m`
**Maximum alerts per execution**: 100
**References**:
- [[https://docs.cyberark.com/Product-Doc/OnlineHelp/PAS/Latest/en/Content/PASREF/Vault%20Audit%20Action%20Codes.htm?tocpath=Administration%7CReferences%7C_____3](https://docs.cyberark.com/Product-Doc/OnlineHelp/PAS/Latest/en/Content/PASREF/Vault%20Audit%20Action%20Codes.htm?tocpath=Administration%7CReferences%7C_____3)](https://docs.cyberark.com/Product-Doc/OnlineHelp/PAS/Latest/en/Content/PASREF/Vault%20Audit%20Action%20Codes.htm?tocpath=Administration%7CReferences%7C_____3)

**Tags**:
- Data Source: CyberArk PAS
- Use Case: Log Auditing
- Use Case: Threat Detection
- Tactic: Privilege Escalation
- Resources: Investigation Guide

**Version**: 105
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Setup

The CyberArk Privileged Access Security (PAS) Fleet integration, Filebeat module, or similarly structured data is required to be compatible with this rule.

## Triage and analysis

This is a promotion rule for CyberArk error events, which are alertable events per the vendor.
Consult vendor documentation on interpreting specific events.

## Rule Query

```kuery
event.dataset:cyberarkpas.audit and event.type:error
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Valid Accounts
- Id: T1078
- Reference URL: [[https://attack.mitre.org/techniques/T1078/](https://attack.mitre.org/techniques/T1078/)](https://attack.mitre.org/techniques/T1078/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Initial Access
- Id: TA0001
- Reference URL: [[https://attack.mitre.org/tactics/TA0001/](https://attack.mitre.org/tactics/TA0001/)](https://attack.mitre.org/tactics/TA0001/)