﻿---
title: Suspicious Interpreter Execution Detected via Defend for Containers
description: This rule detects when an interactive process executes a suspicious interpreter command inside a container. These commands are commonly used by attackers...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/execution_suspicious_interactive_interpreter_command_execution
products:
  - Elastic Security
---

# Suspicious Interpreter Execution Detected via Defend for Containers
This rule detects when an interactive process executes a suspicious interpreter command inside a container.
These commands are commonly used by attackers to execute malicious code or exfiltrate data.
**Rule type**: eql
**Rule indices**:
- logs-cloud_defend.process*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 5m
**Searches indices from**: `now-6m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Data Source: Elastic Defend for Containers
- Domain: Container
- OS: Linux
- Use Case: Threat Detection
- Tactic: Execution
- Tactic: Command and Control
- Resources: Investigation Guide

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Suspicious Interpreter Execution Detected via Defend for Containers

This detection flags an interactive session inside a Linux container launching Perl, PHP, Lua, Python, or Ruby with inline code execution and high-risk functions commonly used for spawning processes, decoding payloads, or opening network connections. It matters because attackers often abuse these one-liners to run malware or exfiltrate data without dropping files, blending into normal admin shell activity. A common pattern is a `python -c` one-liner that base64-decodes a second-stage script and executes it, then initiates an outbound socket for command-and-control.

### Possible investigation steps

- Review the full inline interpreter code and decode any embedded payloads (e.g., base64/zlib/rot13) to determine its intent, IOCs, and whether it fetches or launches a second stage.
- Identify the originating interactive session and actor by correlating the container’s TTY/exec session metadata with orchestrator audit logs (e.g., Kubernetes exec/attach) to determine who/what initiated it and from where.
- Assess whether the container image, entrypoint, and recent deployment changes are expected for this workload, and check for signs of container escape attempts or host access (mounted sockets, privileged flags, hostPath mounts).
- Pivot from the alert time to related activity in the same container for child processes, file writes, cron/systemd modifications, and persistence artifacts that indicate follow-on actions beyond a one-liner.
- Check for unexpected outbound connections or DNS lookups from the container around execution time, and validate any contacted domains/IPs against threat intel and known-good service dependencies.


### False positive analysis

- A developer or SRE opens an interactive shell in the container to troubleshoot and runs a quick inline one-liner (e.g., `python -c`/`php -r`/`ruby -e`) to test network connectivity, decode/transform a string (base64/zlib), or call a subprocess for diagnostics, which matches the suspicious function patterns.
- During an interactive container exec session, an administrator performs emergency maintenance or incident response actions using an interpreter one-liner to fetch configuration/state, invoke system utilities, or validate service behavior (e.g., `socket.connect`, `os.system`, `curl_exec`, `IO.popen`), producing a benign but high-risk inline command signature.


### Response and remediation

- Quarantine the affected workload by scaling it to zero or cordoning the node and blocking egress for the namespace while preserving the pod and container filesystem for evidence capture.
- Terminate the interactive session and kill the interpreter process tree, then collect the full command line, any decoded inline payload, and any retrieved scripts or binaries from the container for malware analysis.
- Hunt and remove follow-on artifacts by searching the container for newly created executables, modified startup scripts, cron entries, webshells, or injected environment variables, and redeploy from a known-good image rather than “cleaning” the live container.
- Rotate credentials and secrets exposed to the container (service account tokens, API keys, database passwords) and invalidate active sessions if the one-liner performed network calls, decoded payloads, or spawned subprocesses.
- Escalate to the incident response team if the inline code includes base64/zlib decoding, establishes a socket connection, downloads a second stage, or any similar activity is observed across multiple pods/namespaces.
- Harden against recurrence by restricting `exec/attach` access, enforcing least-privilege pod security (no privileged, no host mounts, read-only root filesystem), and using egress allowlists plus image signing/admission controls to block unauthorized images and interactive debug containers.


## Rule Query

```eql
process where host.os.type == "linux" and event.type == "start" and event.action == "exec" and process.interactive == true and
process.parent.executable != null and (
  (
    process.executable like ("/bin/perl*", "/usr/bin/perl*", "/usr/local/bin/perl*") and
    process.args == "-e" and process.args like~ (
      "*system(*", "*exec(*", "*IO.popen(*", "*Open3.popen3(*", "*spawn(*", "*eval(*",
      "*load(*IO::*", "*load(*Marshal*", "*load(*Fiddle*", "*load(*Zlib*", "*load(*Base64*",
      "*zlib.inflate(*", "*zlib.deflate(*", "*zlib.decompress(*", "*zlib.uncompress(*", "*zlib.compress(*",
      "*Marshal.load(*", "*Fiddle.dlopen(*", "*Fiddle::Function.new(*", "*base64*", "*zlib*", 
      "*net/http*", "*socket.new*", "*open-uri*", "*pack(*"
    )
  ) or
  process.executable like ("/bin/php*", "/usr/bin/php*", "/usr/local/bin/php*") and
  process.args == "-r" and process.args like~ (
    "*exec(*", "*system(*", "*shell_exec(*", "*passthru(*", "*proc_open(*", "*pcntl_exec(*", "*popen(*", 
    "*eval(*", "*assert(*", "*create_function(*", "*preg_replace(*e*", "*include(*", "*require(*",
    "*base64_decode(*", "*gzinflate(*", "*gzuncompress(*", "*str_rot13(*", "*urldecode(*", "*chr(*", 
    "*ord(*", "*strrev(*", "*strtr(*", "*pack(*", "*unpack(*", "*curl_exec(*", "*curl_multi_exec(*",
    "*file_get_contents(*", "*fopen(*", "*fsockopen(*", "*pfsockopen(*", "*stream_socket_client(*",
    "*socket_create(*", "*socket_connect(*", "*socket_write(*", "*socket_read(*", "*mail(*",
    "*move_uploaded_file(*"
  ) or
  process.executable like ("/bin/lua*", "/usr/bin/lua*", "/usr/local/bin/lua*") and
  process.args == "-e" and process.args like~ (
    "*os.execute(*", "*io.popen(*", "*load(*", "*loadstring(*", "*require(*", "*dofile(*",
    "*package.loadlib(*", "*base64.decode(*", "*base64.encode(*", "*zlib.inflate(*",
    "*zlib.deflate(*", "*zlib.decompress(*", "*zlib.compress(*", "*socket.bind(*",
    "*socket.connect(*", "*socket.receive(*", "*socket.send(*", "*socket.tcp(*",
    "*socket.udp(*", "*socket.listen(*", "*socket.accept(*", "*net.http.request(*",
    "*net.http.get(*", "*net.http.post(*", "*http.request(*", "*http.get(*", "*http.post(*"
  ) or
  process.executable like ("/bin/python*", "/usr/bin/python*", "/usr/local/bin/python*") and
  process.args == "-c" and process.args like~ (
    "*exec(*base64*", "*exec(*decode(*", "*exec(*marshal*", "*exec(*pickle*", "*eval(*exec(*",
    "*eval(*", "*subprocess.popen(*", "*subprocess.run(*", "*pickle.loads(*", "*marshal.loads(*",
    "*binascii*", "*os.system(*", "*os.popen(*", "*pty.*", "*dup2*", "*fileno()*", "*connect(*",
    "*bind(*", "*execve(*", "*base64*", "*base32*", "*base16*", "*base85*", "*decode(*",
    "*zlib.*", "*[::-1]*", "*socket.socket(*", "*socket.connect(*", "*socket.bind(*"
  ) or
  process.executable like ("/bin/ruby*", "/usr/bin/ruby*", "/usr/local/bin/ruby*") and
  process.args like "-e*" and process.args like~ (
    "*system(*", "*exec(*", "*IO.popen(*", "*Open3.popen3(*", "*spawn(*", "*eval(*", "*load(*",
    "*Marshal.load(*", "*Fiddle.dlopen(*", "*Fiddle::Function.new(*", "*base64*", "*zlib*", 
    "*net/http*", "*socket*", "*open-uri*", "*pack(*", "*unpack(*"
  )
) and container.id like "?*"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)
- Sub Technique:
  - Name: Unix Shell
- Id: T1059.004
- Reference URL: [[https://attack.mitre.org/techniques/T1059/004/](https://attack.mitre.org/techniques/T1059/004/)](https://attack.mitre.org/techniques/T1059/004/)
- Sub Technique:
  - Name: Python
- Id: T1059.006
- Reference URL: [[https://attack.mitre.org/techniques/T1059/006/](https://attack.mitre.org/techniques/T1059/006/)](https://attack.mitre.org/techniques/T1059/006/)
- Sub Technique:
  - Name: Lua
- Id: T1059.011
- Reference URL: [[https://attack.mitre.org/techniques/T1059/011/](https://attack.mitre.org/techniques/T1059/011/)](https://attack.mitre.org/techniques/T1059/011/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Command and Control
- Id: TA0011
- Reference URL: [[https://attack.mitre.org/tactics/TA0011/](https://attack.mitre.org/tactics/TA0011/)](https://attack.mitre.org/tactics/TA0011/)
- Technique:
  - Name: Application Layer Protocol
- Id: T1071
- Reference URL: [[https://attack.mitre.org/techniques/T1071/](https://attack.mitre.org/techniques/T1071/)](https://attack.mitre.org/techniques/T1071/)
- Sub Technique:
  - Name: Web Protocols
- Id: T1071.001
- Reference URL: [[https://attack.mitre.org/techniques/T1071/001/](https://attack.mitre.org/techniques/T1071/001/)](https://attack.mitre.org/techniques/T1071/001/)