﻿---
title: File Execution Permission Modification Detected via Defend for Containers
description: This rule detects when chmod is used to add the execute permission to a file inside a container. Modifying file permissions to make a file executable...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/execution_suspicious_file_made_executable_via_chmod_inside_a_container
products:
  - Elastic Security
---

# File Execution Permission Modification Detected via Defend for Containers
This rule detects when chmod is used to add the execute permission to a file inside a container. Modifying file
permissions to make a file executable could indicate malicious activity, as an attacker may attempt to run unauthorized
or malicious code inside the container.
**Rule type**: eql
**Rule indices**:
- logs-cloud_defend.file*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 5m
**Searches indices from**: `now-6m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Data Source: Elastic Defend for Containers
- Domain: Container
- OS: Linux
- Use Case: Threat Detection
- Tactic: Execution
- Tactic: Defense Evasion
- Resources: Investigation Guide

**Version**: 104
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Setup


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating File Execution Permission Modification Detected via Defend for Containers

Containers provide isolated environments for running applications, often on Linux systems. The `chmod` command is used to change file permissions, including making files executable. Adversaries may exploit this by altering permissions to execute unauthorized scripts or binaries, potentially leading to malicious activity. The detection rule identifies such actions by monitoring for `chmod` usage that grants execute permissions, focusing on specific permission patterns, and excluding benign cases. This helps in identifying potential threats where attackers attempt to execute unauthorized code within containers.

### Possible investigation steps

- Review the container ID associated with the alert to identify the specific container where the `chmod` command was executed.
- Examine the process arguments to determine the exact permissions that were set and identify the file that was made executable.
- Investigate the origin of the `chmod` command by reviewing the process tree to understand which parent process initiated it and whether it aligns with expected behavior.
- Check the user account or service account that executed the `chmod` command to assess if it has legitimate access and reason to modify file permissions.
- Analyze the file that was made executable to determine its contents and origin, checking for any signs of unauthorized or malicious code.
- Correlate this event with other logs or alerts from the same container to identify any patterns or additional suspicious activities that might indicate a broader attack.


### False positive analysis

- Routine maintenance scripts or automated processes may use chmod to set execute permissions on files within containers. To handle these, identify and whitelist specific scripts or processes that are known to be safe and necessary for operations.
- Development environments often involve frequent changes to file permissions as developers test and deploy code. Consider excluding specific container IDs or paths associated with development environments to reduce noise.
- Some container orchestration tools might use chmod as part of their normal operation. Review the processes and arguments associated with these tools and create exceptions for known benign activities.
- System updates or package installations within containers might trigger this rule. Monitor and document regular update schedules and processes, and exclude these from triggering alerts if they are verified as non-threatening.
- If certain users or roles are responsible for legitimate permission changes, consider excluding their activities by user ID or role, ensuring that these exclusions are well-documented and reviewed regularly.


### Response and remediation

- Immediately isolate the affected container to prevent further execution of unauthorized code. This can be done by stopping the container or disconnecting it from the network.
- Conduct a thorough review of the container's file system to identify any unauthorized or suspicious files that have been made executable. Remove or quarantine these files as necessary.
- Analyze the container's logs to trace the source of the `chmod` command and determine if there are any other indicators of compromise or related malicious activities.
- If the unauthorized execution is confirmed, assess the potential impact on the host system and other containers. Implement additional security measures, such as enhanced monitoring or network segmentation, to protect other assets.
- Escalate the incident to the security operations team for further investigation and to determine if the threat is part of a larger attack campaign.
- Review and update container security policies to prevent unauthorized permission changes, such as implementing stricter access controls and using security tools that enforce policy compliance.
- Enhance detection capabilities by configuring alerts for similar suspicious activities, ensuring that any future attempts to modify file permissions within containers are promptly identified and addressed.


## Rule Query

```eql
file where host.os.type == "linux" and event.type in ("change", "creation") and (
  process.name == "chmod" or
  (
    /* account for tools that execute utilities as a subprocess, in this case the target utility name will appear as a process arg */
    process.name in ("bash", "dash", "sh", "tcsh", "csh", "zsh", "ksh", "fish", "busybox") and
    process.args in (
      "chmod", "/bin/chmod", "/usr/bin/chmod", "/usr/local/bin/chmod"
    ) and
    /* default exclusion list to not FP on default multi-process commands */
    not process.args in (
      "which", "/bin/which", "/usr/bin/which", "/usr/local/bin/which",
      "man", "/bin/man", "/usr/bin/man", "/usr/local/bin/man"
    )
  )
) and process.args in ("4755", "755", "777", "0777", "444", "+x", "a+x") and
process.args like ("/dev/shm/*", "/tmp/*", "/var/tmp/*", "/run/*", "/var/run/*", "/mnt/*", "/media/*") and
process.interactive == true and container.id like "*" and not process.args == "-x"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: File and Directory Permissions Modification
- Id: T1222
- Reference URL: [[https://attack.mitre.org/techniques/T1222/](https://attack.mitre.org/techniques/T1222/)](https://attack.mitre.org/techniques/T1222/)
- Sub Technique:
  - Name: Linux and Mac File and Directory Permissions Modification
- Id: T1222.002
- Reference URL: [[https://attack.mitre.org/techniques/T1222/002/](https://attack.mitre.org/techniques/T1222/002/)](https://attack.mitre.org/techniques/T1222/002/)