﻿---
title: Netcat File Transfer or Listener Detected via Defend for Containers
description: This rule detects an established netcat file transfer or listener running inside a container. Netcat is a utility used for reading and writing data across...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/execution_netcat_listener_established_inside_a_container
products:
  - Elastic Security
---

# Netcat File Transfer or Listener Detected via Defend for Containers
This rule detects an established netcat file transfer or listener running inside a container. Netcat is a utility
used for reading and writing data across network connections, and it can be used for malicious purposes such as
establishing a backdoor for persistence, exfiltrating data or file transfer.
**Rule type**: eql
**Rule indices**:
- logs-cloud_defend.process*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 5m
**Searches indices from**: `now-6m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Data Source: Elastic Defend for Containers
- Domain: Container
- OS: Linux
- Use Case: Threat Detection
- Tactic: Execution
- Resources: Investigation Guide

**Version**: 104
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Setup


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Netcat File Transfer or Listener Detected via Defend for Containers

Netcat is a versatile networking tool used for reading and writing data across network connections, often employed for legitimate purposes like debugging and network diagnostics. However, adversaries can exploit Netcat to establish unauthorized backdoors or exfiltrate data from containers. The detection rule identifies suspicious Netcat activity by monitoring process events within containers, focusing on specific arguments that indicate a listening state, which is a common trait of malicious use. This proactive detection helps mitigate potential threats by flagging unusual network behavior indicative of compromise.

### Possible investigation steps

- Review the container ID associated with the alert to identify the specific container where the Netcat listener was established. This can help in understanding the context and potential impact.
- Examine the process name and arguments to confirm the presence of Netcat and its listening state. Look for arguments like "-l", "--listen", "-p", or "--source-port" to verify the listener setup.
- Check the parent process of the Netcat instance to determine how it was initiated. This can provide insights into whether it was started by a legitimate application or a potentially malicious script.
- Investigate the network connections associated with the container to identify any unusual or unauthorized connections that may indicate data exfiltration or communication with a command and control server.
- Analyze the container's recent activity and logs to identify any other suspicious behavior or anomalies that could be related to the Netcat listener, such as unexpected file modifications or other process executions.
- Assess the container's security posture and configuration to determine if there are any vulnerabilities or misconfigurations that could have been exploited to establish the Netcat listener.


### False positive analysis

- Development and testing activities within containers may trigger the rule if Netcat is used for legitimate debugging or network diagnostics. Users can create exceptions for specific container IDs or process names associated with known development environments.
- Automated scripts or tools that utilize Netcat for routine network checks or health monitoring might be flagged. To mitigate this, users can whitelist these scripts by identifying their unique process arguments or execution patterns.
- Containers running network services that rely on Netcat for legitimate communication purposes could be mistakenly identified. Users should document and exclude these services by specifying their container IDs and associated process arguments.
- Security tools or monitoring solutions that incorporate Netcat for legitimate scanning or testing purposes may cause false positives. Users can manage this by excluding these tools based on their known process names and arguments.


### Response and remediation

- Immediately isolate the affected container to prevent further unauthorized access or data exfiltration. This can be done by stopping the container or disconnecting it from the network.
- Conduct a thorough review of the container's logs and process history to identify any unauthorized access or data transfers that may have occurred.
- Remove any unauthorized Netcat binaries or scripts found within the container to eliminate the backdoor.
- Rebuild the container from a known good image to ensure no residual malicious artifacts remain.
- Update container images and underlying host systems with the latest security patches to mitigate vulnerabilities that could be exploited by similar threats.
- Implement network segmentation and firewall rules to restrict unauthorized outbound connections from containers, reducing the risk of data exfiltration.
- Escalate the incident to the security operations team for further investigation and to assess the potential impact on other containers or systems within the environment.


## Rule Query

```eql
process where host.os.type == "linux" and event.type == "start" and event.action == "exec" and (
  process.name in ("nc","ncat","netcat","netcat.openbsd","netcat.traditional") or
  (
    /* account for tools that execute utilities as a subprocess, in this case the target utility name will appear as a process arg */
    process.name in ("bash", "dash", "sh", "tcsh", "csh", "zsh", "ksh", "fish", "busybox") and
    process.args in (
      "nc", "/bin/nc", "/usr/bin/nc", "/usr/local/bin/nc",
      "ncat", "/bin/ncat", "/usr/bin/ncat", "/usr/local/bin/ncat",
      "netcat", "/bin/netcat", "/usr/bin/netcat", "/usr/local/bin/netcat",
      "netcat.openbsd", "/bin/netcat.openbsd", "/usr/bin/netcat.openbsd", "/usr/local/bin/netcat.openbsd",
      "netcat.traditional", "/bin/netcat.traditional", "/usr/bin/netcat.traditional", "/usr/local/bin/netcat.traditional"
    ) and 
    /* default exclusion list to not FP on default multi-process commands */
    not process.args in (
      "which", "/bin/which", "/usr/bin/which", "/usr/local/bin/which",
      "man", "/bin/man", "/usr/bin/man", "/usr/local/bin/man",
      "chmod", "/bin/chmod", "/usr/bin/chmod", "/usr/local/bin/chmod",
      "chown", "/bin/chown", "/usr/bin/chown", "/usr/local/bin/chown"
    )
  )
) and
process.args like~ (
  /* bind shell to specific port or listener */
  "-*l*","-*p*",
  /* reverse shell to command-line interpreter used for command execution */
  "-*e*",
  /* file transfer via stdout/pipe */
  ">","<", "|"
) and process.interactive == true and container.id like "*"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)
- Sub Technique:
  - Name: Unix Shell
- Id: T1059.004
- Reference URL: [[https://attack.mitre.org/techniques/T1059/004/](https://attack.mitre.org/techniques/T1059/004/)](https://attack.mitre.org/techniques/T1059/004/)