﻿---
title: System Path File Creation and Execution Detected via Defend for Containers
description: This rule detects when an interactive process creates a file inside of a system binary location, inside of a running container. The system binary locations...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/execution_interactive_file_creation_in_system_binary_locations
products:
  - Elastic Security
---

# System Path File Creation and Execution Detected via Defend for Containers
This rule detects when an interactive process creates a file inside of a system binary location, inside of a running
container. The system binary locations are /etc, /root, /bin, /usr/bin, /usr/local/bin, and /entrypoint. Adversaries
may use these locations to create files that can be used to execute commands on the underlying host, or to evade
detection by security controls.
**Rule type**: eql
**Rule indices**:
- logs-cloud_defend.file*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 5m
**Searches indices from**: `now-6m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Data Source: Elastic Defend for Containers
- Domain: Container
- OS: Linux
- Use Case: Threat Detection
- Tactic: Execution
- Tactic: Command and Control
- Tactic: Defense Evasion
- Resources: Investigation Guide

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating System Path File Creation and Execution Detected via Defend for Containers

This detects an interactive session in a running Linux container creating new files under system binary paths like /etc, /root, /bin, /usr/bin, /usr/local/bin, or /entrypoint, which often signals an attempt to tamper with execution flow or hide tooling. Attackers commonly gain a shell, then use curl/wget (or a busybox variant) from a writable staging area to drop a new executable into /usr/local/bin or overwrite an entrypoint script to ensure their code runs on start.

### Possible investigation steps

- Capture the created file’s metadata (owner, permissions, timestamps) and contents/hash, then determine whether it is an executable/script or a modification to startup/auth/config behavior.
- Compare the file and its path against the container image baseline (layer diff) to confirm it was introduced at runtime and identify the interactive command that created it.
- Review the interactive session context (TTY, user, entry method) and surrounding command activity to assess intent and whether secrets or credentials were accessed.
- Pivot to related activity from the same session such as outbound connections, additional downloads to writable staging areas, or subsequent execution of the new file to gauge impact and scope.
- Check for persistence or host-impact setup by inspecting entrypoint/service definitions, PATH hijacks, mounted host paths, and any new cron/systemd/profile changes within the container.


### False positive analysis

- A container administrator troubleshooting interactively may use curl/wget (including via busybox wget) to fetch configuration or helper scripts and write them into /etc, /root, or /entrypoint to quickly test startup or runtime behavior changes.
- An interactive maintenance session may execute a script staged in /tmp or /dev/shm that drops a small wrapper binary or symlink into /usr/local/bin or /usr/bin to temporarily add debugging utilities or adjust PATH-resolved command behavior during incident response.


### Response and remediation

- Isolate the impacted container by removing it from service and blocking its egress, then preserve the container filesystem (or take a snapshot) so the created artifacts under /etc, /root, /bin, /usr/bin, /usr/local/bin, or /entrypoint can be analyzed.
- Identify and remove the dropped or modified file(s) and any related persistence (e.g., altered /entrypoint script, PATH-hijacking binaries, modified shell profiles), then stop any processes launched from writable staging paths like /tmp, /dev/shm, /var/tmp, /run, /var/run, or /mnt.
- Redeploy the workload from a known-good image and verified configuration (including entrypoint and mounted volumes), rotate any secrets or tokens that could have been accessed in the interactive session, and validate the new pod/container does not recreate files in system binary locations.
- Escalate immediately to the incident response team if the created file is executable, replaces an entrypoint, initiates outbound downloads or connections, or if multiple containers show similar drops in system binary paths suggesting broader compromise.
- Harden by enforcing non-root, read-only root filesystem, and disallowing interactive exec into production containers, then restrict outbound network access and block write access to system binary locations via security policies and runtime controls.


## Rule Query

```eql
file where host.os.type == "linux" and event.type == "creation" and process.interactive == true and
file.path like (
  "/etc/*", "/root/*", "/bin/*", "/usr/bin/*", "/usr/local/bin/*", "/entrypoint*"
) and (
  process.name like ("wget", "curl") or
  (process.name == "busybox" and process.args == "wget") or
  process.executable like ("/tmp/*", "/dev/shm/*", "/var/tmp/*", "/run/*", "/var/run/*", "/mnt/*")
) and container.id like "?*"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)
- Sub Technique:
  - Name: Unix Shell
- Id: T1059.004
- Reference URL: [[https://attack.mitre.org/techniques/T1059/004/](https://attack.mitre.org/techniques/T1059/004/)](https://attack.mitre.org/techniques/T1059/004/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Command and Control
- Id: TA0011
- Reference URL: [[https://attack.mitre.org/tactics/TA0011/](https://attack.mitre.org/tactics/TA0011/)](https://attack.mitre.org/tactics/TA0011/)
- Technique:
  - Name: Application Layer Protocol
- Id: T1071
- Reference URL: [[https://attack.mitre.org/techniques/T1071/](https://attack.mitre.org/techniques/T1071/)](https://attack.mitre.org/techniques/T1071/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)