﻿---
title: File Creation and Execution Detected via Defend for Containers
description: This rule detects when an interactive process creates a file inside of a running container, followed by its execution. This could indicate a potential...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/execution_interactive_file_creation_followed_by_execution
products:
  - Elastic Security
---

# File Creation and Execution Detected via Defend for Containers
This rule detects when an interactive process creates a file inside of a running container, followed by its execution.
This could indicate a potential container breakout attempt, an attacker's attempt to gain unauthorized access to the
underlying host, or to evade detection by security controls.
**Rule type**: eql
**Rule indices**:
- logs-cloud_defend.process*
- logs-cloud_defend.file*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 5m
**Searches indices from**: `now-6m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Data Source: Elastic Defend for Containers
- Domain: Container
- OS: Linux
- Use Case: Threat Detection
- Tactic: Execution
- Tactic: Command and Control
- Resources: Investigation Guide

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating File Creation and Execution Detected via Defend for Containers

This detects an interactive session inside a running Linux container creating a new file and then executing it moments later, a pattern that often signals hands-on intrusion rather than routine automation. Attackers commonly use an `exec` shell into a pod/container to drop a small script or ELF payload (for reverse shell, credential theft, or host discovery) and run it immediately to establish control or stage a breakout attempt.

### Possible investigation steps

- Correlate the alert time with container runtime and Kubernetes audit logs to identify who started the interactive session (user/service account), from where (source IP), and via what mechanism (kubectl exec/attach, docker exec).
- Acquire the newly created file from the container filesystem, record hash/size/permissions, and analyze its contents to determine whether it is a script, ELF payload, or staged dropper.
- Reconstruct the execution chain by reviewing the process tree and interactive shell artifacts (TTY, environment, shell history) to understand the operator’s commands before and after running the file.
- Inspect the container’s network activity immediately following execution (DNS lookups, new outbound connections, unusual ports/destinations) to confirm or rule out command-and-control or payload download behavior.
- Validate whether the activity indicates privilege escalation or breakout by checking the node and container for access to sensitive host interfaces (e.g., docker.sock, hostPath mounts, /proc probing) and contain the workload if present.


### False positive analysis

- A developer or SRE uses an interactive shell in the container to create or modify a script/binary for debugging (e.g., `cat`/heredoc/vim writing to `/tmp` or the app directory) and then immediately runs it to reproduce an issue or validate a fix.
- An operator performs interactive break-glass maintenance by manually writing a short helper script (log collection, configuration validation, one-off remediation) inside the container and executing it right after creation to restore service during an incident.


### Response and remediation

- Immediately isolate the affected workload by cordoning and draining the node or applying a deny-all network policy to the pod/namespace, then terminate the interactive session and stop the container to prevent further execution.
- Preserve evidence by snapshotting the container filesystem and collecting the created file and any adjacent artifacts (shell history, temp directories, downloaded tools), then compute hashes and submit the file for malware analysis.
- Eradicate by deleting the compromised pod/container and redeploying from a known-good image, rotating any credentials that may have been exposed in the container environment, and blocking the observed outbound destinations if C2 behavior is present.
- Escalate to incident response immediately if the executed file attempts host interaction (e.g., accesses docker.sock, /proc, hostPath mounts) or if you observe new privileged containers, node-level processes, or lateral movement to other pods/namespaces.
- Harden by restricting interactive exec/attach to a small admin group with MFA, enforcing Pod Security/Admission policies to disallow privileged/host mounts, and enabling runtime controls to block execution from writable paths like /tmp and /dev/shm.


## Rule Query

```eql
sequence by container.id, user.id with maxspan=3s
  [file where host.os.type == "linux" and event.type == "creation" and process.interactive == true and container.id like "?*" and
   file.path like ("/tmp/*", "/var/tmp/*", "/dev/shm/*", "/root/*", "/home/*") and
   not process.name in ("apt", "apt-get", "dnf", "microdnf", "yum", "zypper", "tdnf", "apk", "pacman", "rpm", "dpkg")] by file.path
  [process where host.os.type == "linux" and event.type == "start" and event.action == "exec" and
   process.interactive == true and container.id like "?*"] by process.executable
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)
- Sub Technique:
  - Name: Unix Shell
- Id: T1059.004
- Reference URL: [[https://attack.mitre.org/techniques/T1059/004/](https://attack.mitre.org/techniques/T1059/004/)](https://attack.mitre.org/techniques/T1059/004/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Command and Control
- Id: TA0011
- Reference URL: [[https://attack.mitre.org/tactics/TA0011/](https://attack.mitre.org/tactics/TA0011/)](https://attack.mitre.org/tactics/TA0011/)
- Technique:
  - Name: Application Layer Protocol
- Id: T1071
- Reference URL: [[https://attack.mitre.org/techniques/T1071/](https://attack.mitre.org/techniques/T1071/)](https://attack.mitre.org/techniques/T1071/)