﻿---
title: Container Management Utility Execution Detected via Defend for Containers
description: This rule detects when a container management binary is run from inside a container. These binaries are critical components of many containerized environments,...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/execution_container_management_binary_launched_inside_a_container
products:
  - Elastic Security
---

# Container Management Utility Execution Detected via Defend for Containers
This rule detects when a container management binary is run from inside a container. These binaries are critical
components of many containerized environments, and their presence and execution in unauthorized containers could
indicate compromise or a misconfiguration.
**Rule type**: eql
**Rule indices**:
- logs-cloud_defend.process*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 5m
**Searches indices from**: `now-6m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Data Source: Elastic Defend for Containers
- Domain: Container
- OS: Linux
- Use Case: Threat Detection
- Tactic: Execution
- Resources: Investigation Guide

**Version**: 104
**Rule authors**:
- Elastic

**Rule license**: Elastic Licence v2

## Investigation guide


## Setup


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Container Management Utility Execution Detected via Defend for Containers

Container management utilities like Docker and Kubernetes are essential for orchestrating and managing containerized applications. They facilitate tasks such as deployment, scaling, and networking. However, adversaries can exploit these tools to execute unauthorized commands within containers, potentially leading to system compromise. The detection rule identifies suspicious execution of these utilities within containers, signaling possible misuse or misconfiguration, by monitoring specific process activities and event types.

### Possible investigation steps

- Review the specific container ID where the suspicious process was executed to determine its purpose and origin.
- Examine the process name and command line arguments to understand the context of the execution and identify any anomalies or unauthorized commands.
- Check the user and permissions associated with the process to assess if it aligns with expected roles and access levels for container management tasks.
- Investigate the container's creation and deployment history to identify any recent changes or deployments that could explain the presence of the management utility.
- Analyze network activity associated with the container to detect any unusual connections or data transfers that might indicate malicious activity.
- Correlate the event with other security alerts or logs to identify patterns or related incidents that could provide additional context or evidence of compromise.


### False positive analysis

- Routine maintenance tasks within containers can trigger the rule. Exclude known maintenance scripts or processes by adding them to an allowlist if they frequently execute container management utilities.
- Development and testing environments often run container management commands for legitimate purposes. Consider excluding these environments from monitoring or adjust the rule to focus on production environments only.
- Automated deployment tools may execute container management commands as part of their workflow. Identify these tools and create exceptions for their activities to prevent false positives.
- System updates or patches might involve running container management utilities. Monitor update schedules and temporarily adjust the rule to avoid unnecessary alerts during these periods.
- Legitimate administrative actions by authorized personnel can trigger the rule. Implement user-based exceptions for known administrators to reduce false positives while maintaining security oversight.


### Response and remediation

- Immediately isolate the affected container to prevent further unauthorized access or execution of commands. This can be done by stopping the container or disconnecting it from the network.
- Review the container's configuration and access controls to identify any misconfigurations or unauthorized access permissions that may have allowed the execution of container management utilities.
- Conduct a thorough analysis of the container's logs and process activities to determine the extent of the compromise and identify any additional malicious activities or lateral movement attempts.
- Remove any unauthorized or suspicious binaries and scripts from the container to prevent further exploitation.
- Patch and update the container image and underlying host system to address any known vulnerabilities that may have been exploited.
- Implement stricter access controls and monitoring on container management utilities to ensure they are only accessible by authorized users and processes.
- Escalate the incident to the security operations team for further investigation and to assess the need for broader security measures across the container environment.


## Rule Query

```eql
process where host.os.type == "linux" and event.type == "start" and event.action == "exec" and (
  process.name in ("dockerd", "kubelet", "kube-proxy", "kubectl", "containerd", "systemd", "crictl") or
  (
    /* Account for tools that execute utilities as a subprocess, in this case the target utility name will appear as a process arg */
    process.name in ("bash", "dash", "sh", "tcsh", "csh", "zsh", "ksh", "fish", "busybox") and
    process.args in (
      "dockerd", "/bin/dockerd", "/usr/bin/dockerd", "/usr/local/bin/dockerd",
      "kubelet", "/bin/kubelet", "/usr/bin/kubelet", "/usr/local/bin/kubelet",
      "kube-proxy", "/bin/kube-proxy", "/usr/bin/kube-proxy", "/usr/local/bin/kube-proxy",
      "kubectl", "/bin/kubectl", "/usr/bin/kubectl", "/usr/local/bin/kubectl",
      "containerd", "/bin/containerd", "/usr/bin/containerd", "/usr/local/bin/containerd",
      "systemd", "/bin/systemd", "/usr/bin/systemd", "/usr/local/bin/systemd",
      "crictl", "/bin/crictl", "/usr/bin/crictl", "/usr/local/bin/crictl"
    ) and 
    /* default exclusion list to not FP on default multi-process commands */
    not process.args in (
      "which", "/bin/which", "/usr/bin/which", "/usr/local/bin/which",
      "man", "/bin/man", "/usr/bin/man", "/usr/local/bin/man",
      "chmod", "/bin/chmod", "/usr/bin/chmod", "/usr/local/bin/chmod",
      "chown", "/bin/chown", "/usr/bin/chown", "/usr/local/bin/chown"
    )
  )
) and
process.interactive == true and container.id like "*" and
not (
  process.parent.executable in ("/sbin/init", "/usr/bin/dockerd", "/usr/bin/runc", "/usr/bin/containerd-shim-runc-v2") or
  process.working_directory == "/aws" or
  (process.parent.args == "init" and process.parent.args == "runc") or
  (process.parent.name == "busybox" and process.name == "kubectl")
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Container Administration Command
- Id: T1609
- Reference URL: [[https://attack.mitre.org/techniques/T1609/](https://attack.mitre.org/techniques/T1609/)](https://attack.mitre.org/techniques/T1609/)