﻿---
title: Suspicious Network Tool Launch Detected via Defend for Containers
description: This rule detects commonly abused network utilities running inside a container. Network utilities like nc, nmap, dig, tcpdump, ngrep, telnet, mitmproxy,...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/discovery_suspicious_network_tool_launched_inside_a_container
products:
  - Elastic Security
---

# Suspicious Network Tool Launch Detected via Defend for Containers
This rule detects commonly abused network utilities running inside a container. Network utilities like nc, nmap, dig,
tcpdump, ngrep, telnet, mitmproxy, zmap can be used for malicious purposes such as network reconnaissance, monitoring,
or exploitation, and should be monitored closely within a container.
**Rule type**: eql
**Rule indices**:
- logs-cloud_defend.process*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 5m
**Searches indices from**: `now-6m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Data Source: Elastic Defend for Containers
- Domain: Container
- OS: Linux
- Use Case: Threat Detection
- Tactic: Discovery
- Tactic: Command and Control
- Tactic: Reconnaissance
- Resources: Investigation Guide

**Version**: 104
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Setup


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Suspicious Network Tool Launch Detected via Defend for Containers

Containers are lightweight, portable units that encapsulate applications and their dependencies, often used to ensure consistent environments across development and production. Adversaries exploit network tools within containers for reconnaissance or lateral movement, leveraging utilities like `nc` or `nmap` to map networks or intercept traffic. The detection rule identifies these tools' execution by monitoring process starts and arguments, flagging potential misuse for further investigation.

### Possible investigation steps

- Review the container ID and process name from the alert to identify which container and network tool triggered the alert.
- Examine the process arguments to understand the specific command or options used, which may provide insight into the intent of the tool's execution.
- Check the container's creation and modification timestamps to determine if the container was recently deployed or altered, which could indicate suspicious activity.
- Investigate the user or service account associated with the process start event to assess if it aligns with expected behavior or if it might be compromised.
- Analyze network logs and traffic patterns from the container to identify any unusual outbound connections or data exfiltration attempts.
- Correlate the alert with other security events or logs from the same container or host to identify potential lateral movement or further malicious activity.


### False positive analysis

- Development and testing environments often use network tools for legitimate purposes such as debugging or network configuration. To manage this, create exceptions for containers identified as part of these environments by tagging them appropriately and excluding them from the rule.
- Automated scripts or orchestration tools may trigger network utilities for routine checks or maintenance tasks. Identify these scripts and whitelist their associated container IDs or process names to prevent false alerts.
- Some monitoring solutions deploy containers with built-in network tools for performance analysis. Verify the legitimacy of these containers and exclude them from the rule by using specific labels or container IDs.
- Containers used for educational or training purposes might intentionally run network tools. Ensure these containers are marked and excluded from detection by setting up rules based on their unique identifiers or labels.


### Response and remediation

- Immediately isolate the affected container to prevent further network reconnaissance or lateral movement. This can be done by restricting its network access or stopping the container entirely.
- Conduct a thorough review of the container's logs and process history to identify any unauthorized access or data exfiltration attempts. Focus on the execution of the flagged network utilities.
- Remove any unauthorized or suspicious network tools from the container to prevent further misuse. Ensure that only necessary and approved utilities are present.
- Patch and update the container image to address any vulnerabilities that may have been exploited. Rebuild and redeploy the container using the updated image.
- Implement network segmentation to limit the container's access to sensitive resources and reduce the potential impact of similar threats in the future.
- Enhance monitoring and alerting for the execution of network utilities within containers, ensuring that any future occurrences are detected promptly.
- Escalate the incident to the security operations team for further investigation and to determine if additional systems or containers have been compromised.


## Rule Query

```eql
process where host.os.type == "linux" and event.type == "start" and event.action == "exec" and (
  process.name in (
    "nc.traditional", "nc", "ncat", "netcat", "nmap", "tcpdump", "tshark", "ngrep", "telnet",  "mitmproxy", "socat",
    "zmap", "masscan", "zgrab"
  ) or
  (
    /* Account for tools that execute utilities as a subprocess, in this case the target utility name will appear as a process arg */
    process.name in ("bash", "dash", "sh", "tcsh", "csh", "zsh", "ksh", "fish", "busybox") and
    process.args in (
      "nc.traditional", "/bin/nc.traditional", "/usr/bin/nc.traditional", "/usr/local/bin/nc.traditional",
      "nc", "/bin/nc", "/usr/bin/nc", "/usr/local/bin/nc",
      "ncat", "/bin/ncat", "/usr/bin/ncat", "/usr/local/bin/ncat",
      "netcat", "/bin/netcat", "/usr/bin/netcat", "/usr/local/bin/netcat",
      "nmap", "/bin/nmap", "/usr/bin/nmap", "/usr/local/bin/nmap",
      "tcpdump", "/bin/tcpdump", "/usr/bin/tcpdump", "/usr/local/bin/tcpdump",
      "tshark", "/bin/tshark", "/usr/bin/tshark", "/usr/local/bin/tshark",
      "ngrep", "/bin/ngrep", "/usr/bin/ngrep", "/usr/local/bin/ngrep",
      "telnet", "/bin/telnet", "/usr/bin/telnet", "/usr/local/bin/telnet",
      "mitmproxy", "/bin/mitmproxy", "/usr/bin/mitmproxy", "/usr/local/bin/mitmproxy",
      "socat", "/bin/socat", "/usr/bin/socat", "/usr/local/bin/socat",
      "zmap", "/bin/zmap", "/usr/bin/zmap", "/usr/local/bin/zmap",
      "masscan", "/bin/masscan", "/usr/bin/masscan", "/usr/local/bin/masscan",
      "zgrab", "/bin/zgrab", "/usr/bin/zgrab", "/usr/local/bin/zgrab"
    ) and 
    /* default exclusion list to not FP on default multi-process commands */
    not process.args in (
      "which", "/bin/which", "/usr/bin/which", "/usr/local/bin/which",
      "man", "/bin/man", "/usr/bin/man", "/usr/local/bin/man",
      "chmod", "/bin/chmod", "/usr/bin/chmod", "/usr/local/bin/chmod",
      "chown", "/bin/chown", "/usr/bin/chown", "/usr/local/bin/chown"
    )
  )
) and process.interactive == true and container.id like "*" and
not (
  process.name in ("nc.traditional", "nc", "ncat", "netcat") and
  process.args like ("-*z*", "localhost", "127.0.0.1")
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Discovery
- Id: TA0007
- Reference URL: [[https://attack.mitre.org/tactics/TA0007/](https://attack.mitre.org/tactics/TA0007/)](https://attack.mitre.org/tactics/TA0007/)
- Technique:
  - Name: Network Service Discovery
- Id: T1046
- Reference URL: [[https://attack.mitre.org/techniques/T1046/](https://attack.mitre.org/techniques/T1046/)](https://attack.mitre.org/techniques/T1046/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Command and Control
- Id: TA0011
- Reference URL: [[https://attack.mitre.org/tactics/TA0011/](https://attack.mitre.org/tactics/TA0011/)](https://attack.mitre.org/tactics/TA0011/)
- Technique:
  - Name: Ingress Tool Transfer
- Id: T1105
- Reference URL: [[https://attack.mitre.org/techniques/T1105/](https://attack.mitre.org/techniques/T1105/)](https://attack.mitre.org/techniques/T1105/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Reconnaissance
- Id: TA0043
- Reference URL: [[https://attack.mitre.org/tactics/TA0043/](https://attack.mitre.org/tactics/TA0043/)](https://attack.mitre.org/tactics/TA0043/)
- Technique:
  - Name: Active Scanning
- Id: T1595
- Reference URL: [[https://attack.mitre.org/techniques/T1595/](https://attack.mitre.org/techniques/T1595/)](https://attack.mitre.org/techniques/T1595/)