﻿---
title: Service Account Namespace Read Detected via Defend for Containers
description: This rule detects the reading of the service account namespace file inside a container. The service account namespace file is used to identify the namespace...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/discovery_service_account_namespace_read
products:
  - Elastic Security
---

# Service Account Namespace Read Detected via Defend for Containers
This rule detects the reading of the service account namespace file inside a container. The service account namespace file
is used to identify the namespace of the container in which it is running, and may be used by an adversary to get a better
understanding of the container and the services running inside it.
**Rule type**: eql
**Rule indices**:
- logs-cloud_defend.file*
- logs-cloud_defend.process*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 5m
**Searches indices from**: `now-6m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Data Source: Elastic Defend for Containers
- Domain: Container
- OS: Linux
- Use Case: Threat Detection
- Tactic: Discovery
- Resources: Investigation Guide

**Version**: 2
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Service Account Namespace Read Detected via Defend for Containers

This rule flags an interactive process inside a container opening /var/run/secrets/kubernetes.io/serviceaccount/namespace, which reveals the pod’s Kubernetes namespace; adversaries use this quick check to orient themselves and scope discovery. A common pattern is: after landing a shell in a pod, the attacker reads the namespace file, then issues namespace-scoped kubectl or direct API calls to list Deployments, Secrets, and ServiceAccounts, map privileges and service endpoints, and plan targeted lateral movement within that namespace.

### Possible investigation steps

- Build the process tree and shell session timeline around the event to identify the parent and child processes, interactive TTY, and exact commands executed before and after.
- Map the container to its pod, namespace, node, image, owner, and service account, and verify whether any kubectl exec/attach or debug container activity targeting this pod is expected at that time.
- Correlate Kubernetes audit logs for that service account and pod around the timestamp to spot list/get calls, Secrets or ServiceAccounts enumeration, and the user/IP that initiated any exec/attach.
- Inspect network flows and DNS from the container to the Kubernetes API server immediately after the event to confirm follow-on API access or token validation attempts.
- Review the service account’s RBAC bindings and search the container for reads of the token/ca.crt or the presence of kubectl/kubeconfig or scripts that could leverage the token.


### False positive analysis

- During legitimate troubleshooting, a user opens an interactive shell in the container and the shell’s profile or prompt customization reads /var/run/secrets/kubernetes.io/serviceaccount/namespace to display the current namespace.
- A documented operational check or training exercise instructs staff to manually open the service account namespace file inside a container to confirm the environment before changes, producing a benign detection.


### Response and remediation

- Immediately kill the interactive shell process inside the container (e.g., bash/sh attached via kubectl exec) and quarantine the pod/namespace by applying a deny-all NetworkPolicy and pausing the owning Deployment/StatefulSet.
- Escalate to a major incident and page the on-call cluster security team if you observe subsequent reads of /var/run/secrets/kubernetes.io/serviceaccount/token or ca.crt or API calls from the pod to the Kubernetes API (443) that list Secrets or ServiceAccounts.
- Rotate the service account credentials by deleting the pod to force a new projected token, set automountServiceAccountToken: false on the workload if not needed, and remove pods/exec and pods/attach privileges from users or roles that accessed this pod.
- Redeploy the workload from a trusted, signed image without embedded shells/kubectl, verify image digest on rollout, and only lift quarantine after confirming no unauthorized containers, cronjobs, or startup scripts were added.
- Enforce least-privilege RBAC for the service account (deny list/get on Secrets, ConfigMaps, and Pods in the namespace), enable Pod Security Admission restricted with readOnlyRootFilesystem and dropped Linux capabilities, and require approvals for kubectl exec using ephemeral containers for debugging.


## Rule Query

```eql
any where host.os.type == "linux" and process.interactive == true and container.id like "*" and (
  (event.category == "file" and event.type == "change" and event.action == "open" and
  file.path in (
    "/var/run/secrets/kubernetes.io/serviceaccount/namespace",
    "/run/secrets/kubernetes.io/serviceaccount/namespace"
  )) or
  (event.category == "process" and event.type == "start" and event.action == "exec" and
  (
    process.name in ("cat", "head", "tail", "more", "less", "sed", "awk") or
    process.args in (
      "cat", "/bin/cat", "/usr/bin/cat", "/usr/local/bin/cat",
      "head", "/bin/head", "/usr/bin/head", "/usr/local/bin/head",
      "tail", "/bin/tail", "/usr/bin/tail", "/usr/local/bin/tail",
      "more", "/bin/more", "/usr/bin/more", "/usr/local/bin/more",
      "less", "/bin/less", "/usr/bin/less", "/usr/local/bin/less",
      "sed", "/bin/sed", "/usr/bin/sed", "/usr/local/bin/sed",
      "awk", "/bin/awk", "/usr/bin/awk", "/usr/local/bin/awk"
    )
  ) and process.args like "*/run/secrets/kubernetes.io/serviceaccount/namespace*"
    )
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Discovery
- Id: TA0007
- Reference URL: [[https://attack.mitre.org/tactics/TA0007/](https://attack.mitre.org/tactics/TA0007/)](https://attack.mitre.org/tactics/TA0007/)
- Technique:
  - Name: Container and Resource Discovery
- Id: T1613
- Reference URL: [[https://attack.mitre.org/techniques/T1613/](https://attack.mitre.org/techniques/T1613/)](https://attack.mitre.org/techniques/T1613/)
- Technique:
  - Name: System Information Discovery
- Id: T1082
- Reference URL: [[https://attack.mitre.org/techniques/T1082/](https://attack.mitre.org/techniques/T1082/)](https://attack.mitre.org/techniques/T1082/)