﻿---
title: Potential Cluster Enumeration via jq Detected via Defend for Containers
description: This rule detects the enumeration of the cluster by the "jq" command inside a container. The "jq" command is used to parse JSON data, and may be used...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/discovery_potential_cluster_enumeration_via_jq
products:
  - Elastic Security
---

# Potential Cluster Enumeration via jq Detected via Defend for Containers
This rule detects the enumeration of the cluster by the "jq" command inside a container. The "jq" command is used to
parse JSON data, and may be used by an adversary to gain information about the cluster and the services running inside it.
This behavior is uncommon for interactive shells within a container, and is commonly leveraged by attackers to help parse
cluster information in a more readable format, or set the output as environment variables.
**Rule type**: eql
**Rule indices**:
- logs-cloud_defend.process*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 5m
**Searches indices from**: `now-6m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Data Source: Elastic Defend for Containers
- Domain: Container
- OS: Linux
- Use Case: Threat Detection
- Tactic: Discovery
- Resources: Investigation Guide

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```eql
process where host.os.type == "linux" and event.type == "start" and event.action == "exec" and process.name == "jq" and
process.interactive == true and container.id like "?*" 
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Discovery
- Id: TA0007
- Reference URL: [[https://attack.mitre.org/tactics/TA0007/](https://attack.mitre.org/tactics/TA0007/)](https://attack.mitre.org/tactics/TA0007/)
- Technique:
  - Name: Container and Resource Discovery
- Id: T1613
- Reference URL: [[https://attack.mitre.org/techniques/T1613/](https://attack.mitre.org/techniques/T1613/)](https://attack.mitre.org/techniques/T1613/)