﻿---
title: Environment Variable Enumeration Detected via Defend for Containers
description: This rule detects the execution of the "env" or "printenv" commands inside a container. The "env" command is used to display all the environment variables...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/discovery_environment_enumeration
products:
  - Elastic Security
---

# Environment Variable Enumeration Detected via Defend for Containers
This rule detects the execution of the "env" or "printenv" commands inside a container. The "env" command is used
to display all the environment variables for the current shell, and the "printenv" command is used to print the
values of environment variables. These commands are used to enumerate the environment variables of the container,
which can be used by an adversary to gain information about the container and the services running inside it.
**Rule type**: eql
**Rule indices**:
- logs-cloud_defend.process*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 5m
**Searches indices from**: `now-6m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Data Source: Elastic Defend for Containers
- Domain: Container
- OS: Linux
- Use Case: Threat Detection
- Tactic: Discovery
- Resources: Investigation Guide

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Environment Variable Enumeration Detected via Defend for Containers

This rule flags interactive execution of env or printenv inside a Linux container, a common discovery step to expose environment variables that frequently store credentials, tokens, and service configuration. A typical pattern: after gaining shell access to a pod, the attacker lists variables to harvest cloud keys, Kubernetes service account tokens, database URLs, and internal endpoints, enabling authenticated API calls, lateral movement within the cluster, or exfiltration via trusted services.

### Possible investigation steps

- Correlate with Kubernetes audit logs (exec/attach or debug) to identify the initiator identity, source IP, and command, and confirm whether the session was expected.
- Review the pod/container context (namespace, deployment, image digest/tag, node, and service account) and compare against baselines to catch unusual targets or ephemeral/privileged debug containers.
- Retrieve the enumerated variables to spot high-risk secrets such as cloud credentials, database passwords, or tokens, and immediately rotate/disable any discovered keys while reviewing provider audit logs for post-alert use.
- Trace subsequent activity within the container after the event for credential usage or exfiltration, including access to 169.254.169.254/metadata, calls to Kubernetes/cloud APIs, outbound network connections, or tooling like curl, wget, base64, and grep.
- Pivot to related signals on the same pod or node around the timestamp (new shells, service account token file reads, package installs, or suspicious downloads) to determine if this is part of a broader compromise.


### False positive analysis

- An operator opens an interactive shell in a container during routine troubleshooting and runs env or printenv to verify configuration, service endpoints, feature flags, or propagated secrets.
- Interactive shell initialization or entrypoint scripts in certain base images automatically invoke env or printenv upon TTY login to display or log variables, producing this event in benign sessions.


### Response and remediation

- Quarantine the affected pod where env/printenv was run by deleting the pod to drop the interactive session, applying a deny-all egress NetworkPolicy targeting its labels, and temporarily blocking kubectl exec/attach to that workload.
- Immediately rotate any secrets exposed in that container’s environment (cloud access keys, database passwords, API tokens, Kubernetes service account token), revoke active sessions at providers, and invalidate cached credentials on dependent services.
- Redeploy the application from a verified image digest with a fresh service account and newly issued secrets, and remove debug images or shell entrypoints that enabled interactive access.
- Escalate to incident response if env output contained credentials or the pod’s IP contacted 169.254.169.254, cloud/Kubernetes APIs, or external endpoints after the enumeration, indicating possible secret use or exfiltration.
- Replace environment-based secret injection with a secrets manager or projected volumes, set automountServiceAccountToken to false where not required, right-size RBAC for the workload, and block egress to the metadata service and the internet.
- Enforce preventive controls by disabling kubectl exec/attach for production (break-glass only with approval), enabling admission policies to block images with shells or package managers, and adding runtime rules to alert on interactive env/printenv followed by curl/wget/base64 or token file reads.


## Rule Query

```eql
process where host.os.type == "linux" and event.type == "start" and event.action == "exec" and (
  process.name in ("env", "printenv") or
  (
    /* Account for tools that execute utilities as a subprocess, in this case the target utility name will appear as a process arg */
    process.name in ("bash", "dash", "sh", "tcsh", "csh", "zsh", "ksh", "fish", "busybox") and
    process.args in (
      "env", "/bin/env", "/usr/bin/env", "/usr/local/bin/env",
      "printenv", "/bin/printenv", "/usr/bin/printenv", "/usr/local/bin/printenv"
    ) and
    /* default exclusion list to not FP on default multi-process commands */
    not process.args in (
      "which", "/bin/which", "/usr/bin/which", "/usr/local/bin/which",
      "man", "/bin/man", "/usr/bin/man", "/usr/local/bin/man",
      "chmod", "/bin/chmod", "/usr/bin/chmod", "/usr/local/bin/chmod",
      "chown", "/bin/chown", "/usr/bin/chown", "/usr/local/bin/chown"
    )
  )
) and
process.interactive == true and container.id like "*"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Discovery
- Id: TA0007
- Reference URL: [[https://attack.mitre.org/tactics/TA0007/](https://attack.mitre.org/tactics/TA0007/)](https://attack.mitre.org/tactics/TA0007/)
- Technique:
  - Name: Container and Resource Discovery
- Id: T1613
- Reference URL: [[https://attack.mitre.org/techniques/T1613/](https://attack.mitre.org/techniques/T1613/)](https://attack.mitre.org/techniques/T1613/)
- Technique:
  - Name: System Information Discovery
- Id: T1082
- Reference URL: [[https://attack.mitre.org/techniques/T1082/](https://attack.mitre.org/techniques/T1082/)](https://attack.mitre.org/techniques/T1082/)