﻿---
title: DNS Enumeration Detected via Defend for Containers
description: This rule detects the execution of DNS enumeration tools inside a container. DNS enumeration tools are used to enumerate the DNS servers and domains of...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/discovery_dns_enumeration
products:
  - Elastic Security
---

# DNS Enumeration Detected via Defend for Containers
This rule detects the execution of DNS enumeration tools inside a container. DNS enumeration tools are used to
enumerate the DNS servers and domains of the container, which can be used by an adversary to gain information about
the network configuration of the container and the services running inside it.
**Rule type**: eql
**Rule indices**:
- logs-cloud_defend.process*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 5m
**Searches indices from**: `now-6m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Data Source: Elastic Defend for Containers
- Domain: Container
- OS: Linux
- Use Case: Threat Detection
- Tactic: Discovery
- Resources: Investigation Guide

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating DNS Enumeration Detected via Defend for Containers

This rule flags interactive use of DNS utilities (nslookup, dig, host, or getent hosts) inside a Linux container that query internal Kubernetes names such as kubernetes.default or *.svc.cluster.local, signaling in-cluster service discovery. After compromising a pod, an attacker opens an interactive shell and runs nslookup kubernetes.default or dig *.svc.cluster.local to enumerate services and namespaces, map reachable endpoints, and stage lateral movement toward the API server, internal dashboards, or other pods.

### Possible investigation steps

- Correlate with Kubernetes audit logs to see if a kubectl exec/attach or ephemeral container was launched into this pod at the same time and identify the requesting user, source IP, and service account identity.
- Pull pod metadata (namespace, owner workload, node, image digest, service account) and verify whether this is a sanctioned troubleshooting/debug context by checking image baseline and change tickets.
- Examine command history and process lineage within the container around the alert to spot follow‑on actions such as reading /var/run/secrets/kubernetes.io/serviceaccount, querying the API server, installing tools, or scanning internal ranges.
- Review DNS and network telemetry from the pod (CoreDNS logs, CNI flow logs) to map the queried hostnames and any subsequent connections to internal services or the API server.
- If unauthorized activity is suspected, isolate the pod via network policy or eviction, rotate the pod’s service account token and related secrets, and redeploy from a trusted image while investigating node and registry access paths.


### False positive analysis

- An authorized operator attaches an interactive shell to a pod for in-cluster troubleshooting and runs nslookup/dig/host or getent hosts against kubernetes.default or *.svc.cluster.local, matching the rule but expected.
- A pod or initContainer configured with tty: true or stdin enabled executes startup/readiness logic that calls getent hosts or nslookup on internal service FQDNs (*.svc.cluster.local), which is benign but appears as interactive enumeration.


### Response and remediation

- Immediately isolate the affected pod by applying a deny‑egress NetworkPolicy to the CoreDNS service and cluster service CIDRs, terminate the interactive shell that ran nslookup/dig/host or getent hosts, and temporarily block kubectl exec/attach to the workload.
- Evict the pod and redeploy from a trusted image digest, removing any ephemeral containers added for debugging and uninstalling ad‑hoc packages (e.g., dnsutils, busybox) that were introduced into the container.
- Rotate credentials by deleting and reissuing the workload’s service account token and any mounted secrets or registry credentials, then verify the new pod does not perform interactive lookups of kubernetes.default or *.svc.cluster.local.
- Escalate to incident response if enumeration originates from a production namespace, a privileged service account, or is followed by reading /var/run/secrets/kubernetes.io/serviceaccount or curl/wget to [https://kubernetes.default](https://kubernetes.default), or if similar activity is observed across multiple pods.
- Harden going forward by restricting exec/attach via RBAC, enforcing Admission Controls/Pod Security to disallow tty/stdin and unauthorized ephemeral containers, limiting egress to CoreDNS and internal services with NetworkPolicies, and using distroless/stripped images that omit nslookup/dig/host.


## Rule Query

```eql
process where host.os.type == "linux" and event.type == "start" and event.action == "exec" and
process.interactive == true and container.id like "*" and 
(
  /* getent hosts is often used without a target arg */
  (process.name == "getent" and process.args == "hosts") or

  /* explicit DNS query tools */
  (
    process.name in ("nslookup", "dig", "host") or
    (
      /* Account for tools that execute utilities as a subprocess, in this case the target utility name will appear as a process arg */
      process.name in ("bash", "dash", "sh", "tcsh", "csh", "zsh", "ksh", "fish", "busybox") and
      process.args in (
        "nslookup", "/bin/nslookup", "/usr/bin/nslookup", "/usr/local/bin/nslookup",
        "dig", "/bin/dig", "/usr/bin/dig", "/usr/local/bin/dig",
        "host", "/bin/host", "/usr/bin/host", "/usr/local/bin/host"
      ) and
      /* default exclusion list to not FP on default multi-process commands */
      not process.args in (
        "which", "/bin/which", "/usr/bin/which", "/usr/local/bin/which",
        "man", "/bin/man", "/usr/bin/man", "/usr/local/bin/man",
        "chmod", "/bin/chmod", "/usr/bin/chmod", "/usr/local/bin/chmod",
        "chown", "/bin/chown", "/usr/bin/chown", "/usr/local/bin/chown"
      )
    )
  ) and
  process.args like~ (
    "kubernetes.default",
    "kubernetes",
    "*.svc",
    "*.svc.cluster.local",
    "*.cluster.local"
  )
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Discovery
- Id: TA0007
- Reference URL: [[https://attack.mitre.org/tactics/TA0007/](https://attack.mitre.org/tactics/TA0007/)](https://attack.mitre.org/tactics/TA0007/)
- Technique:
  - Name: Remote System Discovery
- Id: T1018
- Reference URL: [[https://attack.mitre.org/techniques/T1018/](https://attack.mitre.org/techniques/T1018/)](https://attack.mitre.org/techniques/T1018/)
- Technique:
  - Name: Container and Resource Discovery
- Id: T1613
- Reference URL: [[https://attack.mitre.org/techniques/T1613/](https://attack.mitre.org/techniques/T1613/)](https://attack.mitre.org/techniques/T1613/)
- Technique:
  - Name: System Network Configuration Discovery
- Id: T1016
- Reference URL: [[https://attack.mitre.org/techniques/T1016/](https://attack.mitre.org/techniques/T1016/)](https://attack.mitre.org/techniques/T1016/)
- Technique:
  - Name: System Network Connections Discovery
- Id: T1049
- Reference URL: [[https://attack.mitre.org/techniques/T1049/](https://attack.mitre.org/techniques/T1049/)](https://attack.mitre.org/techniques/T1049/)