﻿---
title: Encoded Payload Detected via Defend for Containers
description: This rule detects the interactive execution of potential defense evasion techniques via encoded payloads inside a container. Attackers may use base64...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/defense_evasion_potential_evasion_via_encoded_payload
products:
  - Elastic Security
---

# Encoded Payload Detected via Defend for Containers
This rule detects the interactive execution of potential defense evasion techniques via encoded payloads
inside a container. Attackers may use base64 encoding/decoding to obfuscate data, such as command and
control traffic or payloads, to evade detection by host- or network-based security controls.
**Rule type**: eql
**Rule indices**:
- logs-cloud_defend.process*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 5m
**Searches indices from**: `now-6m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Data Source: Elastic Defend for Containers
- Domain: Container
- OS: Linux
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Tactic: Execution
- Resources: Investigation Guide

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Encoded Payload Detected via Defend for Containers

This rule flags interactive runs of common encoding/decoding tools and language one-liners inside Linux containers, a frequent way to hide commands or payloads from basic inspection. It matters because obfuscated content can bypass simple detections and enable in-container execution, staging, or covert command-and-control. A typical pattern is an attacker exec’ing into a running container, pasting a base64 blob, decoding it with base64/openssl or a Python/Perl/Ruby snippet, then piping the result into sh or writing a dropper for immediate execution.

### Possible investigation steps

- Identify the decoded artifact by correlating the decode process with adjacent interactive commands (pipes, redirects, file writes) and recover the resulting plaintext/script from file system, shell history, or captured stdout/stderr.
- Determine what executed next by building a short timeline of subsequent process starts in the same container/session (e.g., sh/bash, curl/wget, chmod, execution of newly created files) and assess whether the decoded content was run.
- Validate whether the interactive session is expected by reviewing who initiated the container exec/attach (user, source IP, kube-apiserver/audit logs) and whether it aligns with approved operational access patterns.
- Check for persistence or lateral movement attempts by looking for creation/modification of cron entries, new users/SSH keys, altered entrypoints, mounted secrets access, or unexpected network connections from the container after the decode.
- Contain and scope by snapshotting the container image/filesystem for forensic preservation, then searching other workloads/namespaces for the same encoded blob, hash, or command pattern to identify spread or repeated operator activity.


### False positive analysis

- A developer or SRE may interactively exec into a container to quickly decode base64/hex configuration snippets, certificates, or API responses (e.g., Kubernetes secrets) for troubleshooting, which matches the rule’s interactive decode patterns.
- An on-call engineer may run interactive one-liners in python/perl/ruby or use openssl/xxd inside a container to validate encodings, inspect binary payloads, or test application parsing behavior during incident triage, creating benign decode activity that resembles obfuscation.


### Response and remediation

- Quarantine the affected workload by isolating the pod/container from the network and preventing further interactive exec/attach (cordon the node if needed) while preserving the running container state for evidence.
- Capture and retain forensic artifacts including the decoded output/script, any newly written files, shell history and stdout/stderr from the interactive session, and a snapshot of the container filesystem/image for offline analysis and hash extraction.
- Eradicate by deleting and redeploying the pod from a known-good image, removing any malicious files or altered entrypoints/configmaps/secrets discovered during review, and rotating any credentials or tokens that the container could access.
- Escalate immediately to IR/Cloud Security if the decoded content triggers execution (piped into sh/bash), pulls remote payloads (curl/wget), or results in outbound connections to unknown hosts, or if similar decode activity is found across multiple namespaces.
- Harden by enforcing RBAC to restrict exec/attach, enabling admission controls to block privileged pods and risky host mounts, reducing image toolsets (remove base64/openssl/xxd where feasible), and adding egress controls to limit outbound traffic to approved destinations.


## Rule Query

```eql
process where host.os.type == "linux" and event.type == "start" and event.action == "exec" and process.interactive == true and (
  (process.name in ("base64", "base64plain", "base64url", "base64mime", "base64pem", "base32", "base16") and process.args like~ "*-*d*") or
  (process.name == "xxd" and process.args like~ ("-*r*", "-*p*")) or
  (process.name == "openssl" and process.args == "enc" and process.args in ("-d", "-base64", "-a")) or
  (process.name like "python*" and (
    (process.args == "base64" and process.args in ("-d", "-u", "-t")) or
    (process.args == "-c" and process.args like "*base64*" and process.args like "*b64decode*")
  )) or
  (process.name like "perl*" and process.args like "*decode_base64*") or
  (process.name like "ruby*" and process.args == "-e" and process.args like "*Base64.decode64*")
) and container.id like "?*"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Obfuscated Files or Information
- Id: T1027
- Reference URL: [[https://attack.mitre.org/techniques/T1027/](https://attack.mitre.org/techniques/T1027/)](https://attack.mitre.org/techniques/T1027/)
- Technique:
  - Name: Deobfuscate/Decode Files or Information
- Id: T1140
- Reference URL: [[https://attack.mitre.org/techniques/T1140/](https://attack.mitre.org/techniques/T1140/)](https://attack.mitre.org/techniques/T1140/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)
- Sub Technique:
  - Name: Unix Shell
- Id: T1059.004
- Reference URL: [[https://attack.mitre.org/techniques/T1059/004/](https://attack.mitre.org/techniques/T1059/004/)](https://attack.mitre.org/techniques/T1059/004/)
- Technique:
  - Name: User Execution
- Id: T1204
- Reference URL: [[https://attack.mitre.org/techniques/T1204/](https://attack.mitre.org/techniques/T1204/)](https://attack.mitre.org/techniques/T1204/)
- Sub Technique:
  - Name: Malicious File
- Id: T1204.002
- Reference URL: [[https://attack.mitre.org/techniques/T1204/002/](https://attack.mitre.org/techniques/T1204/002/)](https://attack.mitre.org/techniques/T1204/002/)