﻿---
title: Dynamic Linker Modification Detected via Defend for Containers
description: This rule detects the creation or modification of the dynamic linker preload shared object (ld.so.preload) inside a container. The Linux dynamic linker...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/defense_evasion_ld_preload_shared_object_modified_inside_a_container
products:
  - Elastic Security
---

# Dynamic Linker Modification Detected via Defend for Containers
This rule detects the creation or modification of the dynamic linker preload shared object (ld.so.preload) inside a
container. The Linux dynamic linker is used to load libraries needed by a program at runtime. Adversaries may hijack the
dynamic linker by modifying the /etc/ld.so.preload file to point to malicious libraries. This behavior can be used to
grant unauthorized access to system resources and has been used to evade detection of malicious processes in container
environments.
**Rule type**: eql
**Rule indices**:
- logs-cloud_defend.file*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 5m
**Searches indices from**: `now-6m`
**Maximum alerts per execution**: 100
**References**:
- [[https://unit42.paloaltonetworks.com/hildegard-malware-teamtnt/](https://unit42.paloaltonetworks.com/hildegard-malware-teamtnt/)](https://unit42.paloaltonetworks.com/hildegard-malware-teamtnt/)
- [[https://www.anomali.com/blog/rocke-evolves-its-arsenal-with-a-new-malware-family-written-in-golang/](https://www.anomali.com/blog/rocke-evolves-its-arsenal-with-a-new-malware-family-written-in-golang/)](https://www.anomali.com/blog/rocke-evolves-its-arsenal-with-a-new-malware-family-written-in-golang/)
- [[https://sysdig.com/blog/threat-detection-aws-cloud-containers/](https://sysdig.com/blog/threat-detection-aws-cloud-containers/)](https://sysdig.com/blog/threat-detection-aws-cloud-containers/)

**Tags**:
- Data Source: Elastic Defend for Containers
- Domain: Container
- OS: Linux
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Resources: Investigation Guide

**Version**: 103
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Setup


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Dynamic Linker Modification Detected via Defend for Containers

The dynamic linker in Linux loads necessary libraries for programs at runtime, with the `ld.so.preload` file specifying libraries to load first. Adversaries exploit this by redirecting it to malicious libraries, gaining unauthorized access and evading detection. The detection rule identifies suspicious modifications to this file within containers, signaling potential hijacking attempts.

### Possible investigation steps

- Review the alert details to confirm the file path involved is "/etc/ld.so.preload", "/etc/ld.so.conf.d/*", or "/etc/ld.so.conf" and the event type is not "deletion", as specified in the query.
- Examine the container's metadata and context to identify the specific container where the modification occurred, including container ID, image, and host details.
- Investigate recent changes to the "/etc/ld.so.preload" file within the container by checking the file's modification history and identifying the user or process responsible for the change.
- Analyze the contents of the modified "/etc/ld.so.preload" file to determine if it references any suspicious or unauthorized libraries.
- Correlate the event with other security logs and alerts to identify any related suspicious activities or patterns, such as unauthorized access attempts or execution of unknown processes within the container.
- Assess the potential impact of the modification by evaluating the libraries listed in the preload file and their potential to grant unauthorized access or evade detection.
- Consider isolating the affected container to prevent further unauthorized access or malicious activity while the investigation is ongoing.


### False positive analysis

- Routine system updates or maintenance activities may modify the ld.so.preload file. Users should verify if the changes coincide with scheduled updates and consider excluding these events if they are confirmed to be benign.
- Some containerized applications might legitimately modify the ld.so.preload file to optimize performance or load specific libraries. Users should identify these applications and create exceptions for their known behaviors to prevent false alerts.
- Automated configuration management tools might alter the ld.so.preload file as part of their normal operations. Users should review the tool's activity logs and whitelist these actions if they are consistent with expected behavior.
- Development or testing environments often involve frequent changes to system files, including ld.so.preload. Users should differentiate between production and non-production environments and apply more lenient rules to the latter to reduce false positives.


### Response and remediation

- Immediately isolate the affected container to prevent further unauthorized access or execution of malicious code. This can be done by stopping the container or disconnecting it from the network.
- Conduct a thorough review of the `/etc/ld.so.preload`, `/etc/ld.so.conf.d/*`, or `/etc/ld.so.conf` files within the container to identify any unauthorized or malicious entries. Remove any entries that are not recognized or are confirmed to be malicious.
- Verify the integrity of the container's base image and all installed libraries to ensure no other components have been tampered with. Rebuild the container from a trusted image if necessary.
- Implement monitoring and alerting for any future modifications to the `/etc/ld.so.preload`, `/etc/ld.so.conf.d/*`, or `/etc/ld.so.conf` file across all containers to detect similar threats promptly.
- Review and tighten access controls and permissions for container environments to minimize the risk of unauthorized modifications to critical system files.
- Escalate the incident to the security operations team for further investigation and to determine if the threat has spread to other parts of the infrastructure.
- Document the incident, including the steps taken for containment and remediation, to improve response strategies and update incident response plans for future reference.


## Rule Query

```eql
file where host.os.type == "linux" and event.type != "deletion" and
file.path like ("/etc/ld.so.preload", "/etc/ld.so.conf.d/*", "/etc/ld.so.conf") and
process.interactive == true and container.id like "*" 
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Hijack Execution Flow
- Id: T1574
- Reference URL: [[https://attack.mitre.org/techniques/T1574/](https://attack.mitre.org/techniques/T1574/)](https://attack.mitre.org/techniques/T1574/)
- Sub Technique:
  - Name: Dynamic Linker Hijacking
- Id: T1574.006
- Reference URL: [[https://attack.mitre.org/techniques/T1574/006/](https://attack.mitre.org/techniques/T1574/006/)](https://attack.mitre.org/techniques/T1574/006/)